!Object constantsFor: 'Geos Libraries'!

geosLIB0 'SYSTEM\geos'! !

!Object constantsFor: 'Geos vardata'!

tempMetaGcn 0!
tempMetaQuitList 4!
detachData 8!
tempEcInUseCount 12!
tempEcInteractibleCount 16!
tempMetaEnsureActiveFtLayerPriorityPreference 20!
debugMetaObjDuplicateResourceInfo 24!
!

!Object constantsFor: 'Geos messages'!

null 0!
initialize 1!
reserved_1 2!
dummy 3!
appStartup 4!
attach 5!
attachProcess 5!
attachGenprocessclass 5!
attachObject 5!
attachThread 5!
detach 6!
detachComplete 7!
detachAbort 8!
ack 9!
appShutdown 10!
shutdownComplete 11!
shutdownAck 12!
getClass 13!
isObjectInClass 14!
blockFree 15!
objFree 16!
finalObjFree 17!
decBlockRefCount 18!
resolveVariantSuperclass 19!
relocate 20!
unrelocate 21!
leaveConstrain 22!
setFlags 23!
getFlags 24!
vmFileDirty 25!
quit 26!
quitProcess 26!
quitObject 26!
quitAck 27!
dispatchEvent 28!
sendClassedEvent 29!
getOptr 30!
getTargetAtTargetLevel 31!
addVarData 32!
deleteVarData 33!
initializeVarData 34!
notify 35!
notifyWithDataBlock 36!
gcnListAdd 37!
gcnListRemove 38!
gcnListSend 39!
gcnListDestroy 40!
saveOptions 41!
getIniCategory 42!
suspend 43!
unsuspend 44!
loadOptions 45!
getVarData 46!
notifyObjBlockInteractible 47!
notifyObjBlockNotInteractible 48!
objFlushInputQueue 49!
winDecRefCount 50!
updateWindow 51!
finishQuit 52!
setObjBlockOutput 53!
getHelpFile 54!
getHelpType 55!
getObjBlockOutput 56!
resetOptions 57!
bringUpHelp 58!
setHelpFile 59!
gcnListFindItem 60!
transparentDetach 61!
removingDisk 62!
vmFileSetInitialDirtyLimit 63!
vmFileAutoSave 64!
exposed 69!
exposedForPrint 70!
winUpdateComplete 71!
winUnused_2 72!
winChange 73!
impliedWinChange 74!
rawUnivEnter 75!
rawUnivLeave 76!
unused_1 77!
invalTree 78!
invalBounds 79!
mouseButton 117!
mousePtr 118!
kbdChar 119!
pressure 120!
direction 121!
mouseTimer 122!
mouseDrag 123!
clipboardNotifyQuickTransferFeedback 165!
clipboardNotifyQuickTransferConcluded 166!
clipboardCut 168!
clipboardCopy 169!
clipboardPaste 170!
undo 171!
undoFreeingAction 172!
selectAll 173!
delete 174!
clipboardNotifyTransferItemFreed 175!
clipboardNotifyNormalTransferItemChanged 176!
contentSetView 177!
contentViewOpening 178!
contentViewClosing 179!
contentViewWinOpened 180!
contentViewWinClosed 181!
contentViewOriginChanged 182!
contentViewScaleFactorChanged 183!
contentViewSizeChanged 184!
contentTrackScrolling 185!
contentViewLostGadgetExcl 186!
contentNavigationQuery 187!
contentApplyDefaultFocus 188!
contentEnter 189!
contentLeave 190!
docOutputInitializeDocumentFile 191!
docOutputCreateUiForDocument 192!
docOutputDestroyUiForDocument 193!
docOutputAttachUiToDocument 194!
docOutputDetachUiFromDocument 195!
docOutputReadCachedDataFromFile 196!
docOutputWriteCachedDataToFile 197!
docOutputDocumentHasChanged 198!
docOutputPhysicalSave 199!
docOutputPhysicalUpdate 200!
docOutputPhysicalSaveAsFileHandle 201!
docOutputPhysicalRevert 202!
docOutputUpdateEarlierCompatibleDocument 203!
docOutputUpdateEarlierIncompatibleDocument 204!
docOutputSaveAsCompleted 205!
docOutputAttachFailed 206!
docOutputPhysicalRevertToAutoSave 207!
unusedMetaUi_11 208!
unusedMetaUi_12 209!
unusedMetaUi_13 210!
unusedMetaUi_14 211!
unusedMetaUi_15 212!
unusedMetaUi_16 213!
unusedMetaUi_17 214!
unusedMetaUi_18 215!
unusedMetaUi_19 216!
unusedMetaUi_20 217!
uiForceControllerUpdate 218!
genPathRestoreDiskPrompt 219!
pagedObjectGotoPage 220!
pagedObjectNextPage 221!
pagedObjectPreviousPage 222!
notifyTaskSelected 223!
gainedMouseExcl 224!
lostMouseExcl 225!
gainedKbdExcl 226!
lostKbdExcl 227!
gainedPressureExcl 228!
lostPressureExcl 229!
gainedDirectionExcl 230!
lostDirectionExcl 231!
grabFocusExcl 232!
releaseFocusExcl 233!
getFocusExcl 234!
grabTargetExcl 235!
releaseTargetExcl 236!
getTargetExcl 237!
grabModelExcl 238!
releaseModelExcl 239!
getModelExcl 240!
releaseFtExcl 241!
mupAlterFtvmcExcl 242!
gainedFocusExcl 243!
lostFocusExcl 244!
gainedSysFocusExcl 245!
lostSysFocusExcl 246!
gainedTargetExcl 247!
lostTargetExcl 248!
gainedSysTargetExcl 249!
lostSysTargetExcl 250!
gainedModelExcl 251!
lostModelExcl 252!
gainedSysModelExcl 253!
lostSysModelExcl 254!
querySaveDocuments 255!
broadcastReturningToWelcome 256!
gainedDefaultExcl 257!
lostDefaultExcl 258!
mouseBumpNotification 259!
fupKbdChar 260!
prePassiveKbdChar 261!
postPassiveKbdChar 262!
queryIfPressIsInk 263!
largeQueryIfPressIsInk 264!
startSelect 265!
endSelect 266!
startMoveCopy 267!
endMoveCopy 268!
startFeatures 269!
endFeatures 270!
startOther 271!
endOther 272!
dragSelect 273!
dragMoveCopy 274!
dragFeatures 275!
dragOther 276!
prePassiveButton 277!
postPassiveButton 278!
prePassiveStartSelect 279!
prePassiveEndSelect 280!
prePassiveStartMoveCopy 281!
prePassiveEndMoveCopy 282!
prePassiveStartFeatures 283!
prePassiveEndFeatures 284!
prePassiveStartOther 285!
prePassiveEndOther 286!
postPassiveStartSelect 287!
postPassiveEndSelect 288!
postPassiveStartMoveCopy 289!
postPassiveEndMoveCopy 290!
postPassiveStartFeatures 291!
postPassiveEndFeatures 292!
postPassiveStartOther 293!
postPassiveEndOther 294!
largePtr 295!
largeStartSelect 296!
largeEndSelect 297!
largeStartMoveCopy 298!
largeEndMoveCopy 299!
largeStartFeatures 300!
largeEndFeatures 301!
largeStartOther 302!
largeEndOther 303!
largeDragSelect 304!
largeDragMoveCopy 305!
largeDragFeatures 306!
largeDragOther 307!
ensureMouseNotActivelyTrespassing 308!
ensureNoMenusInStayUpMode 309!
ensureActiveFt 310!
notifyNoFocusWithinNode 311!
docOutputImportFile 312!
docOutputExportFile 313!
grabKbd 314!
forceGrabKbd 315!
releaseKbd 316!
viewCommandChangeScale 317!
fieldNotifyDetach 318!
fieldNotifyNoFocus 319!
fieldNotifyStartLauncherError 320!
deleteRangeOfChars 321!
testWinInteractibility 322!
checkIfInteractableObject 323!
gainedFullScreenExcl 324!
lostFullScreenExcl 325!
actionNotification 549!
verifyPrintRequest 597!
startPrinting 598!
getDocName 599!
notifyPrintDb 600!
notifyPrintJobCreated 601!
reportPageSize 602!
msgSearch 645!
current 646!
allOccurrences 647!
allOccurrencesInSelection 648!
activeSpell 649!
activeSearch 650!
getObjectForSearchSpell 651!
getContext 652!
generateContextNotification 653!
context 654!
displayObjectForSearchSpell 655!
check 656!
editUserDictionaryCompleted 657!
replaceSelectedWords 658!
selectWord 659!
fileChange 693!
driveChange 694!
appStarted 695!
appExited 696!
dateTimeChange 697!
userDictChange 698!
keyboardLayoutChange 699!
expressMenuChange 700!
installedRemoved 701!
confirmShutdown 702!
inkRedisplay 703!
dialogInitialized 704!
jobCancelled 705!
statusChange 706!
textSetFontId 741!
textSetFontWeight 742!
textSetFontWidth 743!
textSetPointSize 744!
textSetSmallerPointSize 745!
textSetLargerPointSize 746!
textSetTextStyle 747!
textSetColor 748!
textSetGrayScreen 749!
textSetPattern 750!
textSetCharBgColor 751!
textSetCharBgGrayScreen 752!
textSetCharBgPattern 753!
textSetTrackKerning 754!
textSetBorderColor 755!
textSetBorderGrayScreen 756!
textSetBorderPattern 757!
textSetParaAttributes 758!
textUserModified 759!
textCrFiltered 760!
textTabFiltered 761!
textLostFocus 762!
textGainedFocus 763!
textLostTarget 764!
textGainedTarget 765!
textEmptyStatusChanged 766!
textNotUserModified 767!
textSetTextMiscMode 768!
textSetHyperlink 769!
textFollowHyperlink 770!
styledObjectRequestEntryMoniker 789!
styledObjectUpdateModifyBox 790!
styledObjectModifyStyle 791!
styledObjectDescribeAttrs 792!
styledObjectDescribeStyle 793!
styledObjectApplyStyle 794!
styledObjectDeleteStyle 795!
styledObjectDefineStyle 796!
styledObjectRedefineStyle 797!
styledObjectReturnToBaseStyle 798!
styledObjectLoadStyleSheet 799!
styledObjectSaveStyle 800!
styledObjectRecallStyle 801!
coloredObjectSetColor 837!
coloredObjectSetDrawMask 838!
coloredObjectSetPattern 839!
ctrlRequestMoniker 885!
ctrlUpdateUi 886!
ctrlFormatSelected 887!
ctrlUserDefInvoke 888!
ctrlUserDefOk 889!
ctrlFormatDelete 890!
ctrlReplaceNumFormat 891!
ctrlFormatApply 892!
replaceTextSelection 933!
iacpProcessMessage 981!
iacpNewConnection 982!
iacpLostConnection 983!
iacpShutdownConnection 984!
iacpDocOpenAck 985!
iacpDocCloseAck 986!
iacpAllowFileAccess 987!
iacpNotifyFileAccessFinished 988!
mailboxCreateMessage 1029!
mailboxMessageRegistered 1030!
mailboxNotifyMessageAvailable 1031!
notifyProcessExit 8192!
notifyThreadExit 8193!
memFull 8194!
createUiThread 8195!
createEventThread 8196!
instantiate 8197!
exit 8198!
startupUiThread 8199!
copyChunkIn 8200!
copyChunkInFromOptr 8200!
copyChunkInFromFptr 8200!
copyChunkInFromHptr 8200!
copyChunkOver 8201!
copyChunkOverOptr 8201!
copyChunkOverFptr 8201!
copyChunkOverHptr 8201!
copyChunkOut 8202!
copyChunkOutToOptr 8202!
copyChunkOutToFptr 8202!
copyChunkOutToHptr 8202!
flushProcessQueue 8203!
finalBlockFree 8204!
callRoutine 8205!
createEventThreadWithOwner 8206!
objBlockDiscard 8207!
!

!Geos class methodsFor: 'library calls'!

ThreadGetError
	"word pascal ThreadGetError(void) in geos.h"
	^GEOS call: #[0 3 68 1]!

ThreadSetError: errno
	"void pascal ThreadSetError(word errno) in geos.h"
	^GEOS call: errno with: #[0 6 204 1 0]!

isalnum: __c
	"int pascal isalnum(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 46 1 4]!

isalpha: __c
	"int pascal isalpha(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 8 1 4]!

iscntrl: __c
	"int pascal iscntrl(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 43 1 4]!

isdigit: __c
	"int pascal isdigit(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 44 1 4]!

isgraph: __c
	"int pascal isgraph(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 48 1 4]!

islower: __c
	"int pascal islower(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 7 1 4]!

isprint: __c
	"int pascal isprint(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 47 1 4]!

ispunct: __c
	"int pascal ispunct(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 9 1 4]!

isspace: __c
	"int pascal isspace(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 10 1 4]!

isupper: __c
	"int pascal isupper(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 6 1 4]!

isxdigit: __c
	"int pascal isxdigit(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 45 1 4]!

toupper: __c
	"int pascal toupper(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 0 1 4]!

tolower: __c
	"int pascal tolower(unsigned int __c) in ansi/ctype.h"
	^GEOS call: __c with: #[0 4 1 1 4]!

GeodeLoad: name with: attrMatch with: attrNoMatch with: priority with: appInfo with: err
	"GeodeHandle pascal GeodeLoad(const char *name, GeodeAttrs attrMatch, GeodeAttrs attrNoMatch, word priority, dword appInfo, GeodeLoadError *err) in geode.h"
	^GEOS call: name with: attrMatch with: attrNoMatch with: priority with: appInfo with: err with: #[0 3 151 3 1 1 1 2 3 1]!

GeodeAddReference: gh
	"void pascal GeodeAddReference(GeodeHandle gh) in geode.h"
	^GEOS call: gh with: #[0 3 163 1 0]!

GeodeRemoveReference: gh
	"Boolean pascal GeodeRemoveReference(GeodeHandle gh) in geode.h"
	^GEOS call: gh with: #[0 3 164 1 4]!

GeodeFind: name with: numChars with: attrMatch with: attrNoMatch
	"GeodeHandle pascal GeodeFind(const char *name, word numChars, GeodeAttrs attrMatch, GeodeAttrs attrNoMatch) in geode.h"
	^GEOS call: name with: numChars with: attrMatch with: attrNoMatch with: #[0 3 152 3 1 1 1 1]!

GeodeFindResource: file with: resNum with: resOffset with: base
	"word pascal GeodeFindResource(FileHandle file, word resNum, word resOffset, dword *base) in geode.h"
	^GEOS call: file with: resNum with: resOffset with: base with: #[0 3 162 1 1 1 3 1]!

GeodeSnatchResource: file with: resNum with: resOffset
	"MemHandle pascal GeodeSnatchResource(FileHandle file, word resNum, word resOffset) in geode.h"
	^GEOS call: file with: resNum with: resOffset with: #[0 6 226 1 1 1 1]!

GeodeSetGeneralPatchPath
	"Boolean pascal GeodeSetGeneralPatchPath() in geode.h"
	^GEOS call: #[0 6 223 4]!

GeodeSetLanguagePatchPath
	"Boolean pascal GeodeSetLanguagePatchPath() in geode.h"
	^GEOS call: #[0 6 224 4]!

GeodeSetLanguageStandardPath: stdPath
	"Boolean pascal GeodeSetLanguageStandardPath(word stdPath) in geode.h"
	^GEOS call: stdPath with: #[0 6 228 1 4]!

IsMultiLanguageModeOn
	"Boolean pascal IsMultiLanguageModeOn() in geode.h"
	^GEOS call: #[0 6 225 4]!

GeodeGetInfo: gh with: info with: buf
	"word pascal GeodeGetInfo(GeodeHandle gh, GeodeGetInfoType info, void *buf) in geode.h"
	^GEOS call: gh with: info with: buf with: #[0 3 153 1 1 3 1]!

GeodeGetProcessHandle
	"GeodeHandle pascal GeodeGetProcessHandle(void) in geode.h"
	^GEOS call: #[0 3 150 1]!

GeodeGetCodeProcessHandle
	"GeodeHandle pascal GeodeGetCodeProcessHandle(void) in geode.h"
	^GEOS call: #[0 4 180 1]!

GeodeGetAppObject: gh
	"optr pascal GeodeGetAppObject(GeodeHandle gh) in geode.h"
	^GEOS call: gh with: #[0 3 154 1 2]!

GeodeGetUIData: gh
	"word pascal GeodeGetUIData(GeodeHandle gh) in geode.h"
	^GEOS call: gh with: #[0 3 155 1 1]!

GeodeSetUIData: gh with: data
	"void pascal GeodeSetUIData(GeodeHandle gh, word data) in geode.h"
	^GEOS call: gh with: data with: #[0 3 156 1 1 0]!

ProcInfo: gh
	"ThreadHandle pascal ProcInfo(GeodeHandle gh) in geode.h"
	^GEOS call: gh with: #[0 3 157 1 1]!

GeodeAllocQueue
	"QueueHandle pascal GeodeAllocQueue(void) in geode.h"
	^GEOS call: #[0 3 158 1]!

GeodeFreeQueue: qh
	"void pascal GeodeFreeQueue(QueueHandle qh) in geode.h"
	^GEOS call: qh with: #[0 3 159 1 0]!

GeodeInfoQueue: qh
	"word pascal GeodeInfoQueue(QueueHandle qh) in geode.h"
	^GEOS call: qh with: #[0 3 160 1 1]!

GeodeFlushQueue: source with: dest with: obj with: messageFlags
	"void pascal GeodeFlushQueue(QueueHandle source, QueueHandle dest, optr obj, word messageFlags) in geode.h"
	^GEOS call: source with: dest with: obj with: messageFlags with: #[0 3 161 1 1 2 1 0]!

GeodePrivAlloc: gh with: numWords
	"word pascal GeodePrivAlloc(GeodeHandle gh, word numWords) in geode.h"
	^GEOS call: gh with: numWords with: #[0 5 252 1 1 1]!

GeodePrivFree: offset with: numWords
	"void pascal GeodePrivFree(word offset, word numWords) in geode.h"
	^GEOS call: offset with: numWords with: #[0 5 253 1 1 0]!

GeodePrivRead: gh with: offset with: numWords with: dest
	"void pascal GeodePrivRead(GeodeHandle gh, word offset, word numWords, word *dest) in geode.h"
	^GEOS call: gh with: offset with: numWords with: dest with: #[0 6 117 1 1 1 3 0]!

GeodePrivWrite: gh with: offset with: numWords with: src
	"Boolean pascal GeodePrivWrite(GeodeHandle gh, word offset, word numWords, word *src) in geode.h"
	^GEOS call: gh with: offset with: numWords with: src with: #[0 6 118 1 1 1 3 4]!

QueueGetMessage: qh
	"EventHandle pascal QueueGetMessage(QueueHandle qh) in geode.h"
	^GEOS call: qh with: #[0 4 193 1 1]!

QueuePostMessage: qh with: event with: flags
	"void pascal QueuePostMessage(QueueHandle qh, EventHandle event, word flags) in geode.h"
	^GEOS call: qh with: event with: flags with: #[0 4 194 1 1 1 0]!

GeodeRequestSpace: amount with: gh
	"ReservationHandle pascal GeodeRequestSpace(int amount, GeodeHandle gh) in geode.h"
	^GEOS call: amount with: gh with: #[0 6 191 4 1 1]!

GeodeReturnSpace: resv
	"void pascal GeodeReturnSpace(ReservationHandle resv) in geode.h"
	^GEOS call: resv with: #[0 6 193 1 0]!

LMemAlloc: mh with: chunkSize
	"ChunkHandle pascal LMemAlloc(MemHandle mh, word chunkSize) in lmem.h"
	^GEOS call: mh with: chunkSize with: #[0 4 59 1 1 1]!

MemAllocLMem: type with: headerSize
	"MemHandle pascal MemAllocLMem(LMemType type, word headerSize) in lmem.h"
	^GEOS call: type with: headerSize with: #[0 3 92 1 1 1]!

LMemInitHeap: mh with: type with: flags with: lmemOffset with: numHandles with: freeSpace
	"void pascal LMemInitHeap(MemHandle mh, LMemType type, LocalMemoryFlags flags, word lmemOffset, word numHandles, word freeSpace) in lmem.h"
	^GEOS call: mh with: type with: flags with: lmemOffset with: numHandles with: freeSpace with: #[0 4 53 1 1 1 1 1 1 0]!

LMemDeref: o
	"void * pascal LMemDeref(optr o) in lmem.h"
	^GEOS call: o with: #[0 4 61 2 3]!

LMemFree: o
	"void pascal LMemFree(optr o) in lmem.h"
	^GEOS call: o with: #[0 4 60 2 0]!

LMemReAlloc: o with: chunkSize
	"Boolean pascal LMemReAlloc(optr o, word chunkSize) in lmem.h"
	^GEOS call: o with: chunkSize with: #[0 4 54 2 1 4]!

LMemInsertAt: o with: insertOffset with: insertCount
	"Boolean pascal LMemInsertAt(optr o, word insertOffset, word insertCount) in lmem.h"
	^GEOS call: o with: insertOffset with: insertCount with: #[0 4 55 2 1 1 4]!

LMemDeleteAt: o with: deleteOffset with: deleteCount
	"void pascal LMemDeleteAt(optr o, word deleteOffset, word deleteCount) in lmem.h"
	^GEOS call: o with: deleteOffset with: deleteCount with: #[0 4 56 2 1 1 0]!

LMemContract: mh
	"void pascal LMemContract(MemHandle mh) in lmem.h"
	^GEOS call: mh with: #[0 4 57 1 0]!

LMemGetChunkSize: o
	"word pascal LMemGetChunkSize(optr o) in lmem.h"
	^GEOS call: o with: #[0 4 58 2 1]!

CObjMessage
	"dword pascal CObjMessage() in object.h"
	^GEOS call: #[0 4 170 2]!

CObjCallSuper
	"dword pascal CObjCallSuper() in object.h"
	^GEOS call: #[0 4 171 2]!

CMessageDispatch: EventHandle with: MessageFlags with: word
	"dword pascal CMessageDispatch(EventHandle, MessageFlags, word) in object.h"
	^GEOS call: EventHandle with: MessageFlags with: word with: #[0 4 175 1 1 1 2]!

CObjSendToChildren: o with: message with: masterOffset with: compOffset with: linkOffset
	"void pascal CObjSendToChildren(optr o, EventHandle message, word masterOffset, word compOffset, word linkOffset) in object.h"
	^GEOS call: o with: message with: masterOffset with: compOffset with: linkOffset with: #[0 4 176 2 1 1 1 1 0]!

ObjRelocOrUnRelocSuper: oself with: class with: frame
	"Boolean pascal ObjRelocOrUnRelocSuper(optr oself, ClassStruct *class, word frame) in object.h"
	^GEOS call: oself with: class with: frame with: #[0 4 191 2 3 1 4]!

ObjProcBroadcastMessage: event
	"void pascal ObjProcBroadcastMessage(EventHandle event) in object.h"
	^GEOS call: event with: #[0 4 182 1 0]!

ObjInstantiate: block with: class
	"optr pascal ObjInstantiate(MemHandle block, ClassStruct *class) in object.h"
	^GEOS call: block with: class with: #[0 4 181 1 3 2]!

ObjLockObjBlock: mh
	"void * pascal ObjLockObjBlock(MemHandle mh) in object.h"
	^GEOS call: mh with: #[0 4 141 1 3]!

ObjDuplicateResource: blockToDup with: owner with: burdenThread
	"MemHandle pascal ObjDuplicateResource(MemHandle blockToDup, GeodeHandle owner, ThreadHandle burdenThread) in object.h"
	^GEOS call: blockToDup with: owner with: burdenThread with: #[0 4 142 1 1 1 1]!

ObjFreeDuplicate: mh
	"void pascal ObjFreeDuplicate(MemHandle mh) in object.h"
	^GEOS call: mh with: #[0 4 143 1 0]!

ObjFreeChunk: o
	"void pascal ObjFreeChunk(optr o) in object.h"
	^GEOS call: o with: #[0 4 144 2 0]!

ObjIncInUseCount: mh
	"void pascal ObjIncInUseCount(MemHandle mh) in object.h"
	^GEOS call: mh with: #[0 4 149 1 0]!

ObjDecInUseCount: mh
	"void pascal ObjDecInUseCount(MemHandle mh) in object.h"
	^GEOS call: mh with: #[0 4 150 1 0]!

ObjIncInteractibleCount: mh
	"void pascal ObjIncInteractibleCount(MemHandle mh) in object.h"
	^GEOS call: mh with: #[0 4 188 1 0]!

ObjDecInteractibleCount: mh
	"void pascal ObjDecInteractibleCount(MemHandle mh) in object.h"
	^GEOS call: mh with: #[0 4 187 1 0]!

ObjDoRelocation: type with: block with: sourceData with: destData
	"Boolean pascal ObjDoRelocation(ObjRelocationType type, MemHandle block, void *sourceData, void *destData) in object.h"
	^GEOS call: type with: block with: sourceData with: destData with: #[0 4 151 1 1 3 3 4]!

ObjDoUnRelocation: type with: block with: sourceData with: destData
	"Boolean pascal ObjDoUnRelocation(ObjRelocationType type, MemHandle block, void *sourceData, void *destData) in object.h"
	^GEOS call: type with: block with: sourceData with: destData with: #[0 4 152 1 1 3 3 4]!

ObjRelocateEntryPoint: relocData
	"void * pascal ObjRelocateEntryPoint(EntryPointRelocation *relocData) in object.h"
	^GEOS call: relocData with: #[0 4 190 3 3]!

ObjUnRelocateEntryPoint: relocData with: entryPoint
	"void pascal ObjUnRelocateEntryPoint(EntryPointRelocation *relocData, void *entryPoint) in object.h"
	^GEOS call: relocData with: entryPoint with: #[0 4 192 3 3 0]!

ObjResizeMaster: obj with: masterOffset with: newSize
	"void pascal ObjResizeMaster(optr obj, word masterOffset, word newSize) in object.h"
	^GEOS call: obj with: masterOffset with: newSize with: #[0 4 153 2 1 1 0]!

ObjInitializeMaster: obj with: class
	"void pascal ObjInitializeMaster(optr obj, ClassStruct *class) in object.h"
	^GEOS call: obj with: class with: #[0 4 154 2 3 0]!

ObjInitializePart: obj with: masterOffset
	"void pascal ObjInitializePart(optr obj, word masterOffset) in object.h"
	^GEOS call: obj with: masterOffset with: #[0 4 155 2 1 0]!

ObjGetFlags: o
	"ObjChunkFlags pascal ObjGetFlags(optr o) in object.h"
	^GEOS call: o with: #[0 4 145 2 1]!

ObjSetFlags: o with: bitsToSet with: bitsToClear
	"void pascal ObjSetFlags(optr o, ObjChunkFlags bitsToSet, ObjChunkFlags bitsToClear) in object.h"
	^GEOS call: o with: bitsToSet with: bitsToClear with: #[0 4 146 2 1 1 0]!

ObjMarkDirty: o
	"void pascal ObjMarkDirty(optr o) in object.h"
	^GEOS call: o with: #[0 4 147 2 0]!

ObjTestIfObjBlockRunByCurThread: mh
	"Boolean pascal ObjTestIfObjBlockRunByCurThread(MemHandle mh) in object.h"
	^GEOS call: mh with: #[0 4 156 1 4]!

ObjSaveBlock: mh
	"void pascal ObjSaveBlock(MemHandle mh) in object.h"
	^GEOS call: mh with: #[0 4 157 1 0]!

ObjMapSavedToState: mh
	"VMBlockHandle pascal ObjMapSavedToState(MemHandle mh) in object.h"
	^GEOS call: mh with: #[0 4 158 1 1]!

ObjMapStateToSaved: vmbh with: gh
	"MemHandle pascal ObjMapStateToSaved(VMBlockHandle vmbh, GeodeHandle gh) in object.h"
	^GEOS call: vmbh with: gh with: #[0 4 159 1 1 1]!

ObjIsObjectInClass: obj with: class
	"Boolean pascal ObjIsObjectInClass(optr obj, ClassStruct *class) in object.h"
	^GEOS call: obj with: class with: #[0 4 148 2 3 4]!

ObjIsClassADescendant: class1 with: class2
	"Boolean pascal ObjIsClassADescendant(ClassStruct *class1, ClassStruct *class2) in object.h"
	^GEOS call: class1 with: class2 with: #[0 4 189 3 3 4]!

ObjFreeObjBlock: block
	"void pascal ObjFreeObjBlock(MemHandle block) in object.h"
	^GEOS call: block with: #[0 4 184 1 0]!

ObjFreeMessage: event
	"void pascal ObjFreeMessage(EventHandle event) in object.h"
	^GEOS call: event with: #[0 4 172 1 0]!

ObjGetMessageInfo: event with: dest
	"Message pascal ObjGetMessageInfo(EventHandle event, optr *dest) in object.h"
	^GEOS call: event with: dest with: #[0 4 174 1 3 1]!

ObjGetMessageData: event with: data
	"Boolean pascal ObjGetMessageData(EventHandle event, MessageDataStruct *data) in object.h"
	^GEOS call: event with: data with: #[0 6 195 1 3 4]!

MessageSetDestination: EventHandle with: optr
	"dword pascal MessageSetDestination(EventHandle, optr) in object.h"
	^GEOS call: EventHandle with: optr with: #[0 4 183 1 2 2]!

ObjDuplicateMessage: msg
	"EventHandle pascal ObjDuplicateMessage(EventHandle msg) in object.h"
	^GEOS call: msg with: #[0 4 173 1 1]!

ObjDeref: obj with: masterLevel
	"void * pascal ObjDeref(optr obj, word masterLevel) in object.h"
	^GEOS call: obj with: masterLevel with: #[0 4 177 2 1 3]!

ObjDeref1: obj
	"void * pascal ObjDeref1(optr obj) in object.h"
	^GEOS call: obj with: #[0 4 178 2 3]!

ObjDeref2: obj
	"void * pascal ObjDeref2(optr obj) in object.h"
	^GEOS call: obj with: #[0 4 179 2 3]!

ObjVarAddData: obj with: dataType with: dataSize
	"void * pascal ObjVarAddData(optr obj, VardataKey dataType, word dataSize) in object.h"
	^GEOS call: obj with: dataType with: dataSize with: #[0 6 16 2 1 1 3]!

ObjVarDeleteData: obj with: dataType
	"Boolean pascal ObjVarDeleteData(optr obj, VardataKey dataType) in object.h"
	^GEOS call: obj with: dataType with: #[0 6 17 2 1 4]!

ObjVarDeleteDataAt: obj with: extraDataOffset
	"void pascal ObjVarDeleteDataAt(optr obj, word extraDataOffset) in object.h"
	^GEOS call: obj with: extraDataOffset with: #[0 6 18 2 1 0]!

ObjVarScanData: obj with: numHandlers with: handlerTable with: handlerData
	"void pascal ObjVarScanData(optr obj, word numHandlers, VarDataCHandler *handlerTable, void *handlerData) in object.h"
	^GEOS call: obj with: numHandlers with: handlerTable with: handlerData with: #[0 6 19 2 1 3 3 0]!

ObjVarFindData: obj with: dataType
	"void * pascal ObjVarFindData(optr obj, VardataKey dataType) in object.h"
	^GEOS call: obj with: dataType with: #[0 6 20 2 1 3]!

ObjVarDerefData: obj with: dataType
	"void * pascal ObjVarDerefData(optr obj, VardataKey dataType) in object.h"
	^GEOS call: obj with: dataType with: #[0 6 21 2 1 3]!

ObjVarDeleteDataRange: obj with: rangeStart with: rangeEnd with: useStateFlag
	"void pascal ObjVarDeleteDataRange(optr obj, word rangeStart, word rangeEnd, Boolean useStateFlag) in object.h"
	^GEOS call: obj with: rangeStart with: rangeEnd with: useStateFlag with: #[0 6 22 2 1 1 4 0]!

ObjVarCopyDataRange: source with: dest with: rangeStart with: rangeEnd
	"void pascal ObjVarCopyDataRange(optr source, optr dest, word rangeStart, word rangeEnd) in object.h"
	^GEOS call: source with: dest with: rangeStart with: rangeEnd with: #[0 6 23 2 2 1 1 0]!

ObjBlockSetOutput: mh with: o
	"void pascal ObjBlockSetOutput(MemHandle mh, optr o) in object.h"
	^GEOS call: mh with: o with: #[0 4 185 1 2 0]!

ObjBlockGetOutput: mh
	"optr pascal ObjBlockGetOutput(MemHandle mh) in object.h"
	^GEOS call: mh with: #[0 4 186 1 2]!

ThreadDestroy: errorCode with: ackObject with: ackData
	"void pascal ThreadDestroy(word errorCode, optr ackObject, word ackData) in thread.h"
	^GEOS call: errorCode with: ackObject with: ackData with: #[0 3 181 1 2 1 0]!

ThreadGetInfo: th with: info
	"word pascal ThreadGetInfo(ThreadHandle th, ThreadGetInfoType info) in thread.h"
	^GEOS call: th with: info with: #[0 3 183 1 1 1]!

ThreadModify: th with: newBasePriority with: flags
	"void pascal ThreadModify(ThreadHandle th, word newBasePriority, ThreadModifyFlags flags) in thread.h"
	^GEOS call: th with: newBasePriority with: flags with: #[0 3 184 1 1 1 0]!

ThreadAttachToQueue: qh with: class
	"void pascal ThreadAttachToQueue(QueueHandle qh, ClassStruct *class) in thread.h"
	^GEOS call: qh with: class with: #[0 3 185 1 3 0]!

ThreadPrivAlloc: wordsRequested with: owner
	"word pascal ThreadPrivAlloc(word wordsRequested, GeodeHandle owner) in thread.h"
	^GEOS call: wordsRequested with: owner with: #[0 3 186 1 1 1]!

ThreadPrivFree: range with: wordsRequested
	"void pascal ThreadPrivFree(word range, word wordsRequested) in thread.h"
	^GEOS call: range with: wordsRequested with: #[0 3 187 1 1 0]!

MemAlloc: byteSize with: hfFlags with: haFlags
	"MemHandle pascal MemAlloc(word byteSize, HeapFlags hfFlags, HeapAllocFlags haFlags) in heap.h"
	^GEOS call: byteSize with: hfFlags with: haFlags with: #[0 3 76 1 1 1 1]!

MemAllocSetOwner: owner with: byteSize with: hfFlags with: haFlags
	"MemHandle pascal MemAllocSetOwner(GeodeHandle owner, word byteSize, HeapFlags hfFlags, HeapAllocFlags haFlags) in heap.h"
	^GEOS call: owner with: byteSize with: hfFlags with: haFlags with: #[0 3 69 1 1 1 1 1]!

MemReAlloc: mh with: byteSize with: heapAllocFlags
	"MemHandle pascal MemReAlloc(MemHandle mh, word byteSize, HeapAllocFlags heapAllocFlags) in heap.h"
	^GEOS call: mh with: byteSize with: heapAllocFlags with: #[0 3 70 1 1 1 1]!

MemFree: mh
	"void pascal MemFree(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 77 1 0]!

MemDiscard: mh
	"void pascal MemDiscard(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 0 4 1 0]!

MemGetInfo: mh with: info
	"word pascal MemGetInfo(MemHandle mh, MemGetInfoType info) in heap.h"
	^GEOS call: mh with: info with: #[0 3 71 1 1 1]!

MemModifyFlags: mh with: bitsToSet with: bitsToClear
	"void pascal MemModifyFlags(MemHandle mh, HeapFlags bitsToSet, HeapFlags bitsToClear) in heap.h"
	^GEOS call: mh with: bitsToSet with: bitsToClear with: #[0 3 72 1 1 1 0]!

HandleModifyOwner: mh with: owner
	"void pascal HandleModifyOwner(Handle mh, GeodeHandle owner) in heap.h"
	^GEOS call: mh with: owner with: #[0 3 73 1 1 0]!

MemModifyOtherInfo: mh with: otherInfo
	"void pascal MemModifyOtherInfo(MemHandle mh, word otherInfo) in heap.h"
	^GEOS call: mh with: otherInfo with: #[0 3 74 1 1 0]!

MemLock: mh
	"void * pascal MemLock(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 80 1 3]!

MemUnlock: mh
	"void pascal MemUnlock(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 81 1 0]!

HandleP: mh
	"void pascal HandleP(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 87 1 0]!

HandleV: mh
	"void pascal HandleV(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 88 1 0]!

MemPLock: mh
	"void * pascal MemPLock(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 79 1 3]!

MemUnlockV: mh
	"void pascal MemUnlockV(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 83 1 0]!

MemThreadGrab: mh
	"void * pascal MemThreadGrab(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 84 1 3]!

MemThreadGrabNB: mh
	"void * pascal MemThreadGrabNB(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 85 1 3]!

MemThreadRelease: mh
	"void pascal MemThreadRelease(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 86 1 0]!

MemDeref: mh
	"void * pascal MemDeref(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 78 1 3]!

MemOwner: mh
	"GeodeHandle pascal MemOwner(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 82 1 1]!

MemPtrToHandle: ptr
	"MemHandle pascal MemPtrToHandle(void *ptr) in heap.h"
	^GEOS call: ptr with: #[0 3 75 3 1]!

MemInitRefCount: mh with: count
	"void pascal MemInitRefCount(MemHandle mh, word count) in heap.h"
	^GEOS call: mh with: count with: #[0 3 89 1 1 0]!

MemIncRefCount: mh
	"void pascal MemIncRefCount(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 90 1 0]!

MemDecRefCount: mh
	"void pascal MemDecRefCount(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 91 1 0]!

MemLockFixedOrMovable: ptr
	"void * pascal MemLockFixedOrMovable(void *ptr) in heap.h"
	^GEOS call: ptr with: #[0 3 93 3 3]!

MemUnlockFixedOrMovable: ptr
	"void pascal MemUnlockFixedOrMovable(void *ptr) in heap.h"
	^GEOS call: ptr with: #[0 3 94 3 0]!

MemLockShared: mh
	"void * pascal MemLockShared(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 95 1 3]!

MemUnlockShared: mh
	"void pascal MemUnlockShared(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 96 1 0]!

MemLockExcl: mh
	"void * pascal MemLockExcl(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 97 1 3]!

MemDowngradeExclLock: mh
	"void pascal MemDowngradeExclLock(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 99 1 0]!

MemUpgradeSharedLock: mh
	"void * pascal MemUpgradeSharedLock(MemHandle mh) in heap.h"
	^GEOS call: mh with: #[0 3 98 1 3]!

LZGAllocCompressStack: stackOwner
	"MemHandle pascal LZGAllocCompressStack(GeodeHandle stackOwner) in heap.h"
	^GEOS call: stackOwner with: #[0 6 252 1 1]!

LZGFreeCompressStack: compressStack
	"void pascal LZGFreeCompressStack(MemHandle compressStack) in heap.h"
	^GEOS call: compressStack with: #[0 6 254 1 0]!

LZGCompress: compressBuffer with: data with: dataSize with: compressStack
	"int pascal LZGCompress(byte *compressBuffer, byte *data, int dataSize, MemHandle compressStack) in heap.h"
	^GEOS call: compressBuffer with: data with: dataSize with: compressStack with: #[0 6 246 3 3 4 1 4]!

LZGUncompress: dataBuffer with: compressedData
	"int pascal LZGUncompress(byte *dataBuffer, byte *compressedData) in heap.h"
	^GEOS call: dataBuffer with: compressedData with: #[0 6 248 3 3 4]!

LZGGetUncompressedSize: compressedData
	"int pascal LZGGetUncompressedSize(byte *compressedData) in heap.h"
	^GEOS call: compressedData with: #[0 6 250 3 4]!

GeodeDuplicateResource: mh
	"MemHandle pascal GeodeDuplicateResource(MemHandle mh) in resource.h"
	^GEOS call: mh with: #[0 3 146 1 1]!

ProcGetLibraryEntry: library with: entryNumber
	"void * pascal ProcGetLibraryEntry(GeodeHandle library, word entryNumber) in resource.h"
	^GEOS call: library with: entryNumber with: #[0 3 149 1 1 3]!

ProcCallFixedOrMovable_pascal
	"dword pascal ProcCallFixedOrMovable_pascal() in resource.h"
	^GEOS call: #[0 3 145 2]!

ProcCallFixedOrMovable_cdecl
	"dword cdecl ProcCallFixedOrMovable_cdecl() in resource.h"
	^GEOS call: #[128 3 144 2]!

GeodeLoadDGroup: mh
	"void pascal GeodeLoadDGroup(MemHandle mh) in resource.h"
	^GEOS call: mh with: #[0 3 143 1 0]!

GeodeGetOptrNS: obj
	"optr pascal GeodeGetOptrNS(optr obj) in resource.h"
	^GEOS call: obj with: #[0 3 147 2 2]!

GeodeGetGeodeResourceHandle: geode with: resourceID
	"MemHandle pascal GeodeGetGeodeResourceHandle(GeodeHandle geode, word resourceID) in resource.h"
	^GEOS call: geode with: resourceID with: #[0 6 234 1 1 1]!

CFatalError: code
	"void pascal CFatalError(word code) in ec.h"
	^GEOS call: code with: #[0 4 110 1 0]!

CWarningNotice: code
	"void pascal CWarningNotice(word code) in ec.h"
	^GEOS call: code with: #[0 2 61 1 0]!

ECCheckFileHandle: fh
	"void pascal ECCheckFileHandle(FileHandle fh) in ec.h"
	^GEOS call: fh with: #[0 4 133 1 0]!

ECCheckMemHandle: mh
	"void pascal ECCheckMemHandle(MemHandle mh) in ec.h"
	^GEOS call: mh with: #[0 4 111 1 0]!

ECCheckMemHandleNS: mh
	"void pascal ECCheckMemHandleNS(MemHandle mh) in ec.h"
	^GEOS call: mh with: #[0 4 112 1 0]!

ECCheckThreadHandle: th
	"void pascal ECCheckThreadHandle(ThreadHandle th) in ec.h"
	^GEOS call: th with: #[0 4 113 1 0]!

ECCheckProcessHandle: gh
	"void pascal ECCheckProcessHandle(GeodeHandle gh) in ec.h"
	^GEOS call: gh with: #[0 4 114 1 0]!

ECCheckResourceHandle: mh
	"void pascal ECCheckResourceHandle(MemHandle mh) in ec.h"
	^GEOS call: mh with: #[0 4 115 1 0]!

ECCheckGeodeHandle: gh
	"void pascal ECCheckGeodeHandle(GeodeHandle gh) in ec.h"
	^GEOS call: gh with: #[0 4 116 1 0]!

ECCheckDriverHandle: gh
	"void pascal ECCheckDriverHandle(GeodeHandle gh) in ec.h"
	^GEOS call: gh with: #[0 4 117 1 0]!

ECCheckLibraryHandle: gh
	"void pascal ECCheckLibraryHandle(GeodeHandle gh) in ec.h"
	^GEOS call: gh with: #[0 4 118 1 0]!

ECCheckGStateHandle: gsh
	"void pascal ECCheckGStateHandle(GStateHandle gsh) in ec.h"
	^GEOS call: gsh with: #[0 4 119 1 0]!

ECCheckWindowHandle: wh
	"void pascal ECCheckWindowHandle(WindowHandle wh) in ec.h"
	^GEOS call: wh with: #[0 4 120 1 0]!

ECCheckQueueHandle: qh
	"void pascal ECCheckQueueHandle(QueueHandle qh) in ec.h"
	^GEOS call: qh with: #[0 4 121 1 0]!

ECCheckEventHandle: eh
	"void pascal ECCheckEventHandle(EventHandle eh) in ec.h"
	^GEOS call: eh with: #[0 6 101 1 0]!

ECCheckLMemHandle: mh
	"void pascal ECCheckLMemHandle(MemHandle mh) in ec.h"
	^GEOS call: mh with: #[0 4 122 1 0]!

ECCheckLMemHandleNS: mh
	"void pascal ECCheckLMemHandleNS(MemHandle mh) in ec.h"
	^GEOS call: mh with: #[0 4 123 1 0]!

ECLMemValidateHeap: mh
	"void pascal ECLMemValidateHeap(MemHandle mh) in ec.h"
	^GEOS call: mh with: #[0 4 124 1 0]!

ECLMemValidateHandle: o
	"void pascal ECLMemValidateHandle(optr o) in ec.h"
	^GEOS call: o with: #[0 4 125 2 0]!

ECCheckLMemChunk: chunkPtr
	"void pascal ECCheckLMemChunk(void *chunkPtr) in ec.h"
	^GEOS call: chunkPtr with: #[0 4 126 3 0]!

ECMemVerifyHeap
	"void pascal ECMemVerifyHeap(void) in ec.h"
	^GEOS call: #[0 0 20 0]!

ECLMemExists: o
	"void pascal ECLMemExists(optr o) in ec.h"
	^GEOS call: o with: #[0 4 127 2 0]!

ECCheckChunkArray: o
	"void pascal ECCheckChunkArray(optr o) in ec.h"
	^GEOS call: o with: #[0 4 207 2 0]!

ECCheckClass: class
	"void pascal ECCheckClass(ClassStruct *class) in ec.h"
	^GEOS call: class with: #[0 4 128 3 0]!

ECCheckObject: obj
	"void pascal ECCheckObject(optr obj) in ec.h"
	^GEOS call: obj with: #[0 4 129 2 0]!

ECCheckLMemObject: obj
	"void pascal ECCheckLMemObject(optr obj) in ec.h"
	^GEOS call: obj with: #[0 4 130 2 0]!

ECCheckOD: obj
	"void pascal ECCheckOD(optr obj) in ec.h"
	^GEOS call: obj with: #[0 4 131 2 0]!

ECCheckLMemOD: o
	"void pascal ECCheckLMemOD(optr o) in ec.h"
	^GEOS call: o with: #[0 4 132 2 0]!

ECCheckStack
	"void pascal ECCheckStack(void) in ec.h"
	^GEOS call: #[0 2 242 0]!

ECVMCheckVMFile: file
	"void pascal ECVMCheckVMFile(VMFileHandle file) in ec.h"
	^GEOS call: file with: #[0 4 135 1 0]!

ECVMCheckVMBlockHandle: file with: block
	"void pascal ECVMCheckVMBlockHandle(VMFileHandle file, VMBlockHandle block) in ec.h"
	^GEOS call: file with: block with: #[0 4 137 1 1 0]!

ECVMCheckMemHandle: han
	"void pascal ECVMCheckMemHandle(MemHandle han) in ec.h"
	^GEOS call: han with: #[0 4 139 1 0]!

ECCheckBounds: address
	"void pascal ECCheckBounds(void *address) in ec.h"
	^GEOS call: address with: #[0 4 140 3 0]!

SysGetECLevel: checksumBlock
	"ErrorCheckingFlags pascal SysGetECLevel(MemHandle *checksumBlock) in ec.h"
	^GEOS call: checksumBlock with: #[0 3 202 3 1]!

SysSetECLevel: flags with: checksumBlock
	"void pascal SysSetECLevel(ErrorCheckingFlags flags, MemHandle checksumBlock) in ec.h"
	^GEOS call: flags with: checksumBlock with: #[0 3 203 1 1 0]!

GrEnumFonts: buffer with: size with: flags with: family
	"word pascal GrEnumFonts(FontEnumStruct *buffer, word size, FontEnumFlags flags, word family) in font.h"
	^GEOS call: buffer with: size with: flags with: family with: #[0 4 225 3 1 1 1 1]!

GrCheckFontAvailID: flags with: family with: id
	"FontID pascal GrCheckFontAvailID(FontEnumFlags flags, word family, FontID id) in font.h"
	^GEOS call: flags with: family with: id with: #[0 4 226 1 1 1 1]!

GrCheckFontAvailName: flags with: family with: name
	"FontID pascal GrCheckFontAvailName(FontEnumFlags flags, word family, const char *name) in font.h"
	^GEOS call: flags with: family with: name with: #[0 4 227 1 1 3 1]!

GrFindNearestPointsize: id with: sizeSHL16 with: styles with: styleFound with: sizeFoundSHL16
	"Boolean pascal GrFindNearestPointsize(FontID id, dword sizeSHL16, word styles, word *styleFound, dword *sizeFoundSHL16) in font.h"
	^GEOS call: id with: sizeSHL16 with: styles with: styleFound with: sizeFoundSHL16 with: #[0 1 103 1 2 1 3 3 4]!

GrGetDefFontID: sizeSHL16
	"FontID pascal GrGetDefFontID(dword *sizeSHL16) in font.h"
	^GEOS call: sizeSHL16 with: #[0 4 229 3 1]!

GrCharMetrics: gstate with: info with: ch
	"dword pascal GrCharMetrics(GStateHandle gstate, GCM_info info, word ch) in font.h"
	^GEOS call: gstate with: info with: ch with: #[0 5 67 1 1 1 2]!

GrFontMetrics: gstate with: info
	"dword pascal GrFontMetrics(GStateHandle gstate, GFM_info info) in font.h"
	^GEOS call: gstate with: info with: #[0 5 68 1 1 2]!

GrGetFontName: id with: name
	"word pascal GrGetFontName(FontID id, char *name) in font.h"
	^GEOS call: id with: name with: #[0 5 150 1 3 1]!

GrSetFontWeight: gstate with: weight
	"void pascal GrSetFontWeight(GStateHandle gstate, FontWeight weight) in font.h"
	^GEOS call: gstate with: weight with: #[0 5 151 1 1 0]!

GrSetFontWidth: gstate with: width
	"void pascal GrSetFontWidth(GStateHandle gstate, FontWidth width) in font.h"
	^GEOS call: gstate with: width with: #[0 5 152 1 1 0]!

GrSetSuperscriptAttr: gstate with: attrs
	"void pascal GrSetSuperscriptAttr(GStateHandle gstate, SuperscriptAttr attrs) in font.h"
	^GEOS call: gstate with: attrs with: #[0 5 153 1 1 0]!

GrSetSubscriptAttr: gstate with: attrs
	"void pascal GrSetSubscriptAttr(GStateHandle gstate, SubscriptAttr attrs) in font.h"
	^GEOS call: gstate with: attrs with: #[0 5 154 1 1 0]!

GrGetFontWeight: gstate
	"FontWeight pascal GrGetFontWeight(GStateHandle gstate) in font.h"
	^GEOS call: gstate with: #[0 5 155 1 1]!

GrGetFontWidth: gstate
	"FontWidth pascal GrGetFontWidth(GStateHandle gstate) in font.h"
	^GEOS call: gstate with: #[0 5 156 1 1]!

GrGetSuperscriptAttr: gstate
	"SuperscriptAttr pascal GrGetSuperscriptAttr(GStateHandle gstate) in font.h"
	^GEOS call: gstate with: #[0 5 157 1 1]!

GrGetSubscriptAttr: gstate
	"SubscriptAttr pascal GrGetSubscriptAttr(GStateHandle gstate) in font.h"
	^GEOS call: gstate with: #[0 5 158 1 1]!

GrCharWidth: gstate with: ch
	"dword pascal GrCharWidth(GStateHandle gstate, word ch) in graphics.h"
	^GEOS call: gstate with: ch with: #[0 5 69 1 1 2]!

GrTextWidth: gstate with: str with: size
	"word pascal GrTextWidth(GStateHandle gstate, const char *str, word size) in graphics.h"
	^GEOS call: gstate with: str with: size with: #[0 5 70 1 3 1 1]!

GrGetCharInfo: gstate with: ch
	"CharInfo pascal GrGetCharInfo(GStateHandle gstate, word ch) in graphics.h"
	^GEOS call: gstate with: ch with: #[0 6 144 1 1 1]!

GrTextWidthWWFixed: gstate with: str with: size
	"dword pascal GrTextWidthWWFixed(GStateHandle gstate, const char *str, word size) in graphics.h"
	^GEOS call: gstate with: str with: size with: #[0 5 71 1 3 1 2]!

GrGetBitmap: gstate with: x with: y with: width with: height with: sizeCopied
	"MemHandle pascal GrGetBitmap(GStateHandle gstate, sword x, sword y, word width, word height, XYSize *sizeCopied) in graphics.h"
	^GEOS call: gstate with: x with: y with: width with: height with: sizeCopied with: #[0 4 230 1 4 4 1 1 3 1]!

GrGetPoint: gstate with: x with: y
	"RGBColorAsDWord pascal GrGetPoint(GStateHandle gstate, sword x, sword y) in graphics.h"
	^GEOS call: gstate with: x with: y with: #[0 5 182 1 4 4 2]!

GrEditBitmap: vmFile with: vmBlock with: exposureOD
	"GStateHandle pascal GrEditBitmap(VMFileHandle vmFile, VMBlockHandle vmBlock, optr exposureOD) in graphics.h"
	^GEOS call: vmFile with: vmBlock with: exposureOD with: #[0 5 178 1 1 2 1]!

GrCompactBitmap: srcFile with: srcBlock with: destFile
	"VMBlockHandle pascal GrCompactBitmap(VMFileHandle srcFile, VMBlockHandle srcBlock, VMFileHandle destFile) in graphics.h"
	^GEOS call: srcFile with: srcBlock with: destFile with: #[0 5 175 1 1 1 1]!

GrUncompactBitmap: srcFile with: srcBlock with: destFile
	"VMBlockHandle pascal GrUncompactBitmap(VMFileHandle srcFile, VMBlockHandle srcBlock, VMFileHandle destFile) in graphics.h"
	^GEOS call: srcFile with: srcBlock with: destFile with: #[0 5 185 1 1 1 1]!

GrDestroyBitmap: gstate with: flags
	"void pascal GrDestroyBitmap(GStateHandle gstate, BMDestroy flags) in graphics.h"
	^GEOS call: gstate with: flags with: #[0 4 232 1 1 0]!

GrSetBitmapMode: gstate with: flags with: colorCorr
	"void pascal GrSetBitmapMode(GStateHandle gstate, word flags, MemHandle colorCorr) in graphics.h"
	^GEOS call: gstate with: flags with: colorCorr with: #[0 5 147 1 1 1 0]!

GrGetBitmapMode: gstate
	"word pascal GrGetBitmapMode(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 148 1 1]!

GrSetBitmapRes: gstate with: xRes with: yRes
	"void pascal GrSetBitmapRes(GStateHandle gstate, word xRes, word yRes) in graphics.h"
	^GEOS call: gstate with: xRes with: yRes with: #[0 4 233 1 1 1 0]!

GrGetBitmapRes: gstate
	"XYValueAsDWord pascal GrGetBitmapRes(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 4 234 1 2]!

GrClearBitmap: gstate
	"void pascal GrClearBitmap(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 4 235 1 0]!

GrGetBitmapSize: bm
	"XYValueAsDWord pascal GrGetBitmapSize(const Bitmap *bm) in graphics.h"
	^GEOS call: bm with: #[0 4 236 3 2]!

GrGetHugeBitmapSize: vmFile with: vmBlk
	"XYValueAsDWord pascal GrGetHugeBitmapSize(VMFileHandle vmFile, VMBlockHandle vmBlk) in graphics.h"
	^GEOS call: vmFile with: vmBlk with: #[0 6 98 1 1 2]!

GrDrawRegion: gstate with: xPos with: yPos with: reg with: cxParam with: dxParam
	"void pascal GrDrawRegion(GStateHandle gstate, sword xPos, sword yPos, const Region *reg, word cxParam, word dxParam) in graphics.h"
	^GEOS call: gstate with: xPos with: yPos with: reg with: cxParam with: dxParam with: #[0 5 72 1 4 4 3 1 1 0]!

GrDrawRegionAtCP: gstate with: reg with: axParam with: bxParam with: cxParam with: dxParam
	"void pascal GrDrawRegionAtCP(GStateHandle gstate, const Region *reg, word axParam, word bxParam, word cxParam, word dxParam) in graphics.h"
	^GEOS call: gstate with: reg with: axParam with: bxParam with: cxParam with: dxParam with: #[0 5 73 1 3 1 1 1 1 0]!

GrMoveReg: reg with: xOffset with: yOffset
	"void pascal GrMoveReg(Region *reg, sword xOffset, sword yOffset) in graphics.h"
	^GEOS call: reg with: xOffset with: yOffset with: #[0 4 238 3 4 4 0]!

GrGetPtrRegBounds: reg with: bounds
	"word pascal GrGetPtrRegBounds(const Region *reg, Rectangle *bounds) in graphics.h"
	^GEOS call: reg with: bounds with: #[0 4 239 3 3 1]!

GrTestPointInReg: reg with: xPos with: yPos with: boundingRect
	"Boolean pascal GrTestPointInReg(const Region *reg, word xPos, word yPos, Rectangle *boundingRect) in graphics.h"
	^GEOS call: reg with: xPos with: yPos with: boundingRect with: #[0 4 240 3 1 1 3 4]!

GrTestRectInReg: reg with: left with: top with: right with: bottom
	"TestRectReturnType pascal GrTestRectInReg(const Region *reg, sword left, sword top, sword right, sword bottom) in graphics.h"
	^GEOS call: reg with: left with: top with: right with: bottom with: #[0 4 241 3 4 4 4 4 1]!

GrTestRectInMask: gstate with: left with: top with: right with: bottom
	"TestRectReturnType pascal GrTestRectInMask(GStateHandle gstate, sword left, sword top, sword right, sword bottom) in graphics.h"
	^GEOS call: gstate with: left with: top with: right with: bottom with: #[0 5 184 1 4 4 4 4 1]!

GrMulWWFixed: i with: j
	"WWFixedAsDWord pascal GrMulWWFixed(WWFixedAsDWord i, WWFixedAsDWord j) in graphics.h"
	^GEOS call: i with: j with: #[0 5 74 2 2 2]!

GrMulDWFixed: i with: j with: result
	"void pascal GrMulDWFixed(const DWFixed *i, const DWFixed *j, DWFixed *result) in graphics.h"
	^GEOS call: i with: j with: result with: #[0 5 75 3 3 3 0]!

GrSDivWWFixed: dividend with: divisor
	"WWFixedAsDWord pascal GrSDivWWFixed(WWFixedAsDWord dividend, WWFixedAsDWord divisor) in graphics.h"
	^GEOS call: dividend with: divisor with: #[0 5 76 2 2 2]!

GrUDivWWFixed: dividend with: divisor
	"WWFixedAsDWord pascal GrUDivWWFixed(WWFixedAsDWord dividend, WWFixedAsDWord divisor) in graphics.h"
	^GEOS call: dividend with: divisor with: #[0 5 77 2 2 2]!

GrSqrRootWWFixed: i
	"WWFixedAsDWord pascal GrSqrRootWWFixed(WWFixedAsDWord i) in graphics.h"
	^GEOS call: i with: #[0 4 242 2 2]!

GrSDivDWFbyWWF: dividend with: divisor with: quotient
	"void pascal GrSDivDWFbyWWF(const DWFixed *dividend, const WWFixed *divisor, DWFixed *quotient) in graphics.h"
	^GEOS call: dividend with: divisor with: quotient with: #[0 5 78 3 3 3 0]!

GrQuickSine: angle
	"WWFixedAsDWord pascal GrQuickSine(WWFixedAsDWord angle) in graphics.h"
	^GEOS call: angle with: #[0 4 243 2 2]!

GrQuickCosine: angle
	"WWFixedAsDWord pascal GrQuickCosine(WWFixedAsDWord angle) in graphics.h"
	^GEOS call: angle with: #[0 4 244 2 2]!

GrQuickTangent: angle
	"WWFixedAsDWord pascal GrQuickTangent(WWFixedAsDWord angle) in graphics.h"
	^GEOS call: angle with: #[0 4 246 2 2]!

GrQuickArcSine: deltaYDivDistance with: origDeltaX
	"WWFixedAsDWord pascal GrQuickArcSine(WWFixedAsDWord deltaYDivDistance, word origDeltaX) in graphics.h"
	^GEOS call: deltaYDivDistance with: origDeltaX with: #[0 4 245 2 1 2]!

GrCreateState: win
	"GStateHandle pascal GrCreateState(WindowHandle win) in graphics.h"
	^GEOS call: win with: #[0 5 79 1 1]!

GrDestroyState: gstate
	"void pascal GrDestroyState(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 80 1 0]!

GrSetVMFile: gstate with: vmFile
	"void pascal GrSetVMFile(GStateHandle gstate, VMFileHandle vmFile) in graphics.h"
	^GEOS call: gstate with: vmFile with: #[0 6 187 1 1 0]!

GrGetExclusive: videoDriver
	"GStateHandle pascal GrGetExclusive(GeodeHandle videoDriver) in graphics.h"
	^GEOS call: videoDriver with: #[0 5 179 1 1]!

GrGrabExclusive: videoDriver with: gstate
	"void pascal GrGrabExclusive(GeodeHandle videoDriver, GStateHandle gstate) in graphics.h"
	^GEOS call: videoDriver with: gstate with: #[0 4 247 1 1 0]!

GrReleaseExclusive: videoDriver with: gstate with: bounds
	"void pascal GrReleaseExclusive(GeodeHandle videoDriver, GStateHandle gstate, Rectangle *bounds) in graphics.h"
	^GEOS call: videoDriver with: gstate with: bounds with: #[0 4 248 1 1 3 0]!

GrTransformWWFixed: gstate with: xPos with: yPos with: deviceCoordinates
	"void pascal GrTransformWWFixed(GStateHandle gstate, WWFixedAsDWord xPos, WWFixedAsDWord yPos, PointWWFixed *deviceCoordinates) in graphics.h"
	^GEOS call: gstate with: xPos with: yPos with: deviceCoordinates with: #[0 4 249 1 2 2 3 0]!

GrTransformDWFixed: gstate with: coord
	"void pascal GrTransformDWFixed(GStateHandle gstate, PointDWFixed *coord) in graphics.h"
	^GEOS call: gstate with: coord with: #[0 4 250 1 3 0]!

GrUntransformWWFixed: gstate with: xPos with: yPos with: documentCoordinates
	"void pascal GrUntransformWWFixed(GStateHandle gstate, WWFixedAsDWord xPos, WWFixedAsDWord yPos, PointWWFixed *documentCoordinates) in graphics.h"
	^GEOS call: gstate with: xPos with: yPos with: documentCoordinates with: #[0 4 251 1 2 2 3 0]!

GrUntransformDWFixed: gstate with: coord
	"void pascal GrUntransformDWFixed(GStateHandle gstate, PointDWFixed *coord) in graphics.h"
	^GEOS call: gstate with: coord with: #[0 4 252 1 3 0]!

GrBitBlt: gstate with: sourceX with: sourceY with: destX with: destY with: width with: height with: mode
	"void pascal GrBitBlt(GStateHandle gstate, sword sourceX, sword sourceY, sword destX, sword destY, word width, word height, BLTMode mode) in graphics.h"
	^GEOS call: gstate with: sourceX with: sourceY with: destX with: destY with: width with: height with: mode with: #[0 4 253 1 4 4 4 4 1 1 1 0]!

GrTransform: gstate with: xCoord with: yCoord
	"XYValueAsDWord pascal GrTransform(GStateHandle gstate, sword xCoord, sword yCoord) in graphics.h"
	^GEOS call: gstate with: xCoord with: yCoord with: #[0 4 254 1 4 4 2]!

GrTransformDWord: gstate with: xCoord with: yCoord with: deviceCoordinates
	"void pascal GrTransformDWord(GStateHandle gstate, sdword xCoord, sdword yCoord, PointDWord *deviceCoordinates) in graphics.h"
	^GEOS call: gstate with: xCoord with: yCoord with: deviceCoordinates with: #[0 4 255 1 2 2 3 0]!

GrUntransform: gstate with: xCoord with: yCoord
	"XYValueAsDWord pascal GrUntransform(GStateHandle gstate, sword xCoord, sword yCoord) in graphics.h"
	^GEOS call: gstate with: xCoord with: yCoord with: #[0 5 0 1 4 4 2]!

GrUntransformDWord: gstate with: xCoord with: yCoord with: documentCoordinates
	"void pascal GrUntransformDWord(GStateHandle gstate, sdword xCoord, sdword yCoord, PointDWord *documentCoordinates) in graphics.h"
	^GEOS call: gstate with: xCoord with: yCoord with: documentCoordinates with: #[0 5 1 1 2 2 3 0]!

GrMapColorIndex: gstate with: c
	"RGBColorAsDWord pascal GrMapColorIndex(GStateHandle gstate, Color c) in graphics.h"
	^GEOS call: gstate with: c with: #[0 5 2 1 1 2]!

GrMapColorRGB: gstate with: red with: green with: blue with: index
	"RGBColorAsDWord pascal GrMapColorRGB(GStateHandle gstate, word red, word green, word blue, Color *index) in graphics.h"
	^GEOS call: gstate with: red with: green with: blue with: index with: #[0 5 3 1 1 1 1 3 2]!

GrGetPalette: gstate with: flag
	"MemHandle pascal GrGetPalette(GStateHandle gstate, GetPalType flag) in graphics.h"
	^GEOS call: gstate with: flag with: #[0 5 4 1 1 1]!

GrSetPrivateData: gstate with: dataAX with: dataBX with: dataCX with: dataDX
	"void pascal GrSetPrivateData(GStateHandle gstate, word dataAX, word dataBX, word dataCX, word dataDX) in graphics.h"
	^GEOS call: gstate with: dataAX with: dataBX with: dataCX with: dataDX with: #[0 5 5 1 1 1 1 1 0]!

GrGetMixMode: gstate
	"MixMode pascal GrGetMixMode(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 6 1 1]!

GrGetLineColor: gstate
	"RGBColorAsDWord pascal GrGetLineColor(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 7 1 2]!

GrGetAreaColor: gstate
	"RGBColorAsDWord pascal GrGetAreaColor(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 8 1 2]!

GrGetTextColor: gstate
	"RGBColorAsDWord pascal GrGetTextColor(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 9 1 2]!

GrGetLineMask: gstate with: dm
	"word pascal GrGetLineMask(GStateHandle gstate, DrawMask *dm) in graphics.h"
	^GEOS call: gstate with: dm with: #[0 5 10 1 3 1]!

GrGetAreaMask: gstate with: dm
	"word pascal GrGetAreaMask(GStateHandle gstate, DrawMask *dm) in graphics.h"
	^GEOS call: gstate with: dm with: #[0 5 11 1 3 1]!

GrGetTextMask: gstate with: dm
	"word pascal GrGetTextMask(GStateHandle gstate, DrawMask *dm) in graphics.h"
	^GEOS call: gstate with: dm with: #[0 5 12 1 3 1]!

GrGetLineColorMap: gstate
	"word pascal GrGetLineColorMap(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 13 1 1]!

GrGetAreaColorMap: gstate
	"word pascal GrGetAreaColorMap(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 14 1 1]!

GrGetTextColorMap: gstate
	"word pascal GrGetTextColorMap(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 15 1 1]!

GrGetTextSpacePad: gstate
	"WWFixedAsDWord pascal GrGetTextSpacePad(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 16 1 2]!

GrGetTextStyle: gstate
	"word pascal GrGetTextStyle(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 17 1 1]!

GrGetTextDrawOffset: gstate
	"word pascal GrGetTextDrawOffset(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 6 115 1 1]!

GrGetTextMode: gstate
	"word pascal GrGetTextMode(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 18 1 1]!

GrGetLineWidth: gstate
	"WWFixedAsDWord pascal GrGetLineWidth(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 19 1 2]!

GrGetLineEnd: gstate
	"LineEnd pascal GrGetLineEnd(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 20 1 1]!

GrGetLineJoin: gstate
	"LineJoin pascal GrGetLineJoin(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 21 1 1]!

GrGetLineStyle: gstate
	"LineStyle pascal GrGetLineStyle(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 22 1 1]!

GrGetMiterLimit: gstate
	"WWFixedAsDWord pascal GrGetMiterLimit(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 23 1 2]!

GrGetCurPos: gstate
	"XYValueAsDWord pascal GrGetCurPos(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 24 1 2]!

GrGetCurPosWWFixed: gstate with: cp
	"void pascal GrGetCurPosWWFixed(GStateHandle gstate, PointWWFixed *cp) in graphics.h"
	^GEOS call: gstate with: cp with: #[0 6 88 1 3 0]!

GrGetInfo: gstate with: type with: data
	"void pascal GrGetInfo(GStateHandle gstate, GrInfoType type, void *data) in graphics.h"
	^GEOS call: gstate with: type with: data with: #[0 5 25 1 1 3 0]!

GrGetTransform: gstate with: tm
	"void pascal GrGetTransform(GStateHandle gstate, TransMatrix *tm) in graphics.h"
	^GEOS call: gstate with: tm with: #[0 5 26 1 3 0]!

GrGetFont: gstate with: pointSize
	"FontID pascal GrGetFont(GStateHandle gstate, WWFixedAsDWord *pointSize) in graphics.h"
	^GEOS call: gstate with: pointSize with: #[0 5 27 1 3 1]!

GrGetTrackKern: gstate
	"word pascal GrGetTrackKern(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 149 1 1]!

GrTestPointInPolygon: gstate with: rule with: list with: numPoints with: xCoord with: yCoord
	"Boolean pascal GrTestPointInPolygon(GStateHandle gstate, RegionFillRule rule, Point *list, word numPoints, sword xCoord, sword yCoord) in graphics.h"
	^GEOS call: gstate with: rule with: list with: numPoints with: xCoord with: yCoord with: #[0 5 28 1 1 3 1 4 4 4]!

GrEndGString: gstate
	"GStringErrorType pascal GrEndGString(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 29 1 1]!

GrComment: gstate with: data with: size
	"void pascal GrComment(GStateHandle gstate, const void *data, word size) in graphics.h"
	^GEOS call: gstate with: data with: size with: #[0 5 30 1 3 1 0]!

GrNullOp: gstate
	"void pascal GrNullOp(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 31 1 0]!

GrEscape: gstate with: code with: data with: size
	"void pascal GrEscape(GStateHandle gstate, word code, const void *data, word size) in graphics.h"
	^GEOS call: gstate with: code with: data with: size with: #[0 5 32 1 1 3 1 0]!

GrSaveState: gstate
	"void pascal GrSaveState(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 81 1 0]!

GrRestoreState: gstate
	"void pascal GrRestoreState(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 82 1 0]!

GrNewPage: gstate with: pageEndCommand
	"void pascal GrNewPage(GStateHandle gstate, PageEndCommand pageEndCommand) in graphics.h"
	^GEOS call: gstate with: pageEndCommand with: #[0 5 33 1 1 0]!

GrApplyRotation: gstate with: angle
	"void pascal GrApplyRotation(GStateHandle gstate, WWFixedAsDWord angle) in graphics.h"
	^GEOS call: gstate with: angle with: #[0 5 34 1 2 0]!

GrApplyScale: gstate with: xScale with: yScale
	"void pascal GrApplyScale(GStateHandle gstate, WWFixedAsDWord xScale, WWFixedAsDWord yScale) in graphics.h"
	^GEOS call: gstate with: xScale with: yScale with: #[0 5 35 1 2 2 0]!

GrApplyTranslation: gstate with: xTrans with: yTrans
	"void pascal GrApplyTranslation(GStateHandle gstate, WWFixedAsDWord xTrans, WWFixedAsDWord yTrans) in graphics.h"
	^GEOS call: gstate with: xTrans with: yTrans with: #[0 5 36 1 2 2 0]!

GrApplyTranslationDWord: gstate with: xTrans with: yTrans
	"void pascal GrApplyTranslationDWord(GStateHandle gstate, sdword xTrans, sdword yTrans) in graphics.h"
	^GEOS call: gstate with: xTrans with: yTrans with: #[0 5 37 1 2 2 0]!

GrSetTransform: gstate with: tm
	"void pascal GrSetTransform(GStateHandle gstate, const TransMatrix *tm) in graphics.h"
	^GEOS call: gstate with: tm with: #[0 5 38 1 3 0]!

GrApplyTransform: gstate with: tm
	"void pascal GrApplyTransform(GStateHandle gstate, const TransMatrix *tm) in graphics.h"
	^GEOS call: gstate with: tm with: #[0 5 39 1 3 0]!

GrSaveTransform: gstate
	"void pascal GrSaveTransform(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 6 80 1 0]!

GrRestoreTransform: gstate
	"void pascal GrRestoreTransform(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 6 81 1 0]!

GrSetNullTransform: gstate
	"void pascal GrSetNullTransform(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 40 1 0]!

GrDrawLine: gstate with: x1 with: y1 with: x2 with: y2
	"void pascal GrDrawLine(GStateHandle gstate, sword x1, sword y1, sword x2, sword y2) in graphics.h"
	^GEOS call: gstate with: x1 with: y1 with: x2 with: y2 with: #[0 5 83 1 4 4 4 4 0]!

GrDrawLineTo: gstate with: x with: y
	"void pascal GrDrawLineTo(GStateHandle gstate, sword x, sword y) in graphics.h"
	^GEOS call: gstate with: x with: y with: #[0 5 84 1 4 4 0]!

GrDrawRect: gstate with: left with: top with: right with: bottom
	"void pascal GrDrawRect(GStateHandle gstate, sword left, sword top, sword right, sword bottom) in graphics.h"
	^GEOS call: gstate with: left with: top with: right with: bottom with: #[0 5 120 1 4 4 4 4 0]!

GrDrawRectTo: gstate with: x with: y
	"void pascal GrDrawRectTo(GStateHandle gstate, sword x, sword y) in graphics.h"
	^GEOS call: gstate with: x with: y with: #[0 6 132 1 4 4 0]!

GrDrawHLine: gstate with: x1 with: y with: x2
	"void pascal GrDrawHLine(GStateHandle gstate, sword x1, sword y, sword x2) in graphics.h"
	^GEOS call: gstate with: x1 with: y with: x2 with: #[0 5 85 1 4 4 4 0]!

GrDrawHLineTo: gstate with: x
	"void pascal GrDrawHLineTo(GStateHandle gstate, sword x) in graphics.h"
	^GEOS call: gstate with: x with: #[0 5 86 1 4 0]!

GrDrawVLine: gstate with: x with: y1 with: y2
	"void pascal GrDrawVLine(GStateHandle gstate, sword x, sword y1, sword y2) in graphics.h"
	^GEOS call: gstate with: x with: y1 with: y2 with: #[0 5 87 1 4 4 4 0]!

GrDrawVLineTo: gstate with: y
	"void pascal GrDrawVLineTo(GStateHandle gstate, sword y) in graphics.h"
	^GEOS call: gstate with: y with: #[0 5 88 1 4 0]!

GrDrawRoundRect: gstate with: left with: top with: right with: bottom with: radius
	"void pascal GrDrawRoundRect(GStateHandle gstate, sword left, sword top, sword right, sword bottom, word radius) in graphics.h"
	^GEOS call: gstate with: left with: top with: right with: bottom with: radius with: #[0 5 41 1 4 4 4 4 1 0]!

GrDrawRoundRectTo: gstate with: bottom with: right with: radius
	"void pascal GrDrawRoundRectTo(GStateHandle gstate, sword bottom, sword right, word radius) in graphics.h"
	^GEOS call: gstate with: bottom with: right with: radius with: #[0 5 42 1 4 4 1 0]!

GrDrawPoint: gstate with: x with: y
	"void pascal GrDrawPoint(GStateHandle gstate, sword x, sword y) in graphics.h"
	^GEOS call: gstate with: x with: y with: #[0 5 43 1 4 4 0]!

GrDrawPointAtCP: gstate
	"void pascal GrDrawPointAtCP(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 44 1 0]!

GrDrawHugeBitmap: gstate with: x with: y with: vmFile with: vmBlk
	"void pascal GrDrawHugeBitmap(GStateHandle gstate, sword x, sword y, VMFileHandle vmFile, VMBlockHandle vmBlk) in graphics.h"
	^GEOS call: gstate with: x with: y with: vmFile with: vmBlk with: #[0 5 142 1 4 4 1 1 0]!

GrDrawHugeBitmapAtCP: gstate with: vmFile with: vmBlk
	"void pascal GrDrawHugeBitmapAtCP(GStateHandle gstate, VMFileHandle vmFile, VMBlockHandle vmBlk) in graphics.h"
	^GEOS call: gstate with: vmFile with: vmBlk with: #[0 5 143 1 1 1 0]!

GrFillHugeBitmap: gstate with: x with: y with: vmFile with: vmBlk
	"void pascal GrFillHugeBitmap(GStateHandle gstate, sword x, sword y, VMFileHandle vmFile, VMBlockHandle vmBlk) in graphics.h"
	^GEOS call: gstate with: x with: y with: vmFile with: vmBlk with: #[0 6 78 1 4 4 1 1 0]!

GrFillHugeBitmapAtCP: gstate with: vmFile with: vmBlk
	"void pascal GrFillHugeBitmapAtCP(GStateHandle gstate, VMFileHandle vmFile, VMBlockHandle vmBlk) in graphics.h"
	^GEOS call: gstate with: vmFile with: vmBlk with: #[0 6 77 1 1 1 0]!

GrDrawImage: gstate with: x with: y with: flags with: bm
	"void pascal GrDrawImage(GStateHandle gstate, sword x, sword y, ImageFlags flags, const Bitmap *bm) in graphics.h"
	^GEOS call: gstate with: x with: y with: flags with: bm with: #[0 5 177 1 4 4 1 3 0]!

GrDrawHugeImage: gstate with: x with: y with: flags with: vmFile with: vmBlk
	"void pascal GrDrawHugeImage(GStateHandle gstate, sword x, sword y, ImageFlags flags, VMFileHandle vmFile, VMBlockHandle vmBlk) in graphics.h"
	^GEOS call: gstate with: x with: y with: flags with: vmFile with: vmBlk with: #[0 5 176 1 4 4 1 1 1 0]!

GrDrawChar: gstate with: x with: y with: ch
	"void pascal GrDrawChar(GStateHandle gstate, sword x, sword y, word ch) in graphics.h"
	^GEOS call: gstate with: x with: y with: ch with: #[0 5 45 1 4 4 1 0]!

GrDrawCharAtCP: gstate with: ch
	"void pascal GrDrawCharAtCP(GStateHandle gstate, word ch) in graphics.h"
	^GEOS call: gstate with: ch with: #[0 5 46 1 1 0]!

GrDrawText: gstate with: x with: y with: str with: size
	"void pascal GrDrawText(GStateHandle gstate, sword x, sword y, const char *str, word size) in graphics.h"
	^GEOS call: gstate with: x with: y with: str with: size with: #[0 4 220 1 4 4 3 1 0]!

GrDrawTextAtCP: gstate with: str with: size
	"void pascal GrDrawTextAtCP(GStateHandle gstate, const char *str, word size) in graphics.h"
	^GEOS call: gstate with: str with: size with: #[0 4 221 1 3 1 0]!

GrDrawPolyline: gstate with: points with: numPoints
	"void pascal GrDrawPolyline(GStateHandle gstate, const Point *points, word numPoints) in graphics.h"
	^GEOS call: gstate with: points with: numPoints with: #[0 5 47 1 3 1 0]!

GrBrushPolyline: gstate with: points with: numPoints with: brushH with: brushW
	"void pascal GrBrushPolyline(GStateHandle gstate, const Point *points, word numPoints, word brushH, word brushW) in graphics.h"
	^GEOS call: gstate with: points with: numPoints with: brushH with: brushW with: #[0 4 237 1 3 1 1 1 0]!

GrDrawEllipse: gstate with: left with: top with: right with: bottom
	"void pascal GrDrawEllipse(GStateHandle gstate, sword left, sword top, sword right, sword bottom) in graphics.h"
	^GEOS call: gstate with: left with: top with: right with: bottom with: #[0 5 48 1 4 4 4 4 0]!

GrDrawArc: gstate with: left with: top with: right with: bottom with: startAngle with: endAngle with: closeType
	"void pascal GrDrawArc(GStateHandle gstate, sword left, sword top, sword right, sword bottom, word startAngle, word endAngle, ArcCloseType closeType) in graphics.h"
	^GEOS call: gstate with: left with: top with: right with: bottom with: startAngle with: endAngle with: closeType with: #[0 6 136 1 4 4 4 4 1 1 1 0]!

GrDrawArc3Point: gstate with: params
	"void pascal GrDrawArc3Point (GStateHandle gstate, const ThreePointArcParams *params) in graphics.h"
	^GEOS call: gstate with: params with: #[0 5 136 1 3 0]!

GrDrawArc3PointTo: gstate with: params
	"void pascal GrDrawArc3PointTo (GStateHandle gstate, const ThreePointArcToParams *params) in graphics.h"
	^GEOS call: gstate with: params with: #[0 5 137 1 3 0]!

GrDrawRelArc3PointTo: gstate with: params
	"void pascal GrDrawRelArc3PointTo (GStateHandle gstate, const ThreePointRelArcToParams *params) in graphics.h"
	^GEOS call: gstate with: params with: #[0 5 138 1 3 0]!

GrDrawPolygon: gstate with: points with: numPoints
	"void pascal GrDrawPolygon(GStateHandle gstate, const Point *points, word numPoints) in graphics.h"
	^GEOS call: gstate with: points with: numPoints with: #[0 5 51 1 3 1 0]!

GrDrawSpline: gstate with: points with: numPoints
	"void pascal GrDrawSpline(GStateHandle gstate, const Point *points, word numPoints) in graphics.h"
	^GEOS call: gstate with: points with: numPoints with: #[0 5 50 1 3 1 0]!

GrDrawSplineTo: gstate with: points with: numPoints
	"void pascal GrDrawSplineTo(GStateHandle gstate, const Point *points, word numPoints) in graphics.h"
	^GEOS call: gstate with: points with: numPoints with: #[0 5 144 1 3 1 0]!

GrDrawCurve: gstate with: points
	"void pascal GrDrawCurve(GStateHandle gstate, const Point *points) in graphics.h"
	^GEOS call: gstate with: points with: #[0 5 145 1 3 0]!

GrDrawCurveTo: gstate with: points
	"void pascal GrDrawCurveTo(GStateHandle gstate, const Point *points) in graphics.h"
	^GEOS call: gstate with: points with: #[0 5 146 1 3 0]!

GrFillRect: gstate with: left with: top with: right with: bottom
	"void pascal GrFillRect(GStateHandle gstate, sword left, sword top, sword right, sword bottom) in graphics.h"
	^GEOS call: gstate with: left with: top with: right with: bottom with: #[0 4 222 1 4 4 4 4 0]!

GrFillRectTo: gstate with: x with: y
	"void pascal GrFillRectTo(GStateHandle gstate, sword x, sword y) in graphics.h"
	^GEOS call: gstate with: x with: y with: #[0 6 131 1 4 4 0]!

GrFillRoundRect: gstate with: left with: top with: right with: bottom with: radius
	"void pascal GrFillRoundRect(GStateHandle gstate, sword left, sword top, sword right, sword bottom, word radius) in graphics.h"
	^GEOS call: gstate with: left with: top with: right with: bottom with: radius with: #[0 5 52 1 4 4 4 4 1 0]!

GrFillRoundRectTo: gstate with: right with: bottom with: radius
	"void pascal GrFillRoundRectTo(GStateHandle gstate, sword right, sword bottom, word radius) in graphics.h"
	^GEOS call: gstate with: right with: bottom with: radius with: #[0 5 53 1 4 4 1 0]!

GrFillArc: gstate with: left with: top with: right with: bottom with: startAngle with: endAngle with: closeType
	"void pascal GrFillArc(GStateHandle gstate, sword left, sword top, sword right, sword bottom, word startAngle, word endAngle, ArcCloseType closeType) in graphics.h"
	^GEOS call: gstate with: left with: top with: right with: bottom with: startAngle with: endAngle with: closeType with: #[0 6 137 1 4 4 4 4 1 1 1 0]!

GrFillArc3Point: gstate with: params
	"void pascal GrFillArc3Point (GStateHandle gstate, const ThreePointArcParams *params) in graphics.h"
	^GEOS call: gstate with: params with: #[0 5 139 1 3 0]!

GrFillArc3PointTo: gstate with: params
	"void pascal GrFillArc3PointTo (GStateHandle gstate, const ThreePointArcToParams *params) in graphics.h"
	^GEOS call: gstate with: params with: #[0 5 140 1 3 0]!

GrFillPolygon: gstate with: windingRule with: points with: numPoints
	"void pascal GrFillPolygon(GStateHandle gstate, RegionFillRule windingRule, const Point *points, word numPoints) in graphics.h"
	^GEOS call: gstate with: windingRule with: points with: numPoints with: #[0 5 55 1 1 3 1 0]!

GrFillEllipse: gstate with: left with: top with: right with: bottom
	"void pascal GrFillEllipse(GStateHandle gstate, sword left, sword top, sword right, sword bottom) in graphics.h"
	^GEOS call: gstate with: left with: top with: right with: bottom with: #[0 5 56 1 4 4 4 4 0]!

GrSetMixMode: gstate with: mode
	"void pascal GrSetMixMode(GStateHandle gstate, MixMode mode) in graphics.h"
	^GEOS call: gstate with: mode with: #[0 5 93 1 1 0]!

GrRelMoveTo: gstate with: x with: y
	"void pascal GrRelMoveTo(GStateHandle gstate, WWFixedAsDWord x, WWFixedAsDWord y) in graphics.h"
	^GEOS call: gstate with: x with: y with: #[0 5 94 1 2 2 0]!

GrMoveToWWFixed: gstate with: x with: y
	"void pascal GrMoveToWWFixed(GStateHandle gstate, WWFixedAsDWord x, WWFixedAsDWord y) in graphics.h"
	^GEOS call: gstate with: x with: y with: #[0 6 182 1 2 2 0]!

GrDrawRelLineTo: gstate with: x with: y
	"void pascal GrDrawRelLineTo(GStateHandle gstate, WWFixedAsDWord x, WWFixedAsDWord y) in graphics.h"
	^GEOS call: gstate with: x with: y with: #[0 5 141 1 2 2 0]!

GrMoveTo: gstate with: x with: y
	"void pascal GrMoveTo(GStateHandle gstate, sword x, sword y) in graphics.h"
	^GEOS call: gstate with: x with: y with: #[0 5 95 1 4 4 0]!

GrSetLineColor: gstate with: flag with: redOrIndex with: green with: blue
	"void pascal GrSetLineColor(GStateHandle gstate, ColorFlag flag, word redOrIndex, word green, word blue) in graphics.h"
	^GEOS call: gstate with: flag with: redOrIndex with: green with: blue with: #[0 5 96 1 1 1 1 1 0]!

GrSetLineMaskSys: gstate with: sysDM
	"void pascal GrSetLineMaskSys(GStateHandle gstate, word sysDM) in graphics.h"
	^GEOS call: gstate with: sysDM with: #[0 5 97 1 1 0]!

GrSetLineMaskCustom: gstate with: dm
	"void pascal GrSetLineMaskCustom(GStateHandle gstate, const DrawMask *dm) in graphics.h"
	^GEOS call: gstate with: dm with: #[0 5 98 1 3 0]!

GrSetLineColorMap: gstate with: colorMap
	"void pascal GrSetLineColorMap(GStateHandle gstate, word colorMap) in graphics.h"
	^GEOS call: gstate with: colorMap with: #[0 5 99 1 1 0]!

GrSetLineWidth: gstate with: width
	"void pascal GrSetLineWidth(GStateHandle gstate, WWFixedAsDWord width) in graphics.h"
	^GEOS call: gstate with: width with: #[0 5 100 1 2 0]!

GrSetLineJoin: gstate with: join
	"void pascal GrSetLineJoin(GStateHandle gstate, LineJoin join) in graphics.h"
	^GEOS call: gstate with: join with: #[0 5 101 1 1 0]!

GrSetLineEnd: gstate with: end
	"void pascal GrSetLineEnd(GStateHandle gstate, LineEnd end) in graphics.h"
	^GEOS call: gstate with: end with: #[0 5 102 1 1 0]!

GrSetLineAttr: gstate with: la
	"void pascal GrSetLineAttr(GStateHandle gstate, const LineAttr *la) in graphics.h"
	^GEOS call: gstate with: la with: #[0 5 57 1 3 0]!

GrSetMiterLimit: gstate with: limit
	"void pascal GrSetMiterLimit(GStateHandle gstate, WWFixedAsDWord limit) in graphics.h"
	^GEOS call: gstate with: limit with: #[0 5 103 1 2 0]!

GrSetLineStyle: gstate with: style with: skipDistance with: dpa with: numPairs
	"void pascal GrSetLineStyle(GStateHandle gstate, LineStyle style, word skipDistance, const DashPairArray *dpa, word numPairs) in graphics.h"
	^GEOS call: gstate with: style with: skipDistance with: dpa with: numPairs with: #[0 5 104 1 1 1 3 1 0]!

GrSetAreaColor: gstate with: flag with: redOrIndex with: green with: blue
	"void pascal GrSetAreaColor(GStateHandle gstate, ColorFlag flag, word redOrIndex, word green, word blue) in graphics.h"
	^GEOS call: gstate with: flag with: redOrIndex with: green with: blue with: #[0 5 105 1 1 1 1 1 0]!

GrSetAreaMaskSys: gstate with: sysDM
	"void pascal GrSetAreaMaskSys(GStateHandle gstate, word sysDM) in graphics.h"
	^GEOS call: gstate with: sysDM with: #[0 5 106 1 1 0]!

GrSetAreaMaskCustom: gstate with: dm
	"void pascal GrSetAreaMaskCustom(GStateHandle gstate, const DrawMask *dm) in graphics.h"
	^GEOS call: gstate with: dm with: #[0 5 107 1 3 0]!

GrSetAreaColorMap: gstate with: colorMap
	"void pascal GrSetAreaColorMap(GStateHandle gstate, word colorMap) in graphics.h"
	^GEOS call: gstate with: colorMap with: #[0 5 108 1 1 0]!

GrSetAreaAttr: gstate with: aa
	"void pascal GrSetAreaAttr(GStateHandle gstate, const AreaAttr *aa) in graphics.h"
	^GEOS call: gstate with: aa with: #[0 5 58 1 3 0]!

GrSetTextColor: gstate with: flag with: redOrIndex with: green with: blue
	"void pascal GrSetTextColor(GStateHandle gstate, ColorFlag flag, word redOrIndex, word green, word blue) in graphics.h"
	^GEOS call: gstate with: flag with: redOrIndex with: green with: blue with: #[0 5 109 1 1 1 1 1 0]!

GrSetTextMaskSys: gstate with: sysDM
	"void pascal GrSetTextMaskSys(GStateHandle gstate, SysDrawMask sysDM) in graphics.h"
	^GEOS call: gstate with: sysDM with: #[0 5 110 1 1 0]!

GrSetTextMaskCustom: gstate with: dm
	"void pascal GrSetTextMaskCustom(GStateHandle gstate, const DrawMask *dm) in graphics.h"
	^GEOS call: gstate with: dm with: #[0 5 111 1 3 0]!

GrSetTextColorMap: gstate with: colorMap
	"void pascal GrSetTextColorMap(GStateHandle gstate, word colorMap) in graphics.h"
	^GEOS call: gstate with: colorMap with: #[0 5 112 1 1 0]!

GrSetTextStyle: gstate with: bitsToSet with: bitsToClear
	"void pascal GrSetTextStyle(GStateHandle gstate, TextStyle bitsToSet, TextStyle bitsToClear) in graphics.h"
	^GEOS call: gstate with: bitsToSet with: bitsToClear with: #[0 5 113 1 1 1 0]!

GrSetTextMode: gstate with: bitsToSet with: bitsToClear
	"void pascal GrSetTextMode(GStateHandle gstate, TextMode bitsToSet, TextMode bitsToClear) in graphics.h"
	^GEOS call: gstate with: bitsToSet with: bitsToClear with: #[0 5 114 1 1 1 0]!

GrSetTextDrawOffset: gstate with: numToDraw
	"void pascal GrSetTextDrawOffset(GStateHandle gstate, word numToDraw) in graphics.h"
	^GEOS call: gstate with: numToDraw with: #[0 6 114 1 1 0]!

GrSetTextSpacePad: gstate with: padding
	"void pascal GrSetTextSpacePad(GStateHandle gstate, WWFixedAsDWord padding) in graphics.h"
	^GEOS call: gstate with: padding with: #[0 5 115 1 2 0]!

GrSetTextAttr: gstate with: ta
	"void pascal GrSetTextAttr(GStateHandle gstate, const TextAttr *ta) in graphics.h"
	^GEOS call: gstate with: ta with: #[0 5 116 1 3 0]!

GrSetFont: gstate with: id with: pointSize
	"void pascal GrSetFont(GStateHandle gstate, FontID id, WWFixedAsDWord pointSize) in graphics.h"
	^GEOS call: gstate with: id with: pointSize with: #[0 5 117 1 1 2 0]!

GrSetGStringBounds: gstate with: left with: top with: right with: bottom
	"void pascal GrSetGStringBounds(GStateHandle gstate, sword left, sword top, sword right, sword bottom) in graphics.h"
	^GEOS call: gstate with: left with: top with: right with: bottom with: #[0 5 59 1 4 4 4 4 0]!

GrCreatePalette: gstate
	"word pascal GrCreatePalette(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 60 1 1]!

GrDestroyPalette: gstate
	"void pascal GrDestroyPalette(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 61 1 0]!

GrSetPaletteEntry: gstate with: index with: red with: green with: blue
	"void pascal GrSetPaletteEntry(GStateHandle gstate, word index, word red, word green, word blue) in graphics.h"
	^GEOS call: gstate with: index with: red with: green with: blue with: #[0 5 62 1 1 1 1 1 0]!

GrSetPalette: gstate with: buffer with: index with: numEntries
	"void pascal GrSetPalette(GStateHandle gstate, const RGBValue *buffer, word index, word numEntries) in graphics.h"
	^GEOS call: gstate with: buffer with: index with: numEntries with: #[0 5 63 1 3 1 1 0]!

GrSetTrackKern: gstate with: tk
	"void pascal GrSetTrackKern(GStateHandle gstate, word tk) in graphics.h"
	^GEOS call: gstate with: tk with: #[0 5 64 1 1 0]!

GrInitDefaultTransform: gstate
	"void pascal GrInitDefaultTransform(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 65 1 0]!

GrSetDefaultTransform: gstate
	"void pascal GrSetDefaultTransform(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 66 1 0]!

GrSetClipRect: gstate with: flags with: left with: top with: right with: bottom
	"void pascal GrSetClipRect(GStateHandle gstate, PathCombineType flags, sword left, sword top, sword right, sword bottom) in graphics.h"
	^GEOS call: gstate with: flags with: left with: top with: right with: bottom with: #[0 5 118 1 1 4 4 4 4 0]!

GrSetWinClipRect: gstate with: flags with: left with: top with: right with: bottom
	"void pascal GrSetWinClipRect(GStateHandle gstate, PathCombineType flags, sword left, sword top, sword right, sword bottom) in graphics.h"
	^GEOS call: gstate with: flags with: left with: top with: right with: bottom with: #[0 5 119 1 1 4 4 4 4 0]!

GrBeginPath: gstate with: params
	"void pascal GrBeginPath(GStateHandle gstate, PathCombineType params) in graphics.h"
	^GEOS call: gstate with: params with: #[0 5 121 1 1 0]!

GrEndPath: gstate
	"void pascal GrEndPath(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 122 1 0]!

GrCloseSubPath: gstate
	"void pascal GrCloseSubPath(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 123 1 0]!

GrSetClipPath: gstate with: params with: rule
	"void pascal GrSetClipPath(GStateHandle gstate, PathCombineType params, RegionFillRule rule) in graphics.h"
	^GEOS call: gstate with: params with: rule with: #[0 5 124 1 1 1 0]!

GrSetWinClipPath: gstate with: params with: rule
	"void pascal GrSetWinClipPath(GStateHandle gstate,PathCombineType params, RegionFillRule rule) in graphics.h"
	^GEOS call: gstate with: params with: rule with: #[0 5 125 1 1 1 0]!

GrFillPath: gstate with: rule
	"void pascal GrFillPath(GStateHandle gstate, RegionFillRule rule) in graphics.h"
	^GEOS call: gstate with: rule with: #[0 5 126 1 1 0]!

GrDrawPath: gstate
	"void pascal GrDrawPath(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 127 1 0]!

GrSetStrokePath: gstate
	"void pascal GrSetStrokePath(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 128 1 0]!

GrGetPathBounds: gstate with: ptype with: bounds
	"Boolean pascal GrGetPathBounds(GStateHandle gstate,GetPathType ptype,Rectangle *bounds) in graphics.h"
	^GEOS call: gstate with: ptype with: bounds with: #[0 5 129 1 1 3 4]!

GrGetPathBoundsDWord: gstate with: ptype with: bounds
	"Boolean pascal GrGetPathBoundsDWord(GStateHandle gstate,GetPathType ptype,RectDWord *bounds) in graphics.h"
	^GEOS call: gstate with: ptype with: bounds with: #[0 6 90 1 1 3 4]!

GrTestPath: gstate with: ptype
	"Boolean pascal GrTestPath(GStateHandle gstate,GetPathType ptype) in graphics.h"
	^GEOS call: gstate with: ptype with: #[0 6 189 1 1 4]!

GrInvalRect: gstate with: left with: top with: right with: bottom
	"void pascal GrInvalRect(GStateHandle gstate, sword left, sword top, sword right, sword bottom) in graphics.h"
	^GEOS call: gstate with: left with: top with: right with: bottom with: #[0 5 171 1 4 4 4 4 0]!

GrInvalRectDWord: gstate with: bounds
	"void pascal GrInvalRectDWord(GStateHandle gstate, const RectDWord *bounds) in graphics.h"
	^GEOS call: gstate with: bounds with: #[0 5 165 1 3 0]!

GrGetWinBoundsDWord: gstate with: bounds
	"void pascal GrGetWinBoundsDWord(GStateHandle gstate, RectDWord *bounds) in graphics.h"
	^GEOS call: gstate with: bounds with: #[0 5 167 1 3 0]!

GrGetMaskBoundsDWord: gstate with: bounds
	"void pascal GrGetMaskBoundsDWord(GStateHandle gstate, RectDWord *bounds) in graphics.h"
	^GEOS call: gstate with: bounds with: #[0 5 134 1 3 0]!

GrGetWinBounds: gstate with: bounds
	"void pascal GrGetWinBounds(GStateHandle gstate, Rectangle *bounds) in graphics.h"
	^GEOS call: gstate with: bounds with: #[0 5 166 1 3 0]!

GrGetMaskBounds: gstate with: bounds
	"void pascal GrGetMaskBounds(GStateHandle gstate, Rectangle *bounds) in graphics.h"
	^GEOS call: gstate with: bounds with: #[0 5 168 1 3 0]!

GrGetWinHandle: gstate
	"WindowHandle pascal GrGetWinHandle(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 135 1 1]!

GrGetGStringHandle: gstate
	"Handle pascal GrGetGStringHandle(GStateHandle gstate) in graphics.h"
	^GEOS call: gstate with: #[0 5 180 1 1]!

GrSetVMFile: gstate with: vmFile
	"void pascal GrSetVMFile(GStateHandle gstate, VMFileHandle vmFile) in graphics.h"
	^GEOS call: gstate with: vmFile with: #[0 6 187 1 1 0]!

GrTestPointInPath: gstate with: xPos with: yPos with: rule
	"Boolean pascal GrTestPointInPath(GStateHandle gstate, word xPos, word yPos, RegionFillRule rule) in graphics.h"
	^GEOS call: gstate with: xPos with: yPos with: rule with: #[0 5 130 1 1 1 1 4]!

GrGetPath: gstate with: ptype
	"MemHandle pascal GrGetPath(GStateHandle gstate, GetPathType ptype) in graphics.h"
	^GEOS call: gstate with: ptype with: #[0 5 181 1 1 1]!

GrTestPath: gstate with: ptype
	"Boolean pascal GrTestPath(GStateHandle gstate, GetPathType ptype) in graphics.h"
	^GEOS call: gstate with: ptype with: #[0 6 189 1 1 4]!

GrGetPathPoints: gstate with: resolution
	"MemHandle pascal GrGetPathPoints(GStateHandle gstate, word resolution) in graphics.h"
	^GEOS call: gstate with: resolution with: #[0 5 131 1 1 1]!

GrGetPathRegion: gstate with: rule
	"MemHandle pascal GrGetPathRegion(GStateHandle gstate, RegionFillRule rule) in graphics.h"
	^GEOS call: gstate with: rule with: #[0 5 132 1 1 1]!

GrGetClipRegion: gstate with: rule
	"MemHandle pascal GrGetClipRegion(GStateHandle gstate, RegionFillRule rule) in graphics.h"
	^GEOS call: gstate with: rule with: #[0 5 133 1 1 1]!

GrSetAreaPattern: gstate with: pattern
	"void pascal GrSetAreaPattern (GStateHandle gstate, GraphicPattern pattern) in graphics.h"
	^GEOS call: gstate with: pattern with: #[0 5 159 1 1 0]!

GrSetCustomAreaPattern: gstate with: pattern with: patternData with: patternSize
	"void pascal GrSetCustomAreaPattern (GStateHandle gstate, GraphicPattern pattern, const void *patternData, word patternSize) in graphics.h"
	^GEOS call: gstate with: pattern with: patternData with: patternSize with: #[0 5 160 1 1 3 1 0]!

GrSetTextPattern: gstate with: pattern
	"void pascal GrSetTextPattern (GStateHandle gstate, GraphicPattern pattern) in graphics.h"
	^GEOS call: gstate with: pattern with: #[0 5 161 1 1 0]!

GrSetCustomTextPattern: gstate with: pattern with: patternData
	"void pascal GrSetCustomTextPattern (GStateHandle gstate, GraphicPattern pattern, const void *patternData) in graphics.h"
	^GEOS call: gstate with: pattern with: patternData with: #[0 5 162 1 1 3 0]!

GrGetAreaPattern: gstate with: customPattern with: customSize
	"GraphicPattern pascal GrGetAreaPattern (GStateHandle gstate, const MemHandle *customPattern, word *customSize) in graphics.h"
	^GEOS call: gstate with: customPattern with: customSize with: #[0 5 163 1 3 3 1]!

GrGetTextPattern: gstate with: customPattern with: customSize
	"GraphicPattern pascal GrGetTextPattern (GStateHandle gstate, const MemHandle *customPattern, word *customSize) in graphics.h"
	^GEOS call: gstate with: customPattern with: customSize with: #[0 5 164 1 3 3 1]!

GrGetTextBounds: gstate with: str with: xpos with: ypos with: count with: bounds
	"Boolean pascal GrGetTextBounds(GStateHandle gstate, const char *str, word xpos, word ypos, word count, Rectangle *bounds) in graphics.h"
	^GEOS call: gstate with: str with: xpos with: ypos with: count with: bounds with: #[0 5 172 1 3 1 1 1 3 4]!

GrDrawGString: gstate with: gstringToDraw with: x with: y with: flags with: lastElement
	"GSRetType pascal GrDrawGString(GStateHandle gstate, GStateHandle gstringToDraw, sword x, sword y, GSControl flags, word *lastElement) in gstring.h"
	^GEOS call: gstate with: gstringToDraw with: x with: y with: flags with: lastElement with: #[0 5 186 1 1 4 4 1 3 1]!

GrDrawGStringAtCP: gstate with: gstringToDraw with: flags with: lastElement
	"GSRetType pascal GrDrawGStringAtCP(GStateHandle gstate, GStateHandle gstringToDraw, GSControl flags, word *lastElement) in gstring.h"
	^GEOS call: gstate with: gstringToDraw with: flags with: lastElement with: #[0 5 187 1 1 1 3 1]!

GrSetGStringPos: gstate with: type with: skip
	"void pascal GrSetGStringPos(GStateHandle gstate, GStringSetPosType type, word skip) in gstring.h"
	^GEOS call: gstate with: type with: skip with: #[0 5 188 1 1 1 0]!

GrCopyGString: source with: dest with: flags
	"GSRetType pascal GrCopyGString(GStateHandle source, GStateHandle dest, GSControl flags) in gstring.h"
	^GEOS call: source with: dest with: flags with: #[0 5 189 1 1 1 1]!

GrGetGStringBounds: gstring with: gstate with: flags with: bounds
	"Boolean pascal GrGetGStringBounds(Handle gstring, GStateHandle gstate, GSControl flags, Rectangle *bounds) in gstring.h"
	^GEOS call: gstring with: gstate with: flags with: bounds with: #[0 5 173 1 1 1 3 4]!

GrGetGStringBoundsDWord: gstring with: gstate with: flags with: bounds
	"void pascal GrGetGStringBoundsDWord(Handle gstring, GStateHandle gstate, GSControl flags, RectDWord *bounds) in gstring.h"
	^GEOS call: gstring with: gstate with: flags with: bounds with: #[0 6 83 1 1 1 3 0]!

GrDestroyGString: gstring with: gstate with: type
	"void pascal GrDestroyGString(GStateHandle gstring, GStateHandle gstate, GStringKillType type) in gstring.h"
	^GEOS call: gstring with: gstate with: type with: #[0 5 190 1 1 1 0]!

GrLoadGString: han with: hanType with: vmBlock
	"GStateHandle pascal GrLoadGString(Handle han, GStringType hanType, word vmBlock) in gstring.h"
	^GEOS call: han with: hanType with: vmBlock with: #[0 5 191 1 1 1 1]!

GrEditGString: vmFile with: vmBlock
	"GStateHandle pascal GrEditGString(Handle vmFile, word vmBlock) in gstring.h"
	^GEOS call: vmFile with: vmBlock with: #[0 5 194 1 1 1]!

GrCreateGString: han with: hanType with: vmBlock
	"GStateHandle pascal GrCreateGString(Handle han, GStringType hanType, word *vmBlock) in gstring.h"
	^GEOS call: han with: hanType with: vmBlock with: #[0 5 192 1 1 3 1]!

GrGetGStringElement: gstate with: gstring with: bufSize with: buffer with: elSize
	"GStringElement pascal GrGetGStringElement(GStateHandle gstate, GStateHandle gstring, word bufSize, void *buffer, word *elSize) in gstring.h"
	^GEOS call: gstate with: gstring with: bufSize with: buffer with: elSize with: #[0 5 193 1 1 1 3 3 1]!

GrDeleteGStringElement: gstate with: count
	"void pascal GrDeleteGStringElement(GStateHandle gstate, word count) in gstring.h"
	^GEOS call: gstate with: count with: #[0 6 160 1 1 0]!

GrLabel: gstate with: label
	"void pascal GrLabel(GStateHandle gstate, word label) in gstring.h"
	^GEOS call: gstate with: label with: #[0 5 174 1 1 0]!

TimerStart: timerType with: destObject with: ticks with: msg with: interval with: id
	"TimerHandle pascal TimerStart(TimerType timerType, optr destObject,word ticks, Message msg, word interval, word *id) in timer.h"
	^GEOS call: timerType with: destObject with: ticks with: msg with: interval with: id with: #[0 3 189 1 2 1 1 1 3 1]!

TimerStop: th with: id
	"Boolean pascal TimerStop(TimerHandle th, word id) in timer.h"
	^GEOS call: th with: id with: #[0 3 190 1 1 4]!

TimerSleep: ticks
	"void pascal TimerSleep(word ticks) in timer.h"
	^GEOS call: ticks with: #[0 3 191 1 0]!

TimerGetCount
	"dword pascal TimerGetCount(void) in timer.h"
	^GEOS call: #[0 3 192 2]!

VMLock: file with: block with: mh
	"void * pascal VMLock(VMFileHandle file, VMBlockHandle block, MemHandle *mh) in vm.h"
	^GEOS call: file with: block with: mh with: #[0 4 62 1 1 3 3]!

VMUnlock: mh
	"void pascal VMUnlock(MemHandle mh) in vm.h"
	^GEOS call: mh with: #[0 4 63 1 0]!

VMAlloc: file with: size with: userId
	"VMBlockHandle pascal VMAlloc(VMFileHandle file, word size, word userId) in vm.h"
	^GEOS call: file with: size with: userId with: #[0 4 65 1 1 1 1]!

VMFind: file with: startBlock with: userId
	"VMBlockHandle pascal VMFind(VMFileHandle file, VMBlockHandle startBlock, word userId) in vm.h"
	^GEOS call: file with: startBlock with: userId with: #[0 4 66 1 1 1 1]!

VMFree: file with: block
	"void pascal VMFree(VMFileHandle file, VMBlockHandle block) in vm.h"
	^GEOS call: file with: block with: #[0 4 67 1 1 0]!

VMDirty: mh
	"void pascal VMDirty(MemHandle mh) in vm.h"
	^GEOS call: mh with: #[0 4 64 1 0]!

VMModifyUserID: file with: block with: userId
	"void pascal VMModifyUserID(VMFileHandle file, VMBlockHandle block, word userId) in vm.h"
	^GEOS call: file with: block with: userId with: #[0 4 68 1 1 1 0]!

VMInfo: file with: block with: info
	"Boolean pascal VMInfo(VMFileHandle file, VMBlockHandle block, VMInfoStruct *info) in vm.h"
	^GEOS call: file with: block with: info with: #[0 4 69 1 1 3 4]!

VMGetDirtyState: file
	"word pascal VMGetDirtyState(VMFileHandle file) in vm.h"
	^GEOS call: file with: #[0 4 70 1 1]!

VMGetMapBlock: file
	"VMBlockHandle pascal VMGetMapBlock(VMFileHandle file) in vm.h"
	^GEOS call: file with: #[0 4 71 1 1]!

VMSetMapBlock: file with: block
	"void pascal VMSetMapBlock(VMFileHandle file, VMBlockHandle block) in vm.h"
	^GEOS call: file with: block with: #[0 4 72 1 1 0]!

VMOpen: name with: flags with: mode with: compression
	"VMFileHandle pascal VMOpen(char *name, VMAccessFlags flags, VMOpenType mode, word compression) in vm.h"
	^GEOS call: name with: flags with: mode with: compression with: #[0 4 73 3 1 1 1 1]!

VMUpdate: file
	"word pascal VMUpdate(VMFileHandle file) in vm.h"
	^GEOS call: file with: #[0 4 74 1 1]!

VMClose: file with: noErrorFlag
	"word pascal VMClose(VMFileHandle file, Boolean noErrorFlag) in vm.h"
	^GEOS call: file with: noErrorFlag with: #[0 6 130 1 4 1]!

VMGetAttributes: file
	"word pascal VMGetAttributes(VMFileHandle file) in vm.h"
	^GEOS call: file with: #[0 4 76 1 1]!

VMSetAttributes: file with: attrToSet with: AttrToClear
	"VMAttributes pascal VMSetAttributes(VMFileHandle file, VMAttributes attrToSet, VMAttributes AttrToClear) in vm.h"
	^GEOS call: file with: attrToSet with: AttrToClear with: #[0 4 77 1 1 1 1]!

VMGrabExclusive: file with: timeout with: operation with: currentOperation
	"VMStartExclusiveReturnValue pascal VMGrabExclusive(VMFileHandle file, word timeout, VMOperation operation, VMOperation *currentOperation) in vm.h"
	^GEOS call: file with: timeout with: operation with: currentOperation with: #[0 4 78 1 1 1 3 1]!

VMReleaseExclusive: file
	"void pascal VMReleaseExclusive(VMFileHandle file) in vm.h"
	^GEOS call: file with: #[0 4 79 1 0]!

VMCheckForModifications: file
	"Boolean pascal VMCheckForModifications(VMFileHandle file) in vm.h"
	^GEOS call: file with: #[0 4 92 1 4]!

VMAttach: file with: block with: mh
	"VMBlockHandle pascal VMAttach(VMFileHandle file, VMBlockHandle block, MemHandle mh) in vm.h"
	^GEOS call: file with: block with: mh with: #[0 4 81 1 1 1 1]!

VMDetach: file with: block with: owner
	"MemHandle pascal VMDetach(VMFileHandle file, VMBlockHandle block, GeodeHandle owner) in vm.h"
	^GEOS call: file with: block with: owner with: #[0 4 82 1 1 1 1]!

VMMemBlockToVMBlock: mh with: file
	"VMBlockHandle pascal VMMemBlockToVMBlock(MemHandle mh, VMFileHandle *file) in vm.h"
	^GEOS call: mh with: file with: #[0 4 83 1 3 1]!

VMVMBlockToMemBlock: file with: block
	"MemHandle pascal VMVMBlockToMemBlock(VMFileHandle file, VMBlockHandle block) in vm.h"
	^GEOS call: file with: block with: #[0 4 84 1 1 1]!

VMSave: file
	"Boolean pascal VMSave(VMFileHandle file) in vm.h"
	^GEOS call: file with: #[0 4 85 1 4]!

VMSaveAs: file with: name with: flags with: mode with: compression
	"VMFileHandle pascal VMSaveAs(VMFileHandle file, const char *name, VMAccessFlags flags, VMOpenType mode, word compression) in vm.h"
	^GEOS call: file with: name with: flags with: mode with: compression with: #[0 4 86 1 3 1 1 1 1]!

VMRevert: file
	"void pascal VMRevert(VMFileHandle file) in vm.h"
	^GEOS call: file with: #[0 4 87 1 0]!

VMPreserveBlocksHandle: file with: block
	"void pascal VMPreserveBlocksHandle(VMFileHandle file, VMBlockHandle block) in vm.h"
	^GEOS call: file with: block with: #[0 4 93 1 1 0]!

VMCopyVMChain: sourceFile with: sourceChain with: destFile
	"VMChain pascal VMCopyVMChain(VMFileHandle sourceFile, VMChain sourceChain, VMFileHandle destFile) in vm.h"
	^GEOS call: sourceFile with: sourceChain with: destFile with: #[0 6 188 1 2 1 2]!

VMFreeVMChain: file with: chain
	"void pascal VMFreeVMChain(VMFileHandle file, VMChain chain) in vm.h"
	^GEOS call: file with: chain with: #[0 6 178 1 2 0]!

VMCompareVMChains: sourceFile with: sourceChain with: destFile with: destChain
	"Boolean pascal VMCompareVMChains(VMFileHandle sourceFile, VMChain sourceChain, VMFileHandle destFile, VMChain destChain) in vm.h"
	^GEOS call: sourceFile with: sourceChain with: destFile with: destChain with: #[0 6 179 1 2 1 2 4]!

VMInfoVMChain: sourceFile with: sourceChain with: chainSize with: vmBlockCount with: dbItemCount
	"Boolean pascal VMInfoVMChain(VMFileHandle sourceFile, VMChain sourceChain, dword *chainSize, word *vmBlockCount, word *dbItemCount ) in vm.h"
	^GEOS call: sourceFile with: sourceChain with: chainSize with: vmBlockCount with: dbItemCount with: #[0 6 213 1 2 3 3 3 4]!

VMCopyVMBlock: sourceFile with: sourceBlock with: destFile
	"VMBlockHandle pascal VMCopyVMBlock(VMFileHandle sourceFile, VMBlockHandle sourceBlock, VMFileHandle destFile) in vm.h"
	^GEOS call: sourceFile with: sourceBlock with: destFile with: #[0 4 91 1 1 1 1]!

VMSetExecThread: file with: thread
	"void pascal VMSetExecThread(VMFileHandle file, ThreadHandle thread) in vm.h"
	^GEOS call: file with: thread with: #[0 4 94 1 1 0]!

VMAllocLMem: file with: ltype with: headerSize
	"VMBlockHandle pascal VMAllocLMem(VMFileHandle file, LMemType ltype, word headerSize) in vm.h"
	^GEOS call: file with: ltype with: headerSize with: #[0 4 95 1 1 1 1]!

VMGetHeaderInfo: file with: vmInfo
	"void pascal VMGetHeaderInfo(VMFileHandle file, VMHeaderInfoStruct *vmInfo) in vm.h"
	^GEOS call: file with: vmInfo with: #[0 6 185 1 3 0]!

VMDiscardDirtyBlocks: file
	"word pascal VMDiscardDirtyBlocks(VMFileHandle file) in vm.h"
	^GEOS call: file with: #[0 6 197 1 1]!

VMSetDirtyLimit: file with: dirtyLimit
	"void pascal VMSetDirtyLimit(VMFileHandle file, word dirtyLimit) in vm.h"
	^GEOS call: file with: dirtyLimit with: #[0 6 216 1 1 0]!

DBLockUngrouped: file with: id
	"void * pascal DBLockUngrouped(VMFileHandle file, DBGroupAndItem id) in dbase.h"
	^GEOS call: file with: id with: #[0 4 96 1 2 3]!

DBLockGetRefUngrouped: file with: id with: refPtr
	"void * pascal DBLockGetRefUngrouped(VMFileHandle file, DBGroupAndItem id, optr *refPtr) in dbase.h"
	^GEOS call: file with: id with: refPtr with: #[0 4 100 1 2 3 3]!

DBUnlock: ptr
	"void pascal DBUnlock(void *ptr) in dbase.h"
	^GEOS call: ptr with: #[0 4 97 3 0]!

DBDirty: ptr
	"void pascal DBDirty(const void *ptr) in dbase.h"
	^GEOS call: ptr with: #[0 4 98 3 0]!

DBRawAlloc: file with: group with: size
	"DBGroupAndItem pascal DBRawAlloc(VMFileHandle file, DBGroup group, word size) in dbase.h"
	^GEOS call: file with: group with: size with: #[0 4 101 1 1 1 2]!

DBReAllocUngrouped: file with: id with: size
	"void pascal DBReAllocUngrouped(VMFileHandle file, DBGroupAndItem id, word size) in dbase.h"
	^GEOS call: file with: id with: size with: #[0 4 102 1 2 1 0]!

DBFreeUngrouped: file with: id
	"void pascal DBFreeUngrouped(VMFileHandle file, DBGroupAndItem id) in dbase.h"
	^GEOS call: file with: id with: #[0 4 103 1 2 0]!

DBGroupAlloc: file
	"DBGroup pascal DBGroupAlloc(VMFileHandle file) in dbase.h"
	^GEOS call: file with: #[0 4 104 1 1]!

DBGroupFree: file with: group
	"void pascal DBGroupFree(VMFileHandle file, DBGroup group) in dbase.h"
	^GEOS call: file with: group with: #[0 4 105 1 1 0]!

DBSetMapUngrouped: file with: id
	"void pascal DBSetMapUngrouped(VMFileHandle file, DBGroupAndItem id) in dbase.h"
	^GEOS call: file with: id with: #[0 4 108 1 2 0]!

DBGetMap: file
	"DBGroupAndItem pascal DBGetMap(VMFileHandle file) in dbase.h"
	^GEOS call: file with: #[0 4 99 1 2]!

DBInsertAtUngrouped: file with: id with: insertOffset with: insertCount
	"void pascal DBInsertAtUngrouped(VMFileHandle file, DBGroupAndItem id, word insertOffset, word insertCount) in dbase.h"
	^GEOS call: file with: id with: insertOffset with: insertCount with: #[0 4 106 1 2 1 1 0]!

DBDeleteAtUngrouped: file with: id with: deleteOffset with: deleteCount
	"void pascal DBDeleteAtUngrouped(VMFileHandle file, DBGroupAndItem id, word deleteOffset, word deleteCount) in dbase.h"
	^GEOS call: file with: id with: deleteOffset with: deleteCount with: #[0 4 107 1 2 1 1 0]!

DBRawCopyDBItem: srcFile with: srcID with: destFile with: destGroup
	"DBGroupAndItem pascal DBRawCopyDBItem(VMFileHandle srcFile, DBGroupAndItem srcID, VMFileHandle destFile, DBGroup destGroup) in dbase.h"
	^GEOS call: srcFile with: srcID with: destFile with: destGroup with: #[0 4 109 1 2 1 1 2]!

DBInfoUngrouped: file with: grpAndItem with: sizePtr
	"Boolean pascal DBInfoUngrouped(VMFileHandle file, DBGroupAndItem grpAndItem, word *sizePtr) in dbase.h"
	^GEOS call: file with: grpAndItem with: sizePtr with: #[0 6 214 1 2 3 4]!

TimerGetDateAndTime: dateAndTime
	"void pascal TimerGetDateAndTime(TimerDateAndTime *dateAndTime) in timedate.h"
	^GEOS call: dateAndTime with: #[0 3 193 3 0]!

TimerSetDateAndTime: flags with: dateAndTime
	"void pascal TimerSetDateAndTime(word flags, const TimerDateAndTime *dateAndTime) in timedate.h"
	^GEOS call: flags with: dateAndTime with: #[0 3 194 1 3 0]!

TimerGetFileDateTime
	"TimerFileDateTime pascal TimerGetFileDateTime(void) in timedate.h"
	^GEOS call: #[0 6 175 2]!

FileCreateDir: name
	"word pascal FileCreateDir(const char *name) in file.h"
	^GEOS call: name with: #[0 3 100 3 1]!

FileDeleteDir: name
	"word pascal FileDeleteDir(const char *name) in file.h"
	^GEOS call: name with: #[0 3 101 3 1]!

FilePushDir
	"void pascal FilePushDir(void) in file.h"
	^GEOS call: #[0 0 103 0]!

FilePopDir
	"void pascal FilePopDir(void) in file.h"
	^GEOS call: #[0 0 104 0]!

FileGetCurrentPath: buffer with: bufferSize
	"DiskHandle pascal FileGetCurrentPath(char *buffer, word bufferSize) in file.h"
	^GEOS call: buffer with: bufferSize with: #[0 3 102 3 1 1]!

FileGetCurrentPathIDs: block
	"ChunkHandle pascal FileGetCurrentPathIDs(MemHandle block) in file.h"
	^GEOS call: block with: #[0 6 74 1 1]!

FileEnableOpenCloseNotification
	"void pascal FileEnableOpenCloseNotification(void) in file.h"
	^GEOS call: #[0 6 69 0]!

FileDisableOpenCloseNotification
	"void pascal FileDisableOpenCloseNotification(void) in file.h"
	^GEOS call: #[0 6 70 0]!

FileBatchChangeNotifications
	"void pascal FileBatchChangeNotifications(void) in file.h"
	^GEOS call: #[0 6 71 0]!

FileFlushChangeNotifications
	"void pascal FileFlushChangeNotifications(void) in file.h"
	^GEOS call: #[0 6 72 0]!

FileSetCurrentPath: disk with: path
	"DiskHandle pascal FileSetCurrentPath(DiskHandle disk, const char *path) in file.h"
	^GEOS call: disk with: path with: #[0 3 103 1 3 1]!

FileOpen: name with: flags
	"FileHandle pascal FileOpen(const char *name, FileAccessFlags flags) in file.h"
	^GEOS call: name with: flags with: #[0 3 104 3 1 1]!

FileCreate: name with: flags with: attributes
	"FileHandle pascal FileCreate(const char *name, FileCreateFlags flags, FileAttrs attributes) in file.h"
	^GEOS call: name with: flags with: attributes with: #[0 3 105 3 1 1 1]!

FileClose: fh with: noErrorFlag
	"word pascal FileClose(FileHandle fh, Boolean noErrorFlag) in file.h"
	^GEOS call: fh with: noErrorFlag with: #[0 3 106 1 4 1]!

FileCommit: fh with: noErrorFlag
	"word pascal FileCommit(FileHandle fh, Boolean noErrorFlag) in file.h"
	^GEOS call: fh with: noErrorFlag with: #[0 3 107 1 4 1]!

FileCreateTempFile: dir with: flags with: attributes
	"FileHandle pascal FileCreateTempFile(const char *dir, FileCreateFlags flags, FileAttrs attributes) in file.h"
	^GEOS call: dir with: flags with: attributes with: #[0 3 108 3 1 1 1]!

FileDelete: name
	"word pascal FileDelete(const char *name) in file.h"
	^GEOS call: name with: #[0 3 109 3 1]!

FileRename: oldName with: newame
	"word pascal FileRename(const char *oldName, const char *newame) in file.h"
	^GEOS call: oldName with: newame with: #[0 3 110 3 3 1]!

FileRead: fh with: buf with: count with: noErrorFlag
	"word pascal FileRead(FileHandle fh, void *buf, word count, Boolean noErrorFlag) in file.h"
	^GEOS call: fh with: buf with: count with: noErrorFlag with: #[0 3 111 1 3 1 4 1]!

FileWrite: fh with: buf with: count with: noErrorFlag
	"word pascal FileWrite(FileHandle fh, const void *buf, word count, Boolean noErrorFlag) in file.h"
	^GEOS call: fh with: buf with: count with: noErrorFlag with: #[0 3 112 1 3 1 4 1]!

FilePos: fh with: posOrOffset with: mode
	"dword pascal FilePos(FileHandle fh, dword posOrOffset, FilePosMode mode) in file.h"
	^GEOS call: fh with: posOrOffset with: mode with: #[0 3 113 1 2 1 2]!

FileTruncate: fh with: offset with: noErrorFlag
	"word pascal FileTruncate(FileHandle fh, dword offset, Boolean noErrorFlag) in file.h"
	^GEOS call: fh with: offset with: noErrorFlag with: #[0 3 114 1 2 4 1]!

FileSize: fh
	"dword pascal FileSize(FileHandle fh) in file.h"
	^GEOS call: fh with: #[0 3 115 1 2]!

FileGetDateAndTime: fh
	"FileDateAndTime pascal FileGetDateAndTime(FileHandle fh) in file.h"
	^GEOS call: fh with: #[0 3 116 1 2]!

FileSetDateAndTime: fh with: dateAndTime
	"word pascal FileSetDateAndTime(FileHandle fh, FileDateAndTime dateAndTime) in file.h"
	^GEOS call: fh with: dateAndTime with: #[0 3 117 1 2 1]!

FileDuplicateHandle: fh
	"FileHandle pascal FileDuplicateHandle(FileHandle fh) in file.h"
	^GEOS call: fh with: #[0 3 118 1 1]!

FileLockRecord: fh with: filePos with: regLength
	"word pascal FileLockRecord(FileHandle fh, dword filePos, dword regLength) in file.h"
	^GEOS call: fh with: filePos with: regLength with: #[0 3 119 1 2 2 1]!

FileUnlockRecord: fh with: filePos with: regLength
	"word pascal FileUnlockRecord(FileHandle fh, dword filePos, dword regLength) in file.h"
	^GEOS call: fh with: filePos with: regLength with: #[0 3 120 1 2 2 1]!

FileGetDiskHandle: fh
	"DiskHandle pascal FileGetDiskHandle(FileHandle fh) in file.h"
	^GEOS call: fh with: #[0 3 121 1 1]!

FileGetAttributes: path
	"FileAttrs pascal FileGetAttributes(const char *path) in file.h"
	^GEOS call: path with: #[0 3 122 3 1]!

FileSetAttributes: path with: attr
	"word pascal FileSetAttributes(const char *path, FileAttrs attr) in file.h"
	^GEOS call: path with: attr with: #[0 3 123 3 1 1]!

FileGetPathExtAttributes: path with: attr with: buffer with: bufSize
	"word pascal FileGetPathExtAttributes(const char *path, FileExtendedAttribute attr, void *buffer, word bufSize) in file.h"
	^GEOS call: path with: attr with: buffer with: bufSize with: #[0 3 129 3 1 3 1 1]!

FileGetHandleExtAttributes: fh with: attr with: buffer with: bufSize
	"word pascal FileGetHandleExtAttributes(FileHandle fh, FileExtendedAttribute attr, void *buffer, word bufSize) in file.h"
	^GEOS call: fh with: attr with: buffer with: bufSize with: #[0 3 131 1 1 3 1 1]!

FileGetHandleAllExtAttributes: fh with: numExtAttrs
	"MemHandle pascal FileGetHandleAllExtAttributes(FileHandle fh, word *numExtAttrs) in file.h"
	^GEOS call: fh with: numExtAttrs with: #[0 6 199 1 3 1]!

FileSetPathExtAttributes: path with: attr with: buffer with: bufSize
	"word pascal FileSetPathExtAttributes(const char *path, FileExtendedAttribute attr, const void *buffer, word bufSize) in file.h"
	^GEOS call: path with: attr with: buffer with: bufSize with: #[0 3 130 3 1 3 1 1]!

FileSetHandleExtAttributes: fh with: attr with: buffer with: bufSize
	"word pascal FileSetHandleExtAttributes(FileHandle fh, FileExtendedAttribute attr, const void *buffer, word bufSize) in file.h"
	^GEOS call: fh with: attr with: buffer with: bufSize with: #[0 3 132 1 1 3 1 1]!

FileSetStandardPath: sp
	"void pascal FileSetStandardPath(StandardPath sp) in file.h"
	^GEOS call: sp with: #[0 3 124 1 0]!

FileSetRootPath: disk
	"void pascal FileSetRootPath(DiskHandle disk) in file.h"
	^GEOS call: disk with: #[0 6 232 1 0]!

FileCopy: source with: dest with: sourceDisk with: destDisk
	"word pascal FileCopy(const char *source, const char *dest, DiskHandle sourceDisk, DiskHandle destDisk) in file.h"
	^GEOS call: source with: dest with: sourceDisk with: destDisk with: #[0 3 125 3 3 1 1 1]!

FileCopyLocal: source with: dest with: sourceDisk with: destDisk
	"word pascal FileCopyLocal(const char *source, const char *dest, DiskHandle sourceDisk, DiskHandle destDisk) in file.h"
	^GEOS call: source with: dest with: sourceDisk with: destDisk with: #[0 6 229 3 3 1 1 1]!

FileMove: source with: dest with: sourceDisk with: destDisk
	"word pascal FileMove(const char *source, const char *dest, DiskHandle sourceDisk, DiskHandle destDisk) in file.h"
	^GEOS call: source with: dest with: sourceDisk with: destDisk with: #[0 3 126 3 3 1 1 1]!

FileMoveLocal: source with: dest with: sourceDisk with: destDisk
	"word pascal FileMoveLocal(const char *source, const char *dest, DiskHandle sourceDisk, DiskHandle destDisk) in file.h"
	^GEOS call: source with: dest with: sourceDisk with: destDisk with: #[0 6 230 3 3 1 1 1]!

FileParseStandardPath: disk with: path
	"StandardPath pascal FileParseStandardPath(DiskHandle disk, const char **path) in file.h"
	^GEOS call: disk with: path with: #[0 3 128 1 3 1]!

FileConstructFullPath: buffer with: bufSize with: disk with: tail with: addDriveLetter
	"DiskHandle pascal FileConstructFullPath(char **buffer, word bufSize, DiskHandle disk, const char *tail, Boolean addDriveLetter) in file.h"
	^GEOS call: buffer with: bufSize with: disk with: tail with: addDriveLetter with: #[0 3 127 3 1 1 3 4 1]!

FileResolveStandardPath: buffer with: bufSize with: tail with: flags with: attrsPtr
	"DiskHandle pascal FileResolveStandardPath(char **buffer, word bufSize, const char *tail, FileResolveStandardPathFlags flags, FileAttrs *attrsPtr) in file.h"
	^GEOS call: buffer with: bufSize with: tail with: flags with: attrsPtr with: #[0 3 135 3 1 3 1 3 1]!

FileComparePaths: path1 with: disk1 with: path2 with: disk2
	"PathCompareType pascal FileComparePaths(const char *path1, DiskHandle disk1, const char *path2, DiskHandle disk2) in file.h"
	^GEOS call: path1 with: disk1 with: path2 with: disk2 with: #[0 3 137 3 1 3 1 1]!

FileCreateLink: path with: targetDiskHandle with: targetPath with: targetAttrsFlag
	"word pascal FileCreateLink(const char *path, word targetDiskHandle, const char *targetPath, word targetAttrsFlag) in file.h"
	^GEOS call: path with: targetDiskHandle with: targetPath with: targetAttrsFlag with: #[0 3 138 3 1 3 1 1]!

FileReadLink: path with: targetPath
	"DiskHandle pascal FileReadLink(const char *path, const char *targetPath) in file.h"
	^GEOS call: path with: targetPath with: #[0 3 140 3 3 1]!

FileSetLinkExtraData: path with: buffer with: bufSize
	"DiskHandle pascal FileSetLinkExtraData(const char *path, char *buffer, word bufSize) in file.h"
	^GEOS call: path with: buffer with: bufSize with: #[0 3 141 3 3 1 1]!

FileGetLinkExtraData: path with: buffer with: bufSize
	"DiskHandle pascal FileGetLinkExtraData(const char *path, char *buffer, word bufSize) in file.h"
	^GEOS call: path with: buffer with: bufSize with: #[0 3 139 3 3 1 1]!

FileConstructActualPath: buffer with: bufSize with: disk with: tail with: addDriveLetter
	"DiskHandle pascal FileConstructActualPath(char **buffer, word bufSize, DiskHandle disk, const char *tail, Boolean addDriveLetter) in file.h"
	^GEOS call: buffer with: bufSize with: disk with: tail with: addDriveLetter with: #[0 3 136 3 1 1 3 4 1]!

FileCopyPathExtAttributes: sourcePath with: sourceDisk with: destPath with: destDisk
	"word pascal FileCopyPathExtAttributes(const char *sourcePath, DiskHandle sourceDisk, const char *destPath, DiskHandle destDisk) in file.h"
	^GEOS call: sourcePath with: sourceDisk with: destPath with: destDisk with: #[0 6 63 3 1 3 1 1]!

FileOpenAndRead: flags with: filename with: fh
	"MemHandle pascal FileOpenAndRead(FileOpenAndReadFlags flags, const char *filename, FileHandle *fh) in file.h"
	^GEOS call: flags with: filename with: fh with: #[0 6 121 1 3 3 1]!

LocalDistanceToAscii: buffer with: value with: distanceUnits with: measurementType with: flags
	"word pascal LocalDistanceToAscii(char *buffer, WWFixedAsDWord value, DistanceUnit distanceUnits, word measurementType, LocalDistanceFlags flags) in localize.h"
	^GEOS call: buffer with: value with: distanceUnits with: measurementType with: flags with: #[0 4 39 3 2 1 1 1 1]!

LocalDistanceFromAscii: buffer with: distanceUnits with: measurementType
	"WWFixedAsDWord pascal LocalDistanceFromAscii(const char *buffer, DistanceUnit distanceUnits, MeasurementType measurementType) in localize.h"
	^GEOS call: buffer with: distanceUnits with: measurementType with: #[0 4 40 3 1 1 2]!

LocalFixedToAscii: buffer with: value with: fracDigits
	"void pascal LocalFixedToAscii(char *buffer, WWFixedAsDWord value, word fracDigits) in localize.h"
	^GEOS call: buffer with: value with: fracDigits with: #[0 4 41 3 2 1 0]!

LocalAsciiToFixed: buffer with: parseEnd
	"WWFixedAsDWord pascal LocalAsciiToFixed(const char *buffer, char **parseEnd) in localize.h"
	^GEOS call: buffer with: parseEnd with: #[0 4 42 3 3 2]!

LocalSetDateTimeFormat: str with: format
	"void pascal LocalSetDateTimeFormat(const char *str, DateTimeFormat format) in localize.h"
	^GEOS call: str with: format with: #[0 4 32 3 1 0]!

LocalGetDateTimeFormat: str with: format
	"void pascal LocalGetDateTimeFormat(char *str, DateTimeFormat format) in localize.h"
	^GEOS call: str with: format with: #[0 3 253 3 1 0]!

LocalFormatDateTime: str with: format with: dateTime
	"word pascal LocalFormatDateTime(char *str, DateTimeFormat format, const TimerDateAndTime *dateTime) in localize.h"
	^GEOS call: str with: format with: dateTime with: #[0 3 254 3 1 3 1]!

LocalFormatFileDateTime: str with: format with: dateTime
	"word pascal LocalFormatFileDateTime(char *str, DateTimeFormat format, const FileDateAndTime *dateTime) in localize.h"
	^GEOS call: str with: format with: dateTime with: #[0 6 65 3 1 3 1]!

LocalParseDateTime: str with: format with: dateTime
	"Boolean pascal LocalParseDateTime(const char *str, DateTimeFormat format, TimerDateAndTime *dateTime) in localize.h"
	^GEOS call: str with: format with: dateTime with: #[0 3 255 3 1 3 4]!

LocalCustomParseDateTime: str with: format with: dateTime
	"word pascal LocalCustomParseDateTime(const char *str, const char *format, TimerDateAndTime *dateTime) in localize.h"
	^GEOS call: str with: format with: dateTime with: #[0 4 51 3 3 3 1]!

LocalCalcDaysInMonth: year with: month
	"word pascal LocalCalcDaysInMonth(word year, word month) in localize.h"
	^GEOS call: year with: month with: #[0 6 86 1 1 1]!

ToUpper: ch
	"word pascal ToUpper(wchar ch) in localize.h"
	^GEOS call: ch with: #[0 4 0 4 1]!

ToLower: ch
	"word pascal ToLower(wchar ch) in localize.h"
	^GEOS call: ch with: #[0 4 1 4 1]!

LocalUpcaseString: str with: size
	"void pascal LocalUpcaseString(char *str, word size) in localize.h"
	^GEOS call: str with: size with: #[0 4 2 3 1 0]!

LocalDowncaseString: str with: size
	"void pascal LocalDowncaseString(char *str, word size) in localize.h"
	^GEOS call: str with: size with: #[0 4 3 3 1 0]!

LocalCmpStrings: str1 with: str2 with: strSize
	"sword pascal LocalCmpStrings(const char *str1, const char *str2, word strSize) in localize.h"
	^GEOS call: str1 with: str2 with: strSize with: #[0 4 4 3 3 1 4]!

LocalCmpStringsNoCase: str1 with: str2 with: strSize
	"sword pascal LocalCmpStringsNoCase(const char *str1, const char *str2, word strSize) in localize.h"
	^GEOS call: str1 with: str2 with: strSize with: #[0 4 5 3 3 1 4]!

LocalCmpStringsNoSpace: str1 with: str2 with: strSize
	"sword pascal LocalCmpStringsNoSpace(const char *str1, const char *str2, word strSize) in localize.h"
	^GEOS call: str1 with: str2 with: strSize with: #[0 4 49 3 3 1 4]!

LocalCmpStringsNoSpaceCase: str1 with: str2 with: strSize
	"sword pascal LocalCmpStringsNoSpaceCase(const char *str1, const char *str2, word strSize) in localize.h"
	^GEOS call: str1 with: str2 with: strSize with: #[0 4 50 3 3 1 4]!

LocalIsSymbol: ch
	"Boolean pascal LocalIsSymbol(wchar ch) in localize.h"
	^GEOS call: ch with: #[0 4 11 4 4]!

LocalIsDateChar: ch
	"Boolean pascal LocalIsDateChar(wchar ch) in localize.h"
	^GEOS call: ch with: #[0 4 12 4 4]!

LocalIsTimeChar: ch
	"Boolean pascal LocalIsTimeChar(wchar ch) in localize.h"
	^GEOS call: ch with: #[0 4 13 4 4]!

LocalIsNumChar: ch
	"Boolean pascal LocalIsNumChar(wchar ch) in localize.h"
	^GEOS call: ch with: #[0 4 14 4 4]!

LocalIsDosChar: ch
	"Boolean pascal LocalIsDosChar(wchar ch) in localize.h"
	^GEOS call: ch with: #[0 4 15 4 4]!

LocalDosToGeos: str with: strSize with: defaultChar
	"Boolean pascal LocalDosToGeos(char *str, word strSize, wchar defaultChar) in localize.h"
	^GEOS call: str with: strSize with: defaultChar with: #[0 4 19 3 1 4 4]!

LocalGeosToDos: str with: strSize with: defaultChar
	"Boolean pascal LocalGeosToDos(char *str, word strSize, wchar defaultChar) in localize.h"
	^GEOS call: str with: strSize with: defaultChar with: #[0 4 20 3 1 4 4]!

LocalGetQuotes: quotes
	"void pascal LocalGetQuotes(LocalQuotes *quotes) in localize.h"
	^GEOS call: quotes with: #[0 4 21 3 0]!

LocalSetQuotes: quotes
	"void pascal LocalSetQuotes(const LocalQuotes *quotes) in localize.h"
	^GEOS call: quotes with: #[0 4 33 3 0]!

LocalCustomFormatDateTime: str with: format with: dateTime
	"word pascal LocalCustomFormatDateTime(char *str, const char *format, const TimerDateAndTime *dateTime) in localize.h"
	^GEOS call: str with: format with: dateTime with: #[0 4 22 3 3 3 1]!

LocalGetNumericFormat: buf
	"void pascal LocalGetNumericFormat(LocalNumericFormat *buf) in localize.h"
	^GEOS call: buf with: #[0 4 23 3 0]!

LocalSetNumericFormat: buf
	"void pascal LocalSetNumericFormat(const LocalNumericFormat *buf) in localize.h"
	^GEOS call: buf with: #[0 4 34 3 0]!

LocalGetCurrencyFormat: buf with: symbol
	"void pascal LocalGetCurrencyFormat(LocalCurrencyFormat *buf, char *symbol) in localize.h"
	^GEOS call: buf with: symbol with: #[0 4 24 3 3 0]!

LocalSetCurrencyFormat: buf with: symbol
	"void pascal LocalSetCurrencyFormat(const LocalCurrencyFormat *buf, const char *symbol) in localize.h"
	^GEOS call: buf with: symbol with: #[0 4 35 3 3 0]!

LocalCmpStringsDosToGeos: str1 with: str2 with: strSize with: defaultChar with: flags
	"sword pascal LocalCmpStringsDosToGeos(const char *str1, const char *str2, word strSize, wchar defaultChar, LocalCmpStringsDosToGeosFlags flags) in localize.h"
	^GEOS call: str1 with: str2 with: strSize with: defaultChar with: flags with: #[0 4 25 3 3 1 4 1 4]!

LocalIsCodePageSupported: codePage
	"Boolean pascal LocalIsCodePageSupported(DosCodePage codePage) in localize.h"
	^GEOS call: codePage with: #[0 6 92 1 4]!

LocalCodePageToGeos: str with: strSize with: codePage with: defaultChar
	"Boolean pascal LocalCodePageToGeos(char *str, word strSize, DosCodePage codePage, wchar defaultChar) in localize.h"
	^GEOS call: str with: strSize with: codePage with: defaultChar with: #[0 4 26 3 1 1 4 4]!

LocalGeosToCodePage: str with: strSize with: codePage with: defaultChar
	"Boolean pascal LocalGeosToCodePage(char *str, word strSize, DosCodePage codePage, wchar defaultChar) in localize.h"
	^GEOS call: str with: strSize with: codePage with: defaultChar with: #[0 4 27 3 1 1 4 4]!

LocalCodePageToGeosChar: ch with: codePage with: defaultChar
	"wchar pascal LocalCodePageToGeosChar(wchar ch, DosCodePage codePage, wchar defaultChar) in localize.h"
	^GEOS call: ch with: codePage with: defaultChar with: #[0 4 28 4 1 4 4]!

LocalGeosToCodePageChar: ch with: codePage with: defaultChar
	"wchar pascal LocalGeosToCodePageChar(wchar ch, DosCodePage codePage, wchar defaultChar) in localize.h"
	^GEOS call: ch with: codePage with: defaultChar with: #[0 4 29 4 1 4 4]!

LocalDosToGeosChar: ch with: defaultChar
	"wchar pascal LocalDosToGeosChar(wchar ch, wchar defaultChar) in localize.h"
	^GEOS call: ch with: defaultChar with: #[0 4 16 4 4 4]!

LocalGeosToDosChar: ch with: defaultChar
	"wchar pascal LocalGeosToDosChar(wchar ch, wchar defaultChar) in localize.h"
	^GEOS call: ch with: defaultChar with: #[0 4 17 4 4 4]!

LocalGetCodePage
	"DosCodePage pascal LocalGetCodePage(void) in localize.h"
	^GEOS call: #[0 4 18 1]!

LocalSetCodePage: dcp
	"Handle pascal LocalSetCodePage(DosCodePage dcp) in localize.h"
	^GEOS call: dcp with: #[0 6 233 1 1]!

LocalGetMeasurementType
	"MeasurementType pascal LocalGetMeasurementType(void) in localize.h"
	^GEOS call: #[0 2 99 1]!

LocalSetMeasurementType: meas
	"void pascal LocalSetMeasurementType(MeasurementType meas) in localize.h"
	^GEOS call: meas with: #[0 4 36 1 0]!

LocalLexicalValue: ch
	"word pascal LocalLexicalValue(wchar ch) in localize.h"
	^GEOS call: ch with: #[0 4 30 4 1]!

LocalLexicalValueNoCase: ch
	"word pascal LocalLexicalValueNoCase(wchar ch) in localize.h"
	^GEOS call: ch with: #[0 4 31 4 1]!

LocalStringSize: str
	"word pascal LocalStringSize(const char *str) in localize.h"
	^GEOS call: str with: #[0 4 37 3 1]!

LocalStringLength: str
	"word pascal LocalStringLength(const char *str) in localize.h"
	^GEOS call: str with: #[0 4 38 3 1]!

LocalGetLanguage
	"word pascal LocalGetLanguage(void) in localize.h"
	^GEOS call: #[0 4 52 1]!

DosExec: prog with: progDisk with: arguments with: execDir with: execDisk with: flags
	"word cdecl DosExec(const char *prog, DiskHandle progDisk, const char *arguments, const char *execDir, DiskHandle execDisk, DosExecFlags flags) in system.h"
	^GEOS call: prog with: progDisk with: arguments with: execDir with: execDisk with: flags with: #[128 3 195 3 1 3 3 1 1 1]!

SysLocateFileInDosPath: fname with: buffer
	"DiskHandle cdecl SysLocateFileInDosPath(const char *fname, char *buffer) in system.h"
	^GEOS call: fname with: buffer with: #[128 0 110 3 3 1]!

SysGetDosEnvironment: variable with: buffer with: bufSize
	"Boolean pascal SysGetDosEnvironment(const char *variable, char *buffer, word bufSize) in system.h"
	^GEOS call: variable with: buffer with: bufSize with: #[0 3 197 3 3 1 4]!

SysNotify: flags with: string1 with: string2
	"word pascal SysNotify(SysNotifyFlags flags, const char *string1, const char *string2) in system.h"
	^GEOS call: flags with: string1 with: string2 with: #[0 3 198 1 3 3 1]!

SysRegisterScreen: driver with: root
	"void pascal SysRegisterScreen(GeodeHandle driver, WindowHandle root) in system.h"
	^GEOS call: driver with: root with: #[0 3 199 1 1 0]!

SysShutdown: type with: varargs
	"Boolean cdecl SysShutdown(SysShutdownType type, ...) in system.h"
	^GEOS call: type with: varargs with: #[128 3 200 1 3 4]!

SysSetExitFlags: bitsToSet with: bitsToClear
	"word pascal SysSetExitFlags(ExitFlags bitsToSet, ExitFlags bitsToClear) in system.h"
	^GEOS call: bitsToSet with: bitsToClear with: #[0 3 201 1 1 1]!

SysGetConfig
	"dword pascal SysGetConfig(void) in system.h"
	^GEOS call: #[0 2 48 2]!

SysGetPenMode
	"Boolean pascal SysGetPenMode(void) in system.h"
	^GEOS call: #[0 3 206 4]!

UtilHex32ToAscii: buffer with: value with: flags
	"word pascal UtilHex32ToAscii(char *buffer, dword value, UtilHexToAsciiFlags flags) in system.h"
	^GEOS call: buffer with: value with: flags with: #[0 3 204 3 2 1 1]!

UtilAsciiToHex32: string with: value
	"Boolean pascal UtilAsciiToHex32(const char *string, sdword *value) in system.h"
	^GEOS call: string with: value with: #[0 3 205 3 3 4]!

SysLockBIOS
	"void pascal SysLockBIOS(void) in system.h"
	^GEOS call: #[0 3 207 0]!

SysUnlockBIOS
	"void pascal SysUnlockBIOS(void) in system.h"
	^GEOS call: #[0 3 208 0]!

SysSendNotification: subsys with: notif with: word1 with: word2 with: word3 with: word4
	"void pascal SysSendNotification(SysSubsystemType subsys, SysNotificationType notif, word word1, word word2, word word3, word word4) in system.h"
	^GEOS call: subsys with: notif with: word1 with: word2 with: word3 with: word4 with: #[0 6 171 1 1 1 1 1 1 0]!

SysIgnoreNotification: subsys
	"Boolean pascal SysIgnoreNotification(SysSubsystemType subsys) in system.h"
	^GEOS call: subsys with: #[0 6 174 1 4]!

SysEnableAPO
	"void pascal SysEnableAPO(void) in system.h"
	^GEOS call: #[0 6 164 0]!

SysDisableAPO
	"void pascal SysDisableAPO(void) in system.h"
	^GEOS call: #[0 6 165 0]!

SysGetInkWidthAndHeight
	"word pascal SysGetInkWidthAndHeight(void) in system.h"
	^GEOS call: #[0 6 161 1]!

SysSetInkWidthAndHeight: WidthAndHeight
	"void pascal SysSetInkWidthAndHeight(word WidthAndHeight) in system.h"
	^GEOS call: WidthAndHeight with: #[0 6 162 1 0]!

ChunkArrayCreateAt: arr with: elementSize with: headerSize with: ocf
	"ChunkHandle pascal ChunkArrayCreateAt(optr arr, word elementSize, word headerSize, ObjChunkFlags ocf) in chunkarr.h"
	^GEOS call: arr with: elementSize with: headerSize with: ocf with: #[0 6 140 2 1 1 1 1]!

ChunkArrayElementToPtr: arr with: elementNumber with: elementSize
	"void * pascal ChunkArrayElementToPtr(optr arr, word elementNumber, word *elementSize) in chunkarr.h"
	^GEOS call: arr with: elementNumber with: elementSize with: #[0 4 196 2 1 3 3]!

ChunkArrayPtrToElement: arr with: element
	"word pascal ChunkArrayPtrToElement(optr arr, void *element) in chunkarr.h"
	^GEOS call: arr with: element with: #[0 4 197 2 3 1]!

ChunkArrayGetElement: arr with: elementNumber with: buffer
	"void pascal ChunkArrayGetElement(optr arr, word elementNumber, void *buffer) in chunkarr.h"
	^GEOS call: arr with: elementNumber with: buffer with: #[0 4 209 2 1 3 0]!

ChunkArrayAppend: arr with: elementSize
	"void * pascal ChunkArrayAppend(optr arr, word elementSize) in chunkarr.h"
	^GEOS call: arr with: elementSize with: #[0 4 198 2 1 3]!

ChunkArrayInsertAt: arr with: insertPointer with: elementSize
	"void * pascal ChunkArrayInsertAt(optr arr, void *insertPointer, word elementSize) in chunkarr.h"
	^GEOS call: arr with: insertPointer with: elementSize with: #[0 6 116 2 3 1 3]!

ChunkArrayDelete: arr with: element
	"void pascal ChunkArrayDelete(optr arr, void *element) in chunkarr.h"
	^GEOS call: arr with: element with: #[0 4 200 2 3 0]!

ChunkArrayDeleteRange: arr with: firstElement with: count
	"void pascal ChunkArrayDeleteRange(optr arr, word firstElement, word count) in chunkarr.h"
	^GEOS call: arr with: firstElement with: count with: #[0 4 219 2 1 1 0]!

ChunkArrayGetCount: arr
	"word pascal ChunkArrayGetCount(optr arr) in chunkarr.h"
	^GEOS call: arr with: #[0 4 201 2 1]!

ChunkArrayElementResize: arr with: element with: newSize
	"void pascal ChunkArrayElementResize(optr arr, word element, word newSize) in chunkarr.h"
	^GEOS call: arr with: element with: newSize with: #[0 4 206 2 1 1 0]!

ChunkArrayZero: arr
	"void pascal ChunkArrayZero(optr arr) in chunkarr.h"
	^GEOS call: arr with: #[0 4 203 2 0]!

ArrayQuickSort: array with: count with: elementSize with: valueForCallback with: parameters
	"void pascal ArrayQuickSort(void *array, word count, word elementSize, word valueForCallback, QuickSortParameters *parameters) in chunkarr.h"
	^GEOS call: array with: count with: elementSize with: valueForCallback with: parameters with: #[0 4 205 3 1 1 1 3 0]!

ElementArrayCreateAt: arr with: elementSize with: headerSize with: ocf
	"ChunkHandle pascal ElementArrayCreateAt(optr arr, word elementSize, word headerSize, ObjChunkFlags ocf) in chunkarr.h"
	^GEOS call: arr with: elementSize with: headerSize with: ocf with: #[0 6 141 2 1 1 1 1]!

ElementArrayAddReference: arr with: token
	"void pascal ElementArrayAddReference(optr arr, word token) in chunkarr.h"
	^GEOS call: arr with: token with: #[0 4 210 2 1 0]!

ElementArrayDelete: arr with: token
	"void pascal ElementArrayDelete(optr arr, word token) in chunkarr.h"
	^GEOS call: arr with: token with: #[0 4 217 2 1 0]!

NameArrayCreateAt: arr with: dataSize with: headerSize with: ocf
	"ChunkHandle pascal NameArrayCreateAt(optr arr, word dataSize, word headerSize, ObjChunkFlags ocf) in chunkarr.h"
	^GEOS call: arr with: dataSize with: headerSize with: ocf with: #[0 6 142 2 1 1 1 1]!

NameArrayAdd: arr with: nameToAdd with: nameLength with: flags with: data
	"word pascal NameArrayAdd(optr arr, const TCHAR *nameToAdd, word nameLength, NameArrayAddFlags flags, const void *data) in chunkarr.h"
	^GEOS call: arr with: nameToAdd with: nameLength with: flags with: data with: #[0 6 3 2 3 1 1 3 1]!

NameArrayFind: arr with: nameToAdd with: nameLength with: returnData
	"word pascal NameArrayFind(optr arr, const TCHAR *nameToAdd, word nameLength, void *returnData) in chunkarr.h"
	^GEOS call: arr with: nameToAdd with: nameLength with: returnData with: #[0 6 5 2 3 1 3 1]!

NameArrayChangeName: arr with: nameToken with: newName with: nameLength
	"void pascal NameArrayChangeName(optr arr, word nameToken, const TCHAR *newName, word nameLength) in chunkarr.h"
	^GEOS call: arr with: nameToken with: newName with: nameLength with: #[0 6 7 2 1 3 1 0]!

ObjInitDetach: msg with: obj with: callerID with: ackOD
	"void pascal ObjInitDetach(MetaMessages msg, optr obj, word callerID, optr ackOD) in objects/metac.goh"
	^GEOS call: msg with: obj with: callerID with: ackOD with: #[0 4 160 1 2 1 2 0]!

ObjIncDetach: obj
	"void pascal ObjIncDetach(optr obj) in objects/metac.goh"
	^GEOS call: obj with: #[0 4 161 2 0]!

ObjEnableDetach: obj
	"void pascal ObjEnableDetach(optr obj) in objects/metac.goh"
	^GEOS call: obj with: #[0 4 162 2 0]!

ObjLinkFindParent: obj with: masterOffset with: linkOffset
	"optr pascal ObjLinkFindParent(optr obj, word masterOffset, word linkOffset) in objects/metac.goh"
	^GEOS call: obj with: masterOffset with: linkOffset with: #[0 4 163 2 1 1 2]!

ObjCompFindChildByOptr: obj with: childToFind with: masterOffset with: compOffset with: linkOffset
	"word pascal ObjCompFindChildByOptr(optr obj, optr childToFind, word masterOffset, word compOffset, word linkOffset) in objects/metac.goh"
	^GEOS call: obj with: childToFind with: masterOffset with: compOffset with: linkOffset with: #[0 4 164 2 2 1 1 1 1]!

ObjCompFindChildByNumber: obj with: childToFind with: masterOffset with: compOffset with: linkOffset
	"optr pascal ObjCompFindChildByNumber(optr obj, word childToFind, word masterOffset, word compOffset, word linkOffset) in objects/metac.goh"
	^GEOS call: obj with: childToFind with: masterOffset with: compOffset with: linkOffset with: #[0 4 165 2 1 1 1 1 2]!

ObjCompAddChild: obj with: objToAdd with: flags with: masterOffset with: compOffset with: linkOffset
	"void pascal ObjCompAddChild(optr obj, optr objToAdd, word flags, word masterOffset, word compOffset, word linkOffset) in objects/metac.goh"
	^GEOS call: obj with: objToAdd with: flags with: masterOffset with: compOffset with: linkOffset with: #[0 4 166 2 2 1 1 1 1 0]!

ObjCompRemoveChild: obj with: objToRemove with: flags with: masterOffset with: compOffset with: linkOffset
	"void pascal ObjCompRemoveChild(optr obj, optr objToRemove, word flags, word masterOffset, word compOffset, word linkOffset) in objects/metac.goh"
	^GEOS call: obj with: objToRemove with: flags with: masterOffset with: compOffset with: linkOffset with: #[0 4 167 2 2 1 1 1 1 0]!

ObjCompMoveChild: obj with: objToMove with: flags with: masterOffset with: compOffset with: linkOffset
	"void pascal ObjCompMoveChild(optr obj, optr objToMove, word flags, word masterOffset, word compOffset, word linkOffset) in objects/metac.goh"
	^GEOS call: obj with: objToMove with: flags with: masterOffset with: compOffset with: linkOffset with: #[0 4 168 2 2 1 1 1 1 0]!

DriveGetStatus: driveNumber
	"word pascal DriveGetStatus(word driveNumber) in drive.h"
	^GEOS call: driveNumber with: #[0 3 211 1 1]!

DriveGetExtStatus: driveNumber
	"word pascal DriveGetExtStatus(word driveNumber) in drive.h"
	^GEOS call: driveNumber with: #[0 3 214 1 1]!

DriveGetDefaultMedia: driveNumber
	"MediaType pascal DriveGetDefaultMedia(word driveNumber) in drive.h"
	^GEOS call: driveNumber with: #[0 3 212 1 1]!

DriveTestMediaSupport: driveNumber with: media
	"Boolean pascal DriveTestMediaSupport(word driveNumber, MediaType media) in drive.h"
	^GEOS call: driveNumber with: media with: #[0 3 213 1 1 4]!

DriveGetName: driveNumber with: buffer with: bufferSize
	"char * pascal DriveGetName(word driveNumber, char *buffer, word bufferSize) in drive.h"
	^GEOS call: driveNumber with: buffer with: bufferSize with: #[0 3 215 1 3 1 3]!

DiskGetVolumeInfo: dh with: info
	"word pascal DiskGetVolumeInfo(DiskHandle dh, DiskInfoStruct *info) in disk.h"
	^GEOS call: dh with: info with: #[0 3 216 1 3 1]!

DiskSetVolumeName: dh with: name
	"word pascal DiskSetVolumeName(DiskHandle dh, const char *name) in disk.h"
	^GEOS call: dh with: name with: #[0 3 217 1 3 1]!

DiskGetVolumeFreeSpace: dh
	"dword pascal DiskGetVolumeFreeSpace(DiskHandle dh) in disk.h"
	^GEOS call: dh with: #[0 3 218 1 2]!

DiskRegisterDisk: driveNumber
	"DiskHandle pascal DiskRegisterDisk(word driveNumber) in disk.h"
	^GEOS call: driveNumber with: #[0 3 221 1 1]!

DiskRegisterDiskSilently: driveNumber
	"DiskHandle pascal DiskRegisterDiskSilently(word driveNumber) in disk.h"
	^GEOS call: driveNumber with: #[0 3 222 1 1]!

DiskGetDrive: disk
	"word pascal DiskGetDrive(DiskHandle disk) in disk.h"
	^GEOS call: disk with: #[0 3 224 1 1]!

DiskGetVolumeName: disk with: buffer
	"void pascal DiskGetVolumeName(DiskHandle disk, char *buffer) in disk.h"
	^GEOS call: disk with: buffer with: #[0 3 225 1 3 0]!

DiskFind: fname with: code
	"DiskHandle pascal DiskFind(const char *fname, DiskFindResult *code) in disk.h"
	^GEOS call: fname with: code with: #[0 3 226 3 3 1]!

DiskCheckWritable: disk
	"Boolean pascal DiskCheckWritable(DiskHandle disk) in disk.h"
	^GEOS call: disk with: #[0 3 227 1 4]!

DiskCheckInUse: disk
	"Boolean pascal DiskCheckInUse(DiskHandle disk) in disk.h"
	^GEOS call: disk with: #[0 3 228 1 4]!

DiskCheckUnnamed: disk
	"Boolean pascal DiskCheckUnnamed(DiskHandle disk) in disk.h"
	^GEOS call: disk with: #[0 3 229 1 4]!

DiskSave: disk with: buffer with: bufSizePtr
	"Boolean pascal DiskSave(DiskHandle disk, void *buffer, word *bufSizePtr) in disk.h"
	^GEOS call: disk with: buffer with: bufSizePtr with: #[0 3 230 1 3 3 4]!

WinGetWinScreenBounds: win with: bounds
	"void pascal WinGetWinScreenBounds(WindowHandle win, Rectangle *bounds) in win.h"
	^GEOS call: win with: bounds with: #[0 5 219 1 3 0]!

WinOpen: parentWinOrVidDr with: inputRecipient with: exposureRecipient with: colorFlags with: redOrIndex with: green with: blue with: flags with: layerID with: owner with: winReg with: axParam with: bxParam with: cxParam with: dxParam
	"WindowHandle pascal WinOpen(Handle parentWinOrVidDr, optr inputRecipient, optr exposureRecipient, word colorFlags, word redOrIndex, word green, word blue, word flags, word layerID, GeodeHandle owner, const Region *winReg, word axParam, word bxParam, word cxParam, word dxParam) in win.h"
	^GEOS call: parentWinOrVidDr with: inputRecipient with: exposureRecipient with: colorFlags with: redOrIndex with: green with: blue with: flags with: layerID with: owner with: winReg with: axParam with: bxParam with: cxParam with: dxParam with: #[0 5 196 1 2 2 1 1 1 1 1 1 1 3 1 1 1 1 1]!

WinClose: win
	"void pascal WinClose(WindowHandle win) in win.h"
	^GEOS call: win with: #[0 5 197 1 0]!

WinMove: win with: xMove with: yMove with: flags
	"void pascal WinMove(WindowHandle win, sword xMove, sword yMove, WinPassFlags flags) in win.h"
	^GEOS call: win with: xMove with: yMove with: flags with: #[0 5 198 1 4 4 1 0]!

WinResize: win with: reg with: axParam with: bxParam with: cxParam with: dxParam with: flags
	"void pascal WinResize(WindowHandle win, const Region *reg, word axParam, word bxParam, word cxParam, word dxParam, WinPassFlags flags) in win.h"
	^GEOS call: win with: reg with: axParam with: bxParam with: cxParam with: dxParam with: flags with: #[0 5 199 1 3 1 1 1 1 1 0]!

WinChangePriority: win with: flags with: layerID
	"void pascal WinChangePriority(WindowHandle win, WinPassFlags flags, word layerID) in win.h"
	^GEOS call: win with: flags with: layerID with: #[0 5 201 1 1 1 0]!

WinScroll: win with: xMove with: yMove with: scrollAmt
	"void pascal WinScroll(WindowHandle win, WWFixedAsDWord xMove, WWFixedAsDWord yMove, PointWWFixed *scrollAmt) in win.h"
	^GEOS call: win with: xMove with: yMove with: scrollAmt with: #[0 5 202 1 2 2 3 0]!

GrBeginUpdate: gstate
	"void pascal GrBeginUpdate(GStateHandle gstate) in win.h"
	^GEOS call: gstate with: #[0 5 169 1 0]!

GrEndUpdate: gstate
	"void pascal GrEndUpdate(GStateHandle gstate) in win.h"
	^GEOS call: gstate with: #[0 5 170 1 0]!

WinAckUpdate: win
	"void pascal WinAckUpdate(WindowHandle win) in win.h"
	^GEOS call: win with: #[0 5 220 1 0]!

WinDecRefCount: win
	"void pascal WinDecRefCount(WindowHandle win) in win.h"
	^GEOS call: win with: #[0 5 200 1 0]!

WinInvalReg: win with: reg with: axParam with: bxParam with: cxParam with: dxParam
	"void pascal WinInvalReg(WindowHandle win, const Region *reg, word axParam, word bxParam, word cxParam, word dxParam) in win.h"
	^GEOS call: win with: reg with: axParam with: bxParam with: cxParam with: dxParam with: #[0 5 221 1 3 1 1 1 1 0]!

WinSuspendUpdate: win
	"void pascal WinSuspendUpdate(WindowHandle win) in win.h"
	^GEOS call: win with: #[0 5 203 1 0]!

WinUnSuspendUpdate: win
	"void pascal WinUnSuspendUpdate(WindowHandle win) in win.h"
	^GEOS call: win with: #[0 5 204 1 0]!

WinGetInfo: win with: type with: data
	"void pascal WinGetInfo(WindowHandle win, WinInfoType type, void *data) in win.h"
	^GEOS call: win with: type with: data with: #[0 5 205 1 1 3 0]!

WinSetInfo: win with: type with: data
	"void pascal WinSetInfo(WindowHandle win, WinInfoType type, dword data) in win.h"
	^GEOS call: win with: type with: data with: #[0 5 206 1 1 2 0]!

WinApplyRotation: win with: angle with: flag
	"void pascal WinApplyRotation(WindowHandle win, WWFixedAsDWord angle, WinInvalFlag flag) in win.h"
	^GEOS call: win with: angle with: flag with: #[0 5 207 1 2 1 0]!

WinApplyScale: win with: xScale with: yScale with: flag
	"void pascal WinApplyScale(WindowHandle win, WWFixedAsDWord xScale, WWFixedAsDWord yScale, WinInvalFlag flag) in win.h"
	^GEOS call: win with: xScale with: yScale with: flag with: #[0 5 208 1 2 2 1 0]!

WinApplyTranslation: win with: xTrans with: yTrans with: flag
	"void pascal WinApplyTranslation(WindowHandle win, WWFixedAsDWord xTrans, WWFixedAsDWord yTrans, WinInvalFlag flag) in win.h"
	^GEOS call: win with: xTrans with: yTrans with: flag with: #[0 5 209 1 2 2 1 0]!

WinApplyTranslationDWord: win with: xTrans with: yTrans with: flag
	"void pascal WinApplyTranslationDWord(WindowHandle win, sdword xTrans, sdword yTrans, WinInvalFlag flag) in win.h"
	^GEOS call: win with: xTrans with: yTrans with: flag with: #[0 5 210 1 2 2 1 0]!

WinTransform: win with: x with: y
	"XYValueAsDWord pascal WinTransform(WindowHandle win, sword x, sword y) in win.h"
	^GEOS call: win with: x with: y with: #[0 5 211 1 4 4 2]!

WinUntransform: win with: x with: y
	"XYValueAsDWord pascal WinUntransform(WindowHandle win, sword x, sword y) in win.h"
	^GEOS call: win with: x with: y with: #[0 5 213 1 4 4 2]!

WinTransformDWord: win with: xCoord with: yCoord with: screenCoordinates
	"void pascal WinTransformDWord(WindowHandle win, sdword xCoord, sdword yCoord, PointDWord *screenCoordinates) in win.h"
	^GEOS call: win with: xCoord with: yCoord with: screenCoordinates with: #[0 5 212 1 2 2 3 0]!

WinUntransformDWord: win with: xCoord with: yCoord with: documentCoordinates
	"void pascal WinUntransformDWord(WindowHandle win, sdword xCoord, sdword yCoord, PointDWord *documentCoordinates) in win.h"
	^GEOS call: win with: xCoord with: yCoord with: documentCoordinates with: #[0 5 214 1 2 2 3 0]!

WinSetTransform: win with: tm with: flag
	"void pascal WinSetTransform(WindowHandle win, const TransMatrix *tm, WinInvalFlag flag) in win.h"
	^GEOS call: win with: tm with: flag with: #[0 5 215 1 3 1 0]!

WinApplyTransform: win with: tm with: flag
	"void pascal WinApplyTransform(WindowHandle win, const TransMatrix *tm, WinInvalFlag flag) in win.h"
	^GEOS call: win with: tm with: flag with: #[0 5 216 1 3 1 0]!

WinSetNullTransform: win with: flag
	"void pascal WinSetNullTransform(WindowHandle win, WinInvalFlag flag) in win.h"
	^GEOS call: win with: flag with: #[0 5 217 1 1 0]!

WinGetTransform: win with: tm
	"void pascal WinGetTransform(WindowHandle win, TransMatrix *tm) in win.h"
	^GEOS call: win with: tm with: #[0 5 218 1 3 0]!

WinGrabChange: win with: newObj
	"Boolean pascal WinGrabChange(WindowHandle win, optr newObj) in win.h"
	^GEOS call: win with: newObj with: #[0 2 143 1 2 4]!

WinReleaseChange: win with: obj
	"void pascal WinReleaseChange(WindowHandle win, optr obj) in win.h"
	^GEOS call: win with: obj with: #[0 2 144 1 2 0]!

WinChangeAck: win with: x with: y with: winOD
	"WindowHandle pascal WinChangeAck(WindowHandle win, sword x, sword y, optr *winOD) in win.h"
	^GEOS call: win with: x with: y with: winOD with: #[0 2 145 1 4 4 3 1]!

WinEnsureChangeNotification
	"void pascal WinEnsureChangeNotification(void) in win.h"
	^GEOS call: #[0 2 153 0]!

WinSetPtrImage: win with: ptrLevel with: ptrCh
	"void pascal WinSetPtrImage(WindowHandle win, PtrImageLevel ptrLevel, optr ptrCh) in win.h"
	^GEOS call: win with: ptrLevel with: ptrCh with: #[0 5 222 1 1 2 0]!

WinGeodeSetPtrImage: gh with: ptrCh
	"void pascal WinGeodeSetPtrImage(GeodeHandle gh, optr ptrCh) in win.h"
	^GEOS call: gh with: ptrCh with: #[0 5 223 1 2 0]!

WinGeodeGetInputObj: gh
	"optr pascal WinGeodeGetInputObj(GeodeHandle gh) in win.h"
	^GEOS call: gh with: #[0 5 224 1 2]!

WinGeodeSetInputObj: gh with: iobj
	"void pascal WinGeodeSetInputObj(GeodeHandle gh, optr iobj) in win.h"
	^GEOS call: gh with: iobj with: #[0 5 225 1 2 0]!

WinGeodeGetParentObj: gh
	"optr pascal WinGeodeGetParentObj(GeodeHandle gh) in win.h"
	^GEOS call: gh with: #[0 5 226 1 2]!

WinGeodeSetParentObj: gh with: pObj
	"void pascal WinGeodeSetParentObj(GeodeHandle gh, optr pObj) in win.h"
	^GEOS call: gh with: pObj with: #[0 5 227 1 2 0]!

WinGeodeSetActiveWin: gh with: win
	"void pascal WinGeodeSetActiveWin(GeodeHandle gh, WindowHandle win) in win.h"
	^GEOS call: gh with: win with: #[0 5 228 1 1 0]!

WinRealizePalette: win
	"void pascal WinRealizePalette(WindowHandle win) in win.h"
	^GEOS call: win with: #[0 6 84 1 0]!

GCNListAdd: OD with: manufID with: listType
	"Boolean pascal GCNListAdd(optr OD, ManufacturerID manufID, word listType) in gcnlist.goh"
	^GEOS call: OD with: manufID with: listType with: #[0 5 229 2 1 1 4]!

GCNListRemove: OD with: manufID with: listType
	"Boolean pascal GCNListRemove(optr OD, ManufacturerID manufID, word listType) in gcnlist.goh"
	^GEOS call: OD with: manufID with: listType with: #[0 5 230 2 1 1 4]!

GCNListSend: manufID with: listType with: event with: dataBlock with: gcnListSendFlags
	"word pascal GCNListSend(ManufacturerID manufID, word listType, EventHandle event, MemHandle dataBlock, GCNListSendFlags gcnListSendFlags) in gcnlist.goh"
	^GEOS call: manufID with: listType with: event with: dataBlock with: gcnListSendFlags with: #[0 5 231 1 1 1 1 1 1]!

GCNListCreateBlock: mh
	"ChunkHandle pascal GCNListCreateBlock(MemHandle mh) in gcnlist.goh"
	^GEOS call: mh with: #[0 5 235 1 1]!

GCNListAddToBlock: OD with: manufID with: listType with: mh with: listOfLists
	"Boolean pascal GCNListAddToBlock(optr OD, ManufacturerID manufID, word listType, MemHandle mh, ChunkHandle listOfLists) in gcnlist.goh"
	^GEOS call: OD with: manufID with: listType with: mh with: listOfLists with: #[0 5 232 2 1 1 1 1 4]!

GCNListRemoveFromBlock: OD with: manufID with: listType with: mh with: listOfLists
	"Boolean pascal GCNListRemoveFromBlock(optr OD, ManufacturerID manufID, word listType, MemHandle mh, ChunkHandle listOfLists) in gcnlist.goh"
	^GEOS call: OD with: manufID with: listType with: mh with: listOfLists with: #[0 5 233 2 1 1 1 1 4]!

GCNListSendToBlock: manufID with: listType with: event with: dataBlock with: mh with: listOfLists with: flags
	"word pascal GCNListSendToBlock(ManufacturerID manufID, word listType, EventHandle event, MemHandle dataBlock, MemHandle mh, ChunkHandle listOfLists, GCNListSendFlags flags) in gcnlist.goh"
	^GEOS call: manufID with: listType with: event with: dataBlock with: mh with: listOfLists with: flags with: #[0 5 234 1 1 1 1 1 1 1 1]!

GCNListFindListInBlock: manufID with: changeType with: mh with: listOfLists with: createIfNotFound
	"ChunkHandle pascal GCNListFindListInBlock(ManufacturerID manufID, word changeType, MemHandle mh, ChunkHandle listOfLists, Boolean createIfNotFound) in gcnlist.goh"
	^GEOS call: manufID with: changeType with: mh with: listOfLists with: createIfNotFound with: #[0 5 241 1 1 1 1 4 1]!

GCNListDestroyBlock: mh with: listOfLists
	"void pascal GCNListDestroyBlock(MemHandle mh, ChunkHandle listOfLists) in gcnlist.goh"
	^GEOS call: mh with: listOfLists with: #[0 5 242 1 1 0]!

GCNListRelocateBlock: mh with: listOfLists with: relocBlock
	"void pascal GCNListRelocateBlock(MemHandle mh, ChunkHandle listOfLists, MemHandle relocBlock) in gcnlist.goh"
	^GEOS call: mh with: listOfLists with: relocBlock with: #[0 5 244 1 1 1 0]!

GCNListUnRelocateBlock: mh with: listOfLists with: relocBlock
	"Boolean pascal GCNListUnRelocateBlock(MemHandle mh, ChunkHandle listOfLists, MemHandle relocBlock) in gcnlist.goh"
	^GEOS call: mh with: listOfLists with: relocBlock with: #[0 5 246 1 1 1 4]!

GCNListCreateList: mh
	"ChunkHandle pascal GCNListCreateList(MemHandle mh) in gcnlist.goh"
	^GEOS call: mh with: #[0 5 240 1 1]!

GCNListAddToList: OD with: list
	"Boolean pascal GCNListAddToList(optr OD, optr list) in gcnlist.goh"
	^GEOS call: OD with: list with: #[0 5 236 2 2 4]!

GCNListRemoveFromList: OD with: list
	"Boolean pascal GCNListRemoveFromList(optr OD, optr list) in gcnlist.goh"
	^GEOS call: OD with: list with: #[0 5 237 2 2 4]!

GCNListSendToList: list with: event with: dataBlock with: flags
	"void pascal GCNListSendToList(optr list, EventHandle event, MemHandle dataBlock, GCNListSendFlags flags) in gcnlist.goh"
	^GEOS call: list with: event with: dataBlock with: flags with: #[0 5 239 2 1 1 1 0]!

GCNListFindItemInList: OD with: list
	"Boolean pascal GCNListFindItemInList(optr OD, optr list) in gcnlist.goh"
	^GEOS call: OD with: list with: #[0 5 238 2 2 4]!

GCNListDestroyList: list
	"void pascal GCNListDestroyList(optr list) in gcnlist.goh"
	^GEOS call: list with: #[0 5 243 2 0]!

GCNListRelocateList: list with: relocBlock
	"void pascal GCNListRelocateList(optr list, MemHandle relocBlock) in gcnlist.goh"
	^GEOS call: list with: relocBlock with: #[0 5 245 2 1 0]!

GCNListUnRelocateList: list with: relocBlock
	"void pascal GCNListUnRelocateList(optr list, MemHandle relocBlock) in gcnlist.goh"
	^GEOS call: list with: relocBlock with: #[0 5 247 2 1 0]!

GeodeUseDriver: name with: protoMajor with: protoMinor with: err
	"GeodeHandle pascal GeodeUseDriver(const char *name, word protoMajor, word protoMinor, GeodeLoadError *err) in driver.h"
	^GEOS call: name with: protoMajor with: protoMinor with: err with: #[0 6 119 3 1 1 3 1]!

GeodeFreeDriver: gh
	"void pascal GeodeFreeDriver(GeodeHandle gh) in driver.h"
	^GEOS call: gh with: #[0 3 166 1 0]!

GeodeInfoDriver: gh
	"DriverInfoStruct * pascal GeodeInfoDriver(GeodeHandle gh) in driver.h"
	^GEOS call: gh with: #[0 3 167 1 3]!

GeodeGetDefaultDriver: type
	"GeodeHandle pascal GeodeGetDefaultDriver(GeodeDefaultDriverType type) in driver.h"
	^GEOS call: type with: #[0 3 168 1 1]!

GeodeSetDefaultDriver: type with: gh
	"void pascal GeodeSetDefaultDriver(GeodeDefaultDriverType type, GeodeHandle gh) in driver.h"
	^GEOS call: type with: gh with: #[0 3 169 1 1 0]!

HugeArrayCreate: vmFile with: elemSize with: headerSpace
	"VMBlockHandle pascal HugeArrayCreate(VMFileHandle vmFile, word elemSize, word headerSpace) in hugearr.h"
	^GEOS call: vmFile with: elemSize with: headerSpace with: #[0 6 157 1 1 1 1]!

HugeArrayDestroy: vmFile with: vmBlock
	"void pascal HugeArrayDestroy(VMFileHandle vmFile, VMBlockHandle vmBlock) in hugearr.h"
	^GEOS call: vmFile with: vmBlock with: #[0 6 40 1 1 0]!

HugeArrayLock: vmFile with: vmBlock with: elemNum with: elemPtr with: elemSize
	"dword pascal HugeArrayLock(VMFileHandle vmFile, VMBlockHandle vmBlock, dword elemNum, void **elemPtr, word *elemSize) in hugearr.h"
	^GEOS call: vmFile with: vmBlock with: elemNum with: elemPtr with: elemSize with: #[0 6 159 1 1 2 3 3 2]!

HugeArrayUnlock: elemPtr
	"void pascal HugeArrayUnlock(void *elemPtr) in hugearr.h"
	^GEOS call: elemPtr with: #[0 6 42 3 0]!

HugeArrayLockDir: vmFile with: vmBlock with: elemPtr
	"void pascal HugeArrayLockDir(VMFileHandle vmFile, VMBlockHandle vmBlock, void **elemPtr) in hugearr.h"
	^GEOS call: vmFile with: vmBlock with: elemPtr with: #[0 6 58 1 1 3 0]!

HugeArrayUnlockDir: elemPtr
	"void pascal HugeArrayUnlockDir(void *elemPtr) in hugearr.h"
	^GEOS call: elemPtr with: #[0 6 60 3 0]!

HugeArrayAppend: vmFile with: vmBlock with: numElem with: initData
	"dword pascal HugeArrayAppend(VMFileHandle vmFile, VMBlockHandle vmBlock, word numElem, const void *initData) in hugearr.h"
	^GEOS call: vmFile with: vmBlock with: numElem with: initData with: #[0 6 43 1 1 1 3 2]!

HugeArrayInsert: vmFile with: vmBlock with: numElem with: elemNum with: initData
	"void pascal HugeArrayInsert(VMFileHandle vmFile, VMBlockHandle vmBlock, word numElem, dword elemNum, const void *initData) in hugearr.h"
	^GEOS call: vmFile with: vmBlock with: numElem with: elemNum with: initData with: #[0 6 44 1 1 1 2 3 0]!

HugeArrayDelete: vmFile with: vmBlock with: numElem with: elemNum
	"void pascal HugeArrayDelete(VMFileHandle vmFile, VMBlockHandle vmBlock, word numElem, dword elemNum) in hugearr.h"
	^GEOS call: vmFile with: vmBlock with: numElem with: elemNum with: #[0 6 46 1 1 1 2 0]!

HugeArrayGetCount: vmFile with: vmBlock
	"dword pascal HugeArrayGetCount(VMFileHandle vmFile, VMBlockHandle vmBlock) in hugearr.h"
	^GEOS call: vmFile with: vmBlock with: #[0 6 158 1 1 2]!

HugeArrayReplace: vmFile with: vmBlock with: numElem with: elemNum with: initData
	"void pascal HugeArrayReplace(VMFileHandle vmFile, VMBlockHandle vmBlock, word numElem, dword elemNum, const void *initData) in hugearr.h"
	^GEOS call: vmFile with: vmBlock with: numElem with: elemNum with: initData with: #[0 6 45 1 1 1 2 3 0]!

HugeArrayNext: elemPtr with: size
	"word pascal HugeArrayNext(void **elemPtr, word *size) in hugearr.h"
	^GEOS call: elemPtr with: size with: #[0 6 186 3 3 1]!

HugeArrayPrev: elemPtr1 with: elemPtr2 with: size
	"word pascal HugeArrayPrev(void **elemPtr1, void **elemPtr2, word *size) in hugearr.h"
	^GEOS call: elemPtr1 with: elemPtr2 with: size with: #[0 6 50 3 3 3 1]!

HugeArrayExpand: elemPtr with: numElem with: initData
	"word pascal HugeArrayExpand(void **elemPtr, word numElem, const void *initData) in hugearr.h"
	^GEOS call: elemPtr with: numElem with: initData with: #[0 6 51 3 1 3 1]!

HugeArrayContract: elemPtr with: numElem
	"word pascal HugeArrayContract(void **elemPtr, word numElem) in hugearr.h"
	^GEOS call: elemPtr with: numElem with: #[0 6 52 3 1 1]!

HugeArrayDirty: elemPtr
	"void pascal HugeArrayDirty(const void *elemPtr) in hugearr.h"
	^GEOS call: elemPtr with: #[0 6 48 3 0]!

HugeArrayResize: vmFile with: vmBlock with: elemNum with: newSize
	"void pascal HugeArrayResize(VMFileHandle vmFile, VMBlockHandle vmBlock, dword elemNum, word newSize) in hugearr.h"
	^GEOS call: vmFile with: vmBlock with: elemNum with: newSize with: #[0 6 56 1 1 2 1 0]!

ECCheckHugeArray: vmFile with: vmBlock
	"void pascal ECCheckHugeArray(VMFileHandle vmFile, VMBlockHandle vmBlock) in hugearr.h"
	^GEOS call: vmFile with: vmBlock with: #[0 6 54 1 1 0]!

HugeArrayCompressBlocks: vmFile with: vmBlock
	"void pascal HugeArrayCompressBlocks(VMFileHandle vmFile,VMBlockHandle vmBlock) in hugearr.h"
	^GEOS call: vmFile with: vmBlock with: #[0 6 94 1 1 0]!

FileEnum: params with: bufCreated with: numNoFit
	"word pascal FileEnum(FileEnumParams *params, MemHandle *bufCreated, word *numNoFit) in fileenum.h"
	^GEOS call: params with: bufCreated with: numNoFit with: #[0 6 129 3 3 3 1]!

FileEnumLocateAttr: fecd with: attr with: name
	"void * pascal FileEnumLocateAttr(FileEnumCallbackData *fecd, FileExtendedAttribute attr, const char *name) in fileenum.h"
	^GEOS call: fecd with: attr with: name with: #[0 3 133 3 1 3 3]!

FileEnumWildcard: fecd with: frame
	"Boolean pascal FileEnumWildcard(FileEnumCallbackData *fecd, word frame) in fileenum.h"
	^GEOS call: fecd with: frame with: #[0 3 134 3 1 4]!

GeodeUseLibrary: name with: protoMajor with: protoMinor with: err
	"GeodeHandle pascal GeodeUseLibrary(const char *name, word protoMajor, word protoMinor, GeodeLoadError *err) in library.h"
	^GEOS call: name with: protoMajor with: protoMinor with: err with: #[0 6 135 3 1 1 3 1]!

GeodeFreeLibrary: gh
	"void pascal GeodeFreeLibrary(GeodeHandle gh) in library.h"
	^GEOS call: gh with: #[0 3 171 1 0]!

InitFileWriteData: category with: key with: buffer with: bufSize
	"void pascal InitFileWriteData(const char *category, const char *key, const void *buffer, word bufSize) in initfile.h"
	^GEOS call: category with: key with: buffer with: bufSize with: #[0 3 232 3 3 3 1 0]!

InitFileWriteString: category with: key with: str
	"void pascal InitFileWriteString(const char *category, const char *key, const char *str) in initfile.h"
	^GEOS call: category with: key with: str with: #[0 3 233 3 3 3 0]!

InitFileWriteInteger: category with: key with: value
	"void pascal InitFileWriteInteger(const char *category, const char *key, word value) in initfile.h"
	^GEOS call: category with: key with: value with: #[0 3 234 3 3 1 0]!

InitFileWriteBoolean: category with: key with: bool
	"void pascal InitFileWriteBoolean(const char *category, const char *key, Boolean bool) in initfile.h"
	^GEOS call: category with: key with: bool with: #[0 3 235 3 3 4 0]!

InitFileWriteStringSection: category with: key with: string
	"void pascal InitFileWriteStringSection(const char *category, const char *key, const char *string) in initfile.h"
	^GEOS call: category with: key with: string with: #[0 3 249 3 3 3 0]!

InitFileReadDataBuffer: category with: key with: buffer with: bufSize with: dataSize
	"Boolean pascal InitFileReadDataBuffer(const char *category, const char *key, void *buffer, word bufSize, word *dataSize) in initfile.h"
	^GEOS call: category with: key with: buffer with: bufSize with: dataSize with: #[0 3 236 3 3 3 1 3 4]!

InitFileReadDataBlock: category with: key with: block with: dataSize
	"Boolean pascal InitFileReadDataBlock(const char *category, const char *key, MemHandle *block, word *dataSize) in initfile.h"
	^GEOS call: category with: key with: block with: dataSize with: #[0 3 237 3 3 3 3 4]!

InitFileReadStringBuffer: category with: key with: buffer with: flags with: dataSize
	"Boolean pascal InitFileReadStringBuffer(const char *category, const char *key, char *buffer, InitFileReadFlags flags, word *dataSize) in initfile.h"
	^GEOS call: category with: key with: buffer with: flags with: dataSize with: #[0 3 238 3 3 3 1 3 4]!

InitFileReadStringBlock: category with: key with: block with: flags with: dataSize
	"Boolean pascal InitFileReadStringBlock(const char *category, const char *key, MemHandle *block, InitFileReadFlags flags, word *dataSize) in initfile.h"
	^GEOS call: category with: key with: block with: flags with: dataSize with: #[0 3 239 3 3 3 1 3 4]!

InitFileReadStringSectionBuffer: category with: key with: section with: buffer with: flags with: dataSize
	"Boolean pascal InitFileReadStringSectionBuffer(const char *category, const char *key, word section, char *buffer, InitFileReadFlags flags, word *dataSize) in initfile.h"
	^GEOS call: category with: key with: section with: buffer with: flags with: dataSize with: #[0 3 240 3 3 1 3 1 3 4]!

InitFileReadStringSectionBlock: category with: key with: section with: block with: flags with: dataSize
	"Boolean pascal InitFileReadStringSectionBlock(const char *category, const char *key, word section, MemHandle *block, InitFileReadFlags flags, word *dataSize) in initfile.h"
	^GEOS call: category with: key with: section with: block with: flags with: dataSize with: #[0 3 241 3 3 1 3 1 3 4]!

InitFileReadInteger: category with: key with: i
	"Boolean pascal InitFileReadInteger(const char *category, const char *key, word *i) in initfile.h"
	^GEOS call: category with: key with: i with: #[0 3 242 3 3 3 4]!

InitFileReadBoolean: category with: key with: bool
	"Boolean pascal InitFileReadBoolean(const char *category, const char *key, Boolean *bool) in initfile.h"
	^GEOS call: category with: key with: bool with: #[0 3 243 3 3 3 4]!

InitFileGetTimeLastModified
	"dword pascal InitFileGetTimeLastModified(void) in initfile.h"
	^GEOS call: #[0 3 244 2]!

InitFileSave
	"Boolean pascal InitFileSave(void) in initfile.h"
	^GEOS call: #[0 3 245 4]!

InitFileRevert
	"Boolean pascal InitFileRevert(void) in initfile.h"
	^GEOS call: #[0 3 246 4]!

InitFileCommit
	"void pascal InitFileCommit(void) in initfile.h"
	^GEOS call: #[0 2 254 0]!

InitFileDeleteStringSection: category with: key with: stringNum
	"void pascal InitFileDeleteStringSection(const char *category, const char *key, word stringNum) in initfile.h"
	^GEOS call: category with: key with: stringNum with: #[0 3 250 3 3 1 0]!

InitFileDeleteEntry: category with: key
	"void pascal InitFileDeleteEntry(const char *category, const char *key) in initfile.h"
	^GEOS call: category with: key with: #[0 3 247 3 3 0]!

InitFileDeleteCategory: category
	"void pascal InitFileDeleteCategory(const char *category) in initfile.h"
	^GEOS call: category with: #[0 3 248 3 0]!

InitFileGrab: mem with: fh with: size
	"word pascal InitFileGrab(MemHandle mem, FileHandle fh, word size) in initfile.h"
	^GEOS call: mem with: fh with: size with: #[0 6 123 1 1 1 1]!

InitFileRelease
	"void pascal InitFileRelease(void) in initfile.h"
	^GEOS call: #[0 6 124 0]!

InitFileMakeCanonicKeyCategory: keyCat with: src
	"void pascal InitFileMakeCanonicKeyCategory(char *keyCat, const TCHAR *src) in initfile.h"
	^GEOS call: keyCat with: src with: #[0 6 236 3 3 0]!

ThreadAllocSem: value
	"SemaphoreHandle pascal ThreadAllocSem(word value) in sem.h"
	^GEOS call: value with: #[0 3 172 1 1]!

ThreadFreeSem: sem
	"void pascal ThreadFreeSem(SemaphoreHandle sem) in sem.h"
	^GEOS call: sem with: #[0 3 173 1 0]!

ThreadPSem: sem
	"SemaphoreError pascal ThreadPSem(SemaphoreHandle sem) in sem.h"
	^GEOS call: sem with: #[0 3 174 1 1]!

ThreadVSem: sem
	"void pascal ThreadVSem(SemaphoreHandle sem) in sem.h"
	^GEOS call: sem with: #[0 3 175 1 0]!

ThreadPTimedSem: sem with: timeout
	"SemaphoreError pascal ThreadPTimedSem(SemaphoreHandle sem, word timeout) in sem.h"
	^GEOS call: sem with: timeout with: #[0 3 176 1 1 1]!

ThreadAllocThreadLock
	"ThreadLockHandle pascal ThreadAllocThreadLock(void) in sem.h"
	^GEOS call: #[0 3 177 1]!

ThreadFreeThreadLock: sem
	"void pascal ThreadFreeThreadLock(ThreadLockHandle sem) in sem.h"
	^GEOS call: sem with: #[0 3 178 1 0]!

ThreadGrabThreadLock: sem
	"void pascal ThreadGrabThreadLock(ThreadLockHandle sem) in sem.h"
	^GEOS call: sem with: #[0 3 179 1 0]!

ThreadReleaseThreadLock: sem
	"void pascal ThreadReleaseThreadLock(ThreadLockHandle sem) in sem.h"
	^GEOS call: sem with: #[0 3 180 1 0]!

SysStatistics: stats
	"void pascal SysStatistics(SysStats *stats) in sysstats.h"
	^GEOS call: stats with: #[0 3 209 3 0]!

SysGetInfo: info
	"dword pascal SysGetInfo(SysGetInfoType info) in sysstats.h"
	^GEOS call: info with: #[0 3 210 1 2]!

!

GeosMetaObject subclass: #Meta
	instanceVariableNames: ''
	classVariableNames: ''!

Meta subclass: #Process
	instanceVariableNames: ''
	classVariableNames: ''!

!Meta comment!
Library geos, file objects/metac.goh! !

!Meta class methodsFor: 'library linkage'!

library
	^0!

entry
	^710!
!

!Meta methodsFor: 'Geos instance variables'!

miBase
	"@instance MetaBase MI_base"
	^GCSMetaBase forPointer: (self ptrAt: 0).!

miBase: aBlock
	"@instance MetaBase MI_base"
	aBlock value: (GCSMetaBase forPointer: (self ptrAt: 0)).!

!

!Meta methodsFor: 'Geos vardata'!

tempMetaGcn
	"@vardata TempMetaGCNData TEMP_META_GCN"
	^self addVardata: ##tempMetaGcn size: 3!

tempMetaGcn: aBlock
	"@vardata TempMetaGCNData TEMP_META_GCN"
	aBlock value: (GCSTempMetaGCNData forPointer: (self addVardata: ##tempMetaGcn size: 3)).!

tempMetaQuitList: value
	"@vardata ChunkHandle TEMP_META_QUIT_LIST"
	^self addVardata: ##tempMetaQuitList word: value!

detachData
	"@vardata DetachDataEntry DETACH_DATA"
	^self addVardata: ##detachData size: 10!

detachData: aBlock
	"@vardata DetachDataEntry DETACH_DATA"
	aBlock value: (GCSDetachDataEntry forPointer: (self addVardata: ##detachData size: 10)).!

tempEcInUseCount: value
	"@vardata word TEMP_EC_IN_USE_COUNT"
	^self addVardata: ##tempEcInUseCount word: value!

tempEcInteractibleCount: value
	"@vardata word TEMP_EC_INTERACTIBLE_COUNT"
	^self addVardata: ##tempEcInteractibleCount word: value!

tempMetaEnsureActiveFtLayerPriorityPreference
	"@vardata EnsureActiveFTPriorityPreferenceData TEMP_META_ENSURE_ACTIVE_FT_LAYER_PRIORITY_PREFERENCE"
	^self addVardata: ##tempMetaEnsureActiveFtLayerPriorityPreference size: 6!

tempMetaEnsureActiveFtLayerPriorityPreference: aBlock
	"@vardata EnsureActiveFTPriorityPreferenceData TEMP_META_ENSURE_ACTIVE_FT_LAYER_PRIORITY_PREFERENCE"
	aBlock value: (GCSEnsureActiveFTPriorityPreferenceData forPointer: (self addVardata: ##tempMetaEnsureActiveFtLayerPriorityPreference size: 6)).!

debugMetaObjDuplicateResourceInfo
	"@vardata DebugObjDuplicateResourceInfo DEBUG_META_OBJ_DUPLICATE_RESOURCE_INFO"
	^self addVardata: ##debugMetaObjDuplicateResourceInfo size: 10!

debugMetaObjDuplicateResourceInfo: aBlock
	"@vardata DebugObjDuplicateResourceInfo DEBUG_META_OBJ_DUPLICATE_RESOURCE_INFO"
	aBlock value: (GCSDebugObjDuplicateResourceInfo forPointer: (self addVardata: ##debugMetaObjDuplicateResourceInfo size: 10)).!

!

!Meta methodsFor: 'Geos messages'!

null
	"@message void MSG_META_NULL()"
	^self geosMessage: #[0 0 2 0 0]!

initialize
	"@message void MSG_META_INITIALIZE()"
	^self geosMessage: #[0 1 2 0 0]!

reserved_1
	"@message void MSG_META_RESERVED_1()"
	^self geosMessage: #[0 2 2 0 0]!

dummy
	"@message void MSG_META_DUMMY()"
	^self geosMessage: #[0 3 2 0 0]!

appStartup: appLaunchBlock
	"@message void MSG_META_APP_STARTUP(MemHandle appLaunchBlock)"
	^self geosMessage: #[0 4 1 0 1 0] with: appLaunchBlock!

attach
	"@message void MSG_META_ATTACH()"
	^self geosMessage: #[0 5 2 0 0]!

attachProcess: value1 with: value2
	"@message void MSG_META_ATTACH_PROCESS(word value1 = cx, word value2 = dx)"
	^self geosMessage: #[0 5 2 53 1 1 0] with: value1 with: value2!

attachGenprocessclass: appLaunchBlock
	"@message void MSG_META_ATTACH_GENPROCESSCLASS(MemHandle appLaunchBlock = dx)"
	^self geosMessage: #[0 5 2 6 1 0] with: appLaunchBlock!

attachObject: flags with: appLaunchBlock with: extraState
	"@message void MSG_META_ATTACH_OBJECT(word flags = cx, MemHandle appLaunchBlock = dx, MemHandle extraState = bp)"
	^self geosMessage: #[0 5 3 245 1 1 1 0] with: flags with: appLaunchBlock with: extraState!

attachThread
	"@message void MSG_META_ATTACH_THREAD()"
	^self geosMessage: #[0 5 2 0 0]!

detach: callerID with: caller
	"@message void MSG_META_DETACH(word callerID = cx, optr caller = dx:bp)"
	^self geosMessage: #[0 6 3 245 1 2 0] with: callerID with: caller!

detachComplete
	"@message void MSG_META_DETACH_COMPLETE()"
	^self geosMessage: #[0 7 2 0 0]!

detachAbort
	"@message void MSG_META_DETACH_ABORT()"
	^self geosMessage: #[0 8 2 0 0]!

ack: callerID with: caller
	"@message void MSG_META_ACK(word callerID = cx, optr caller = dx:bp)"
	^self geosMessage: #[0 9 3 245 1 2 0] with: callerID with: caller!

appShutdown: callerID with: ackOD
	"@message void MSG_META_APP_SHUTDOWN(word callerID = cx, optr ackOD = dx:bp)"
	^self geosMessage: #[0 10 3 245 1 2 0] with: callerID with: ackOD!

shutdownComplete
	"@message void MSG_META_SHUTDOWN_COMPLETE()"
	^self geosMessage: #[0 11 2 0 0]!

shutdownAck: callerID with: ackOD
	"@message void MSG_META_SHUTDOWN_ACK(word callerID = cx, optr ackOD = dx:bp)"
	^self geosMessage: #[0 12 3 245 1 2 0] with: callerID with: ackOD!

getClass
	"@message ClassStruct*  MSG_META_GET_CLASS()= cx:dx"
	^self geosMessage: #[0 13 154 0 3]!

isObjectInClass: class
	"@message Boolean MSG_META_IS_OBJECT_IN_CLASS(ClassStruct *class = cx:dx)= carry"
	^self geosMessage: #[0 14 2 53 3 4] with: class!

blockFree
	"@message void MSG_META_BLOCK_FREE()"
	^self geosMessage: #[0 15 2 0 0]!

objFree
	"@message void MSG_META_OBJ_FREE()"
	^self geosMessage: #[0 16 2 0 0]!

finalObjFree
	"@message void MSG_META_FINAL_OBJ_FREE()"
	^self geosMessage: #[0 17 2 0 0]!

decBlockRefCount: block1 with: block2
	"@message void MSG_META_DEC_BLOCK_REF_COUNT(MemHandle block1 = cx, MemHandle block2 = dx)"
	^self geosMessage: #[0 18 2 53 1 1 0] with: block1 with: block2!

resolveVariantSuperclass: MasterOffset
	"@message ClassStruct*  MSG_META_RESOLVE_VARIANT_SUPERCLASS( word MasterOffset = cx)= cx:dx"
	^self geosMessage: #[0 19 154 5 1 3] with: MasterOffset!

relocate: vmRelocType with: frame
	"@message Boolean MSG_META_RELOCATE(word vmRelocType = dx, word frame = bp)= carry"
	^self geosMessage: #[0 20 2 62 1 1 4] with: vmRelocType with: frame!

unrelocate: vmRelocType with: frame
	"@message Boolean MSG_META_UNRELOCATE(word vmRelocType = dx, word frame = bp)= carry"
	^self geosMessage: #[0 21 2 62 1 1 4] with: vmRelocType with: frame!

leaveConstrain
	"@message void MSG_META_LEAVE_CONSTRAIN()"
	^self geosMessage: #[0 22 2 0 0]!

setFlags: objChunk with: bitsToSet with: bitsToClear
	"@message void MSG_META_SET_FLAGS(ChunkHandle objChunk = cx, ObjChunkFlags bitsToSet = dl, ObjChunkFlags bitsToClear = dh)"
	^self geosMessage: #[0 23 3 29 1 1 1 0] with: objChunk with: bitsToSet with: bitsToClear!

getFlags: ch
	"@message word MSG_META_GET_FLAGS(ChunkHandle ch = cx)= ax"
	^self geosMessage: #[0 24 98 5 1 1] with: ch!

vmFileDirty: file
	"@message void MSG_META_VM_FILE_DIRTY(FileHandle file = cx)"
	^self geosMessage: #[0 25 2 5 1 0] with: file!

quit
	"@message void MSG_META_QUIT()"
	^self geosMessage: #[0 26 2 0 0]!

quitProcess: quitLevel with: ackODChunk
	"@message void MSG_META_QUIT_PROCESS(word quitLevel = dx, ChunkHandle ackODChunk = cx)"
	^self geosMessage: #[0 26 2 46 1 1 0] with: quitLevel with: ackODChunk!

quitObject: obj
	"@message void MSG_META_QUIT_OBJECT(optr obj = cx:dx)"
	^self geosMessage: #[0 26 2 53 2 0] with: obj!

quitAck: quitLevel with: abortFlag
	"@message void MSG_META_QUIT_ACK(word quitLevel = dx, word abortFlag = cx)"
	^self geosMessage: #[0 27 2 46 1 1 0] with: quitLevel with: abortFlag!

dispatchEvent: retVals with: eventHandle with: msgFlags
	"@message Boolean MSG_META_DISPATCH_EVENT(AsmPassReturn *retVals = axcxdxbp, EventHandle eventHandle = cx, MessageFlags msgFlags = dx)= carry"
	^self geosMessage: #[0 28 198 53 3 1 1 4] with: retVals with: eventHandle with: msgFlags!

sendClassedEvent: event with: whereTo
	"@message void MSG_META_SEND_CLASSED_EVENT(EventHandle event = cx, TravelOption whereTo = dx)"
	^self geosMessage: #[0 29 2 53 1 1 0] with: event with: whereTo!

getOptr
	"@message optr MSG_META_GET_OPTR()= cx:dx"
	^self geosMessage: #[0 30 154 0 2]!

getTargetAtTargetLevel: retValue with: level
	"@message void MSG_META_GET_TARGET_AT_TARGET_LEVEL( GetTargetParams *retValue = bpaxdxcx, TargetLevel level = cx)"
	^self geosMessage: #[0 31 210 5 3 1 0] with: retValue with: level!

addVarData: dataType with: dataSize with: data
	"@message void MSG_META_ADD_VAR_DATA(@stack word dataType, word dataSize, void *data)"
	^self geosMessage: #[0 32 0 8 1 1 3 0] with: dataType with: dataSize with: data!

deleteVarData: dataType
	"@message Boolean MSG_META_DELETE_VAR_DATA(word dataType = cx)= carry"
	^self geosMessage: #[0 33 2 5 1 4] with: dataType!

initializeVarData: dataType
	"@message word MSG_META_INITIALIZE_VAR_DATA(word dataType = cx)= ax"
	^self geosMessage: #[0 34 98 5 1 1] with: dataType!

notify: manufID with: notificationType with: data
	"@message void MSG_META_NOTIFY(ManufacturerID manufID = cx, word notificationType = dx, word data = bp)"
	^self geosMessage: #[0 35 3 245 1 1 1 0] with: manufID with: notificationType with: data!

notifyWithDataBlock: manufID with: notificationType with: data
	"@message void MSG_META_NOTIFY_WITH_DATA_BLOCK(ManufacturerID manufID = cx, word notificationType = dx, MemHandle data = bp)"
	^self geosMessage: #[0 36 3 245 1 1 1 0] with: manufID with: notificationType with: data!

gcnListAdd: dest with: listType with: listManuf
	"@message Boolean MSG_META_GCN_LIST_ADD(@stack optr dest, word listType, ManufacturerID listManuf )= carry"
	^self geosMessage: #[0 37 0 8 2 1 1 4] with: dest with: listType with: listManuf!

gcnListRemove: dest with: listType with: listManuf
	"@message Boolean MSG_META_GCN_LIST_REMOVE(@stack optr dest, word listType, ManufacturerID listManuf )= carry"
	^self geosMessage: #[0 38 0 8 2 1 1 4] with: dest with: listType with: listManuf!

gcnListSend: flags with: event with: block with: listType with: listManuf
	"@message void MSG_META_GCN_LIST_SEND(@stack GCNListSendFlags flags, EventHandle event, MemHandle block, word listType, ManufacturerID listManuf)"
	^self geosMessage: #[0 39 0 10 1 1 1 1 1 0] with: flags with: event with: block with: listType with: listManuf!

gcnListDestroy
	"@message void MSG_META_GCN_LIST_DESTROY()"
	^self geosMessage: #[0 40 2 0 0]!

saveOptions
	"@message void MSG_META_SAVE_OPTIONS()"
	^self geosMessage: #[0 41 2 0 0]!

getIniCategory: buf
	"@message void MSG_META_GET_INI_CATEGORY(char *buf = cx:dx)"
	^self geosMessage: #[0 42 2 53 3 0] with: buf!

suspend
	"@message void MSG_META_SUSPEND()"
	^self geosMessage: #[0 43 2 0 0]!

unsuspend
	"@message void MSG_META_UNSUSPEND()"
	^self geosMessage: #[0 44 2 0 0]!

loadOptions
	"@message void MSG_META_LOAD_OPTIONS()"
	^self geosMessage: #[0 45 2 0 0]!

getVarData: dataType with: bufSize with: buf
	"@message word MSG_META_GET_VAR_DATA(@stack word dataType, word bufSize, void *buf)= ax"
	^self geosMessage: #[0 46 96 8 1 1 3 1] with: dataType with: bufSize with: buf!

notifyObjBlockInteractible: objBlock
	"@message void MSG_META_NOTIFY_OBJ_BLOCK_INTERACTIBLE(MemHandle objBlock = cx)"
	^self geosMessage: #[0 47 2 5 1 0] with: objBlock!

notifyObjBlockNotInteractible: objBlock
	"@message void MSG_META_NOTIFY_OBJ_BLOCK_NOT_INTERACTIBLE(MemHandle objBlock = cx)"
	^self geosMessage: #[0 48 2 5 1 0] with: objBlock!

objFlushInputQueue: event with: nextStop with: objBlock
	"@message void MSG_META_OBJ_FLUSH_INPUT_QUEUE(EventHandle event = cx, ObjFlushInputQueueNextStop nextStop = bp, MemHandle objBlock = dx)"
	^self geosMessage: #[0 49 3 189 1 1 1 0] with: event with: nextStop with: objBlock!

winDecRefCount: win
	"@message void MSG_META_WIN_DEC_REF_COUNT(MemHandle win = cx)"
	^self geosMessage: #[0 50 2 5 1 0] with: win!

updateWindow: updateFlags with: updateMode
	"@message void MSG_META_UPDATE_WINDOW(UpdateWindowFlags updateFlags = cx, VisUpdateMode updateMode = dl)"
	^self geosMessage: #[0 51 2 29 1 1 0] with: updateFlags with: updateMode!

finishQuit: abortFlag
	"@message void MSG_META_FINISH_QUIT(Boolean abortFlag = cx)"
	^self geosMessage: #[0 52 2 5 4 0] with: abortFlag!

setObjBlockOutput: output
	"@message void MSG_META_SET_OBJ_BLOCK_OUTPUT(optr output = cx:dx)"
	^self geosMessage: #[0 53 2 53 2 0] with: output!

getHelpFile: buf
	"@message Boolean MSG_META_GET_HELP_FILE(char *buf = cx:dx)= carry"
	^self geosMessage: #[0 54 2 53 3 4] with: buf!

getHelpType: retValue
	"@message Boolean MSG_META_GET_HELP_TYPE( HelpTypeReturn *retValue = dxcx)= carry"
	^self geosMessage: #[0 55 206 0 3 4] with: retValue!

getObjBlockOutput
	"@message optr MSG_META_GET_OBJ_BLOCK_OUTPUT()= cx:dx"
	^self geosMessage: #[0 56 154 0 2]!

resetOptions
	"@message void MSG_META_RESET_OPTIONS()"
	^self geosMessage: #[0 57 2 0 0]!

bringUpHelp
	"@message void MSG_META_BRING_UP_HELP()"
	^self geosMessage: #[0 58 2 0 0]!

setHelpFile: buf
	"@message void MSG_META_SET_HELP_FILE(char *buf = cx:dx)"
	^self geosMessage: #[0 59 2 53 3 0] with: buf!

gcnListFindItem: dest with: listType with: listManuf
	"@message Boolean MSG_META_GCN_LIST_FIND_ITEM(@stack optr dest, word listType, ManufacturerID listManuf )= carry"
	^self geosMessage: #[0 60 0 8 2 1 1 4] with: dest with: listType with: listManuf!

transparentDetach
	"@message void MSG_META_TRANSPARENT_DETACH()"
	^self geosMessage: #[0 61 2 0 0]!

removingDisk: disk
	"@message void MSG_META_REMOVING_DISK(DiskHandle disk = cx)"
	^self geosMessage: #[0 62 2 5 1 0] with: disk!

vmFileSetInitialDirtyLimit: fh
	"@message void MSG_META_VM_FILE_SET_INITIAL_DIRTY_LIMIT(FileHandle fh = cx)"
	^self geosMessage: #[0 63 2 5 1 0] with: fh!

vmFileAutoSave: fh
	"@message void MSG_META_VM_FILE_AUTO_SAVE(FileHandle fh = cx)"
	^self geosMessage: #[0 64 2 5 1 0] with: fh!

exposed: win
	"@message void MSG_META_EXPOSED(WindowHandle win=cx)"
	^self geosMessage: #[0 69 2 5 1 0] with: win!

exposedForPrint: gstring with: completionOD
	"@message void MSG_META_EXPOSED_FOR_PRINT( GStringHandle gstring = bp, optr completionOD=cx:dx)"
	^self geosMessage: #[0 70 3 175 1 2 0] with: gstring with: completionOD!

winUpdateComplete
	"@message void MSG_META_WIN_UPDATE_COMPLETE()"
	^self geosMessage: #[0 71 2 0 0]!

winUnused_2
	"@message void MSG_META_WIN_UNUSED_2()"
	^self geosMessage: #[0 72 2 0 0]!

winChange
	"@message void MSG_META_WIN_CHANGE()"
	^self geosMessage: #[0 73 2 0 0]!

impliedWinChange
	"@message void MSG_META_IMPLIED_WIN_CHANGE()"
	^self geosMessage: #[0 74 2 0 0]!

rawUnivEnter
	"@message void MSG_META_RAW_UNIV_ENTER()"
	^self geosMessage: #[0 75 2 0 0]!

rawUnivLeave
	"@message void MSG_META_RAW_UNIV_LEAVE()"
	^self geosMessage: #[0 76 2 0 0]!

unused_1
	"@message void MSG_META_UNUSED_1()"
	^self geosMessage: #[0 77 2 0 0]!

invalTree
	"@message void MSG_META_INVAL_TREE()"
	^self geosMessage: #[0 78 2 0 0]!

invalBounds
	"@message void MSG_META_INVAL_BOUNDS()"
	^self geosMessage: #[0 79 2 0 0]!

mouseButton: xPosition with: yPosition with: inputState
	"@message void MSG_META_MOUSE_BUTTON( word xPosition = cx, word yPosition = dx, word inputState = bp)"
	^self geosMessage: #[0 117 3 245 1 1 1 0] with: xPosition with: yPosition with: inputState!

mousePtr: xPosition with: yPosition with: inputState
	"@message void MSG_META_MOUSE_PTR( word xPosition = cx, word yPosition = dx, word inputState = bp)"
	^self geosMessage: #[0 118 3 245 1 1 1 0] with: xPosition with: yPosition with: inputState!

kbdChar: character with: flags with: state
	"@message void MSG_META_KBD_CHAR( word character = cx, word flags = dx, word state = bp)"
	^self geosMessage: #[0 119 3 245 1 1 1 0] with: character with: flags with: state!

pressure
	"@message void MSG_META_PRESSURE()"
	^self geosMessage: #[0 120 2 0 0]!

direction
	"@message void MSG_META_DIRECTION()"
	^self geosMessage: #[0 121 2 0 0]!

mouseTimer
	"@message void MSG_META_MOUSE_TIMER()"
	^self geosMessage: #[0 122 2 0 0]!

mouseDrag: xPosition with: yPosition with: inputState
	"@message void MSG_META_MOUSE_DRAG( word xPosition = cx, word yPosition = dx, word inputState = bp)"
	^self geosMessage: #[0 123 3 245 1 1 1 0] with: xPosition with: yPosition with: inputState!

clipboardNotifyQuickTransferFeedback: quickTransferCursor
	"@message void MSG_META_CLIPBOARD_NOTIFY_QUICK_TRANSFER_FEEDBACK(QuickTransferCursor quickTransferCursor = bp)"
	^self geosMessage: #[0 165 2 7 1 0] with: quickTransferCursor!

clipboardNotifyQuickTransferConcluded: flags
	"@message void MSG_META_CLIPBOARD_NOTIFY_QUICK_TRANSFER_CONCLUDED(ClipboardQuickNotifyFlags flags = bp)"
	^self geosMessage: #[0 166 2 7 1 0] with: flags!

clipboardCut
	"@message void MSG_META_CLIPBOARD_CUT()"
	^self geosMessage: #[0 168 2 0 0]!

clipboardCopy
	"@message void MSG_META_CLIPBOARD_COPY()"
	^self geosMessage: #[0 169 2 0 0]!

clipboardPaste
	"@message void MSG_META_CLIPBOARD_PASTE()"
	^self geosMessage: #[0 170 2 0 0]!

undo: undoData
	"@message void MSG_META_UNDO(UndoActionStruct *undoData = ss:bp)"
	^self geosMessage: #[0 171 0 128 3 0] with: undoData!

undoFreeingAction: data
	"@message void MSG_META_UNDO_FREEING_ACTION( AddUndoActionStruct *data = ss:bp)"
	^self geosMessage: #[0 172 0 128 3 0] with: data!

selectAll
	"@message void MSG_META_SELECT_ALL()"
	^self geosMessage: #[0 173 2 0 0]!

delete
	"@message void MSG_META_DELETE()"
	^self geosMessage: #[0 174 2 0 0]!

clipboardNotifyTransferItemFreed: itemFile with: itemBlock
	"@message void MSG_META_CLIPBOARD_NOTIFY_TRANSFER_ITEM_FREED(VMFileHandle itemFile = cx, VMBlockHandle itemBlock = dx)"
	^self geosMessage: #[0 175 2 53 1 1 0] with: itemFile with: itemBlock!

clipboardNotifyNormalTransferItemChanged
	"@message void MSG_META_CLIPBOARD_NOTIFY_NORMAL_TRANSFER_ITEM_CHANGED()"
	^self geosMessage: #[0 176 2 0 0]!

contentSetView: view
	"@message void MSG_META_CONTENT_SET_VIEW(optr view = cx:dx)"
	^self geosMessage: #[0 177 2 53 2 0] with: view!

contentViewOpening: view
	"@message void MSG_META_CONTENT_VIEW_OPENING(optr view = cx:dx)"
	^self geosMessage: #[0 178 2 53 2 0] with: view!

contentViewClosing
	"@message void MSG_META_CONTENT_VIEW_CLOSING()"
	^self geosMessage: #[0 179 2 0 0]!

contentViewWinOpened: viewWidth with: viewHeight with: viewWindow
	"@message void MSG_META_CONTENT_VIEW_WIN_OPENED( word viewWidth = cx, word viewHeight = dx, WindowHandle viewWindow = bp)"
	^self geosMessage: #[0 180 3 245 1 1 1 0] with: viewWidth with: viewHeight with: viewWindow!

contentViewWinClosed: viewWindow
	"@message void MSG_META_CONTENT_VIEW_WIN_CLOSED(WindowHandle viewWindow = bp)"
	^self geosMessage: #[0 181 2 7 1 0] with: viewWindow!

contentViewOriginChanged: viewWindow with: yOrigin with: xOrigin
	"@message void MSG_META_CONTENT_VIEW_ORIGIN_CHANGED(@stack WindowHandle viewWindow, sdword yOrigin, sdword xOrigin)"
	^self geosMessage: #[0 182 0 10 1 2 2 0] with: viewWindow with: yOrigin with: xOrigin!

contentViewScaleFactorChanged: viewWindow with: yScaleFactor with: xScaleFactor
	"@message void MSG_META_CONTENT_VIEW_SCALE_FACTOR_CHANGED( @stack WindowHandle viewWindow, WWFixedAsDWord yScaleFactor, WWFixedAsDWord xScaleFactor)"
	^self geosMessage: #[0 183 0 10 1 2 2 0] with: viewWindow with: yScaleFactor with: xScaleFactor!

contentViewSizeChanged: viewWidth with: viewHeight with: viewWindow
	"@message void MSG_META_CONTENT_VIEW_SIZE_CHANGED( word viewWidth = cx, word viewHeight = dx, WindowHandle viewWindow = bp)"
	^self geosMessage: #[0 184 3 245 1 1 1 0] with: viewWidth with: viewHeight with: viewWindow!

contentTrackScrolling: args
	"@message void MSG_META_CONTENT_TRACK_SCROLLING( TrackScrollingParams *args = ss:bp)"
	^self geosMessage: #[0 185 0 128 3 0] with: args!

contentViewLostGadgetExcl: viewWindow
	"@message void MSG_META_CONTENT_VIEW_LOST_GADGET_EXCL(WindowHandle viewWindow = bp)"
	^self geosMessage: #[0 186 2 7 1 0] with: viewWindow!

contentNavigationQuery: queryOrigin with: navFlags
	"@message void MSG_META_CONTENT_NAVIGATION_QUERY( optr queryOrigin = cx:dx, NavigateFlags navFlags = bp)"
	^self geosMessage: #[0 187 3 245 2 1 0] with: queryOrigin with: navFlags!

contentApplyDefaultFocus
	"@message void MSG_META_CONTENT_APPLY_DEFAULT_FOCUS()"
	^self geosMessage: #[0 188 2 0 0]!

contentEnter: view
	"@message void MSG_META_CONTENT_ENTER(optr view = cx:dx)"
	^self geosMessage: #[0 189 2 53 2 0] with: view!

contentLeave: view
	"@message void MSG_META_CONTENT_LEAVE(optr view = cx:dx)"
	^self geosMessage: #[0 190 2 53 2 0] with: view!

docOutputInitializeDocumentFile: document with: file
	"@message Boolean MSG_META_DOC_OUTPUT_INITIALIZE_DOCUMENT_FILE( optr document = cx:dx, FileHandle file = bp)= carry"
	^self geosMessage: #[0 191 3 245 2 1 4] with: document with: file!

docOutputCreateUiForDocument: document with: file
	"@message void MSG_META_DOC_OUTPUT_CREATE_UI_FOR_DOCUMENT( optr document = cx:dx, FileHandle file = bp)"
	^self geosMessage: #[0 192 3 245 2 1 0] with: document with: file!

docOutputDestroyUiForDocument: document with: file
	"@message void MSG_META_DOC_OUTPUT_DESTROY_UI_FOR_DOCUMENT( optr document = cx:dx, FileHandle file = bp)"
	^self geosMessage: #[0 193 3 245 2 1 0] with: document with: file!

docOutputAttachUiToDocument: document with: file
	"@message void MSG_META_DOC_OUTPUT_ATTACH_UI_TO_DOCUMENT( optr document = cx:dx, FileHandle file = bp)"
	^self geosMessage: #[0 194 3 245 2 1 0] with: document with: file!

docOutputDetachUiFromDocument: document with: file
	"@message void MSG_META_DOC_OUTPUT_DETACH_UI_FROM_DOCUMENT( optr document = cx:dx, FileHandle file = bp)"
	^self geosMessage: #[0 195 3 245 2 1 0] with: document with: file!

docOutputReadCachedDataFromFile: document with: file
	"@message void MSG_META_DOC_OUTPUT_READ_CACHED_DATA_FROM_FILE( optr document = cx:dx, FileHandle file = bp)"
	^self geosMessage: #[0 196 3 245 2 1 0] with: document with: file!

docOutputWriteCachedDataToFile: document with: file
	"@message void MSG_META_DOC_OUTPUT_WRITE_CACHED_DATA_TO_FILE( optr document = cx:dx, FileHandle file = bp)"
	^self geosMessage: #[0 197 3 245 2 1 0] with: document with: file!

docOutputDocumentHasChanged: document with: file
	"@message void MSG_META_DOC_OUTPUT_DOCUMENT_HAS_CHANGED( optr document = cx:dx, FileHandle file = bp)"
	^self geosMessage: #[0 198 3 245 2 1 0] with: document with: file!

docOutputPhysicalSave: error with: document with: file
	"@message Boolean MSG_META_DOC_OUTPUT_PHYSICAL_SAVE( word *error = multipleax, optr document = cx:dx, FileHandle file = bp)= carry"
	^self geosMessage: #[0 199 215 245 3 2 1 4] with: error with: document with: file!

docOutputPhysicalUpdate: error with: document with: file
	"@message Boolean MSG_META_DOC_OUTPUT_PHYSICAL_UPDATE( word *error = multipleax, optr document = cx:dx, FileHandle file = bp)= carry"
	^self geosMessage: #[0 200 215 245 3 2 1 4] with: error with: document with: file!

docOutputPhysicalSaveAsFileHandle: error with: document with: file
	"@message Boolean MSG_META_DOC_OUTPUT_PHYSICAL_SAVE_AS_FILE_HANDLE( word *error = multipleax, optr document = cx:dx, FileHandle file = bp)= carry"
	^self geosMessage: #[0 201 215 245 3 2 1 4] with: error with: document with: file!

docOutputPhysicalRevert: error with: document with: file
	"@message Boolean MSG_META_DOC_OUTPUT_PHYSICAL_REVERT( word *error = multipleax, optr document = cx:dx, FileHandle file = bp)= carry"
	^self geosMessage: #[0 202 215 245 3 2 1 4] with: error with: document with: file!

docOutputUpdateEarlierCompatibleDocument: error with: document with: file
	"@message Boolean MSG_META_DOC_OUTPUT_UPDATE_EARLIER_COMPATIBLE_DOCUMENT( word *error = multipleax, optr document = cx:dx, FileHandle file = bp)= carry"
	^self geosMessage: #[0 203 215 245 3 2 1 4] with: error with: document with: file!

docOutputUpdateEarlierIncompatibleDocument: error with: document with: file
	"@message Boolean MSG_META_DOC_OUTPUT_UPDATE_EARLIER_INCOMPATIBLE_DOCUMENT( word *error = multipleax, optr document = cx:dx, FileHandle file = bp)= carry"
	^self geosMessage: #[0 204 215 245 3 2 1 4] with: error with: document with: file!

docOutputSaveAsCompleted: document with: file
	"@message void MSG_META_DOC_OUTPUT_SAVE_AS_COMPLETED( optr document = cx:dx, FileHandle file = bp)"
	^self geosMessage: #[0 205 3 245 2 1 0] with: document with: file!

docOutputAttachFailed: document with: file
	"@message void MSG_META_DOC_OUTPUT_ATTACH_FAILED( optr document = cx:dx, FileHandle file = bp)"
	^self geosMessage: #[0 206 3 245 2 1 0] with: document with: file!

docOutputPhysicalRevertToAutoSave: error with: document with: file
	"@message Boolean MSG_META_DOC_OUTPUT_PHYSICAL_REVERT_TO_AUTO_SAVE( word *error = multipleax, optr document = cx:dx, FileHandle file = bp)= carry"
	^self geosMessage: #[0 207 215 245 3 2 1 4] with: error with: document with: file!

unusedMetaUi_11
	"@message void MSG_META_UNUSED_META_UI_11()"
	^self geosMessage: #[0 208 2 0 0]!

unusedMetaUi_12
	"@message void MSG_META_UNUSED_META_UI_12()"
	^self geosMessage: #[0 209 2 0 0]!

unusedMetaUi_13
	"@message void MSG_META_UNUSED_META_UI_13()"
	^self geosMessage: #[0 210 2 0 0]!

unusedMetaUi_14
	"@message void MSG_META_UNUSED_META_UI_14()"
	^self geosMessage: #[0 211 2 0 0]!

unusedMetaUi_15
	"@message void MSG_META_UNUSED_META_UI_15()"
	^self geosMessage: #[0 212 2 0 0]!

unusedMetaUi_16
	"@message void MSG_META_UNUSED_META_UI_16()"
	^self geosMessage: #[0 213 2 0 0]!

unusedMetaUi_17
	"@message void MSG_META_UNUSED_META_UI_17()"
	^self geosMessage: #[0 214 2 0 0]!

unusedMetaUi_18
	"@message void MSG_META_UNUSED_META_UI_18()"
	^self geosMessage: #[0 215 2 0 0]!

unusedMetaUi_19
	"@message void MSG_META_UNUSED_META_UI_19()"
	^self geosMessage: #[0 216 2 0 0]!

unusedMetaUi_20
	"@message void MSG_META_UNUSED_META_UI_20()"
	^self geosMessage: #[0 217 2 0 0]!

uiForceControllerUpdate: manufID with: changeID
	"@message void MSG_META_UI_FORCE_CONTROLLER_UPDATE( ManufacturerID manufID = cx, word changeID = dx)"
	^self geosMessage: #[0 218 2 53 1 1 0] with: manufID with: changeID!

genPathRestoreDiskPrompt: error with: args
	"@message Boolean MSG_META_GEN_PATH_RESTORE_DISK_PROMPT( DiskRestoreError *error = multipleax, GenPathDiskRestoreArgs *args = ss:bp)= carry"
	^self geosMessage: #[0 219 212 128 3 3 4] with: error with: args!

pagedObjectGotoPage: page
	"@message void MSG_META_PAGED_OBJECT_GOTO_PAGE(word page = cx)"
	^self geosMessage: #[0 220 2 5 1 0] with: page!

pagedObjectNextPage
	"@message void MSG_META_PAGED_OBJECT_NEXT_PAGE()"
	^self geosMessage: #[0 221 2 0 0]!

pagedObjectPreviousPage
	"@message void MSG_META_PAGED_OBJECT_PREVIOUS_PAGE()"
	^self geosMessage: #[0 222 2 0 0]!

notifyTaskSelected
	"@message void MSG_META_NOTIFY_TASK_SELECTED()"
	^self geosMessage: #[0 223 2 0 0]!

gainedMouseExcl
	"@message void MSG_META_GAINED_MOUSE_EXCL()"
	^self geosMessage: #[0 224 2 0 0]!

lostMouseExcl
	"@message void MSG_META_LOST_MOUSE_EXCL()"
	^self geosMessage: #[0 225 2 0 0]!

gainedKbdExcl
	"@message void MSG_META_GAINED_KBD_EXCL()"
	^self geosMessage: #[0 226 2 0 0]!

lostKbdExcl
	"@message void MSG_META_LOST_KBD_EXCL()"
	^self geosMessage: #[0 227 2 0 0]!

gainedPressureExcl
	"@message void MSG_META_GAINED_PRESSURE_EXCL()"
	^self geosMessage: #[0 228 2 0 0]!

lostPressureExcl
	"@message void MSG_META_LOST_PRESSURE_EXCL()"
	^self geosMessage: #[0 229 2 0 0]!

gainedDirectionExcl
	"@message void MSG_META_GAINED_DIRECTION_EXCL()"
	^self geosMessage: #[0 230 2 0 0]!

lostDirectionExcl
	"@message void MSG_META_LOST_DIRECTION_EXCL()"
	^self geosMessage: #[0 231 2 0 0]!

grabFocusExcl
	"@message void MSG_META_GRAB_FOCUS_EXCL()"
	^self geosMessage: #[0 232 2 0 0]!

releaseFocusExcl
	"@message void MSG_META_RELEASE_FOCUS_EXCL()"
	^self geosMessage: #[0 233 2 0 0]!

getFocusExcl: focusObject
	"@message Boolean MSG_META_GET_FOCUS_EXCL( optr *focusObject = dxcx)= carry"
	^self geosMessage: #[0 234 206 0 3 4] with: focusObject!

grabTargetExcl
	"@message void MSG_META_GRAB_TARGET_EXCL()"
	^self geosMessage: #[0 235 2 0 0]!

releaseTargetExcl
	"@message void MSG_META_RELEASE_TARGET_EXCL()"
	^self geosMessage: #[0 236 2 0 0]!

getTargetExcl: targetObject
	"@message Boolean MSG_META_GET_TARGET_EXCL( optr *targetObject = dxcx)= carry"
	^self geosMessage: #[0 237 206 0 3 4] with: targetObject!

grabModelExcl
	"@message void MSG_META_GRAB_MODEL_EXCL()"
	^self geosMessage: #[0 238 2 0 0]!

releaseModelExcl
	"@message void MSG_META_RELEASE_MODEL_EXCL()"
	^self geosMessage: #[0 239 2 0 0]!

getModelExcl: modelObject
	"@message Boolean MSG_META_GET_MODEL_EXCL( optr *modelObject = dxcx)= carry"
	^self geosMessage: #[0 240 206 0 3 4] with: modelObject!

releaseFtExcl
	"@message void MSG_META_RELEASE_FT_EXCL()"
	^self geosMessage: #[0 241 2 0 0]!

mupAlterFtvmcExcl: objectWantingControl with: flags
	"@message void MSG_META_MUP_ALTER_FTVMC_EXCL( optr objectWantingControl = cx:dx, MetaAlterFTVMCExclFlags flags = bp)"
	^self geosMessage: #[0 242 3 245 2 1 0] with: objectWantingControl with: flags!

gainedFocusExcl
	"@message void MSG_META_GAINED_FOCUS_EXCL()"
	^self geosMessage: #[0 243 2 0 0]!

lostFocusExcl
	"@message void MSG_META_LOST_FOCUS_EXCL()"
	^self geosMessage: #[0 244 2 0 0]!

gainedSysFocusExcl
	"@message void MSG_META_GAINED_SYS_FOCUS_EXCL()"
	^self geosMessage: #[0 245 2 0 0]!

lostSysFocusExcl
	"@message void MSG_META_LOST_SYS_FOCUS_EXCL()"
	^self geosMessage: #[0 246 2 0 0]!

gainedTargetExcl
	"@message void MSG_META_GAINED_TARGET_EXCL()"
	^self geosMessage: #[0 247 2 0 0]!

lostTargetExcl
	"@message void MSG_META_LOST_TARGET_EXCL()"
	^self geosMessage: #[0 248 2 0 0]!

gainedSysTargetExcl
	"@message void MSG_META_GAINED_SYS_TARGET_EXCL()"
	^self geosMessage: #[0 249 2 0 0]!

lostSysTargetExcl
	"@message void MSG_META_LOST_SYS_TARGET_EXCL()"
	^self geosMessage: #[0 250 2 0 0]!

gainedModelExcl
	"@message void MSG_META_GAINED_MODEL_EXCL()"
	^self geosMessage: #[0 251 2 0 0]!

lostModelExcl
	"@message void MSG_META_LOST_MODEL_EXCL()"
	^self geosMessage: #[0 252 2 0 0]!

gainedSysModelExcl
	"@message void MSG_META_GAINED_SYS_MODEL_EXCL()"
	^self geosMessage: #[0 253 2 0 0]!

lostSysModelExcl
	"@message void MSG_META_LOST_SYS_MODEL_EXCL()"
	^self geosMessage: #[0 254 2 0 0]!

querySaveDocuments
	"@message void MSG_META_QUERY_SAVE_DOCUMENTS()"
	^self geosMessage: #[0 255 2 0 0]!

broadcastReturningToWelcome
	"@message void MSG_META_BROADCAST_RETURNING_TO_WELCOME()"
	^self geosMessage: #[1 0 2 0 0]!

gainedDefaultExcl
	"@message void MSG_META_GAINED_DEFAULT_EXCL()"
	^self geosMessage: #[1 1 2 0 0]!

lostDefaultExcl
	"@message void MSG_META_LOST_DEFAULT_EXCL()"
	^self geosMessage: #[1 2 2 0 0]!

mouseBumpNotification: xBump with: yBump
	"@message void MSG_META_MOUSE_BUMP_NOTIFICATION( sword xBump = cx, sword yBump = dx)"
	^self geosMessage: #[1 3 2 53 4 4 0] with: xBump with: yBump!

fupKbdChar: character with: flags with: state
	"@message Boolean MSG_META_FUP_KBD_CHAR( word character = cx, word flags = dx, word state = bp)= carry"
	^self geosMessage: #[1 4 3 245 1 1 1 4] with: character with: flags with: state!

prePassiveKbdChar: character with: flags with: state
	"@message KbdReturnFlags MSG_META_PRE_PASSIVE_KBD_CHAR( word character = cx, word flags = dx, word state = bp)= ax"
	^self geosMessage: #[1 5 99 245 1 1 1 1] with: character with: flags with: state!

postPassiveKbdChar: character with: flags with: state
	"@message KbdReturnFlags MSG_META_POST_PASSIVE_KBD_CHAR( word character = cx, word flags = dx, word state = bp)= ax"
	^self geosMessage: #[1 6 99 245 1 1 1 1] with: character with: flags with: state!

queryIfPressIsInk: retVal with: xPosition with: yPosition
	"@message void MSG_META_QUERY_IF_PRESS_IS_INK( InkReturnParams *retVal = bpaxdxcx, sword xPosition=cx, sword yPosition=dx)"
	^self geosMessage: #[1 7 210 53 3 4 4 0] with: retVal with: xPosition with: yPosition!

largeQueryIfPressIsInk: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_QUERY_IF_PRESS_IS_INK( InkReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct = ss:bp)"
	^self geosMessage: #[1 8 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

startSelect: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_START_SELECT(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 9 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

endSelect: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_END_SELECT(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 10 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

startMoveCopy: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_START_MOVE_COPY(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 11 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

endMoveCopy: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_END_MOVE_COPY(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 12 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

startFeatures: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_START_FEATURES(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 13 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

endFeatures: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_END_FEATURES(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 14 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

startOther: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_START_OTHER(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 15 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

endOther: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_END_OTHER(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 16 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

dragSelect: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_DRAG_SELECT(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 17 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

dragMoveCopy: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_DRAG_MOVE_COPY(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 18 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

dragFeatures: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_DRAG_FEATURES(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 19 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

dragOther: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_DRAG_OTHER(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 20 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

prePassiveButton: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_PRE_PASSIVE_BUTTON(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 21 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

postPassiveButton: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_POST_PASSIVE_BUTTON(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 22 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

prePassiveStartSelect: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_PRE_PASSIVE_START_SELECT(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 23 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

prePassiveEndSelect: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_PRE_PASSIVE_END_SELECT(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 24 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

prePassiveStartMoveCopy: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_PRE_PASSIVE_START_MOVE_COPY(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 25 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

prePassiveEndMoveCopy: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_PRE_PASSIVE_END_MOVE_COPY(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 26 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

prePassiveStartFeatures: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_PRE_PASSIVE_START_FEATURES(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 27 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

prePassiveEndFeatures: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_PRE_PASSIVE_END_FEATURES(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 28 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

prePassiveStartOther: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_PRE_PASSIVE_START_OTHER(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 29 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

prePassiveEndOther: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_PRE_PASSIVE_END_OTHER(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 30 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

postPassiveStartSelect: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_POST_PASSIVE_START_SELECT(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 31 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

postPassiveEndSelect: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_POST_PASSIVE_END_SELECT(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 32 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

postPassiveStartMoveCopy: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_POST_PASSIVE_START_MOVE_COPY(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 33 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

postPassiveEndMoveCopy: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_POST_PASSIVE_END_MOVE_COPY(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 34 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

postPassiveStartFeatures: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_POST_PASSIVE_START_FEATURES(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 35 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

postPassiveEndFeatures: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_POST_PASSIVE_END_FEATURES(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 36 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

postPassiveStartOther: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_POST_PASSIVE_START_OTHER(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 37 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

postPassiveEndOther: retVal with: xPosition with: yPosition with: inputState
	"@message void MSG_META_POST_PASSIVE_END_OTHER(MouseReturnParams *retVal = bpaxdxcx, sword xPosition = cx, sword yPosition = dx, word inputState = bp)"
	^self geosMessage: #[1 38 211 245 3 4 4 1 0] with: retVal with: xPosition with: yPosition with: inputState!

largePtr: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_PTR(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 39 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

largeStartSelect: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_START_SELECT(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 40 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

largeEndSelect: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_END_SELECT(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 41 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

largeStartMoveCopy: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_START_MOVE_COPY(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 42 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

largeEndMoveCopy: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_END_MOVE_COPY(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 43 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

largeStartFeatures: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_START_FEATURES(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 44 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

largeEndFeatures: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_END_FEATURES(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 45 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

largeStartOther: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_START_OTHER(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 46 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

largeEndOther: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_END_OTHER(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 47 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

largeDragSelect: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_DRAG_SELECT(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 48 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

largeDragMoveCopy: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_DRAG_MOVE_COPY(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 49 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

largeDragFeatures: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_DRAG_FEATURES(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 50 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

largeDragOther: retVal with: largeMouseDataStruct
	"@message void MSG_META_LARGE_DRAG_OTHER(MouseReturnParams *retVal = bpaxdxcx, LargeMouseData *largeMouseDataStruct=ss:bp)"
	^self geosMessage: #[1 51 208 128 3 3 0] with: retVal with: largeMouseDataStruct!

ensureMouseNotActivelyTrespassing
	"@message MouseReturnFlags MSG_META_ENSURE_MOUSE_NOT_ACTIVELY_TRESPASSING()= ax"
	^self geosMessage: #[1 52 98 0 1]!

ensureNoMenusInStayUpMode: params
	"@message MouseReturnFlags MSG_META_ENSURE_NO_MENUS_IN_STAY_UP_MODE(EnsureNoMenusInStayUpModeParams *params = cx:dx)= ax"
	^self geosMessage: #[1 53 98 53 3 1] with: params!

ensureActiveFt
	"@message void MSG_META_ENSURE_ACTIVE_FT()"
	^self geosMessage: #[1 54 2 0 0]!

notifyNoFocusWithinNode
	"@message void MSG_META_NOTIFY_NO_FOCUS_WITHIN_NODE()"
	^self geosMessage: #[1 55 2 0 0]!

docOutputImportFile
	"@message void MSG_META_DOC_OUTPUT_IMPORT_FILE()"
	^self geosMessage: #[1 56 2 0 0]!

docOutputExportFile
	"@message void MSG_META_DOC_OUTPUT_EXPORT_FILE()"
	^self geosMessage: #[1 57 2 0 0]!

grabKbd
	"@message void MSG_META_GRAB_KBD()"
	^self geosMessage: #[1 58 2 0 0]!

forceGrabKbd
	"@message void MSG_META_FORCE_GRAB_KBD()"
	^self geosMessage: #[1 59 2 0 0]!

releaseKbd
	"@message void MSG_META_RELEASE_KBD()"
	^self geosMessage: #[1 60 2 0 0]!

viewCommandChangeScale
	"@message void MSG_META_VIEW_COMMAND_CHANGE_SCALE()"
	^self geosMessage: #[1 61 2 0 0]!

fieldNotifyDetach: field with: shutdownFlag
	"@message void MSG_META_FIELD_NOTIFY_DETACH(optr field = cx:dx, word shutdownFlag = bp)"
	^self geosMessage: #[1 62 3 245 2 1 0] with: field with: shutdownFlag!

fieldNotifyNoFocus: field with: shutdownFlag
	"@message void MSG_META_FIELD_NOTIFY_NO_FOCUS(optr field = cx:dx, word shutdownFlag = bp)"
	^self geosMessage: #[1 63 3 245 2 1 0] with: field with: shutdownFlag!

fieldNotifyStartLauncherError: field
	"@message void MSG_META_FIELD_NOTIFY_START_LAUNCHER_ERROR(optr field = cx:dx)"
	^self geosMessage: #[1 64 2 53 2 0] with: field!

deleteRangeOfChars: rangeToDelete
	"@message void MSG_META_DELETE_RANGE_OF_CHARS(@stack VisTextRange rangeToDelete)"
	^self geosMessage: #[1 65 0 8 64 8 0] with: rangeToDelete!

testWinInteractibility: inputOD with: window
	"@message Boolean MSG_META_TEST_WIN_INTERACTIBILITY(optr inputOD = cx:dx, WindowHandle window = bp)= carry"
	^self geosMessage: #[1 66 3 245 2 1 4] with: inputOD with: window!

checkIfInteractableObject: obj
	"@message Boolean MSG_META_CHECK_IF_INTERACTABLE_OBJECT(optr obj=cx:dx)= carry"
	^self geosMessage: #[1 67 2 53 2 4] with: obj!

gainedFullScreenExcl
	"@message void MSG_META_GAINED_FULL_SCREEN_EXCL()"
	^self geosMessage: #[1 68 2 0 0]!

lostFullScreenExcl
	"@message void MSG_META_LOST_FULL_SCREEN_EXCL()"
	^self geosMessage: #[1 69 2 0 0]!

actionNotification: grobjOD with: type
	"@message void MSG_GROBJ_ACTION_NOTIFICATION( optr grobjOD = cx:dx, GrObjActionNotificationType type = bp)"
	^self geosMessage: #[2 37 3 245 2 1 0] with: grobjOD with: type!

verifyPrintRequest: printCtrlOD
	"@message void MSG_PRINT_VERIFY_PRINT_REQUEST( optr printCtrlOD = cx:dx )"
	^self geosMessage: #[2 85 2 53 2 0] with: printCtrlOD!

startPrinting: printCtrlOD with: gstate
	"@message void MSG_PRINT_START_PRINTING( optr printCtrlOD = cx:dx, GStateHandle gstate = bp )"
	^self geosMessage: #[2 86 3 245 2 1 0] with: printCtrlOD with: gstate!

getDocName: printCtrlOD
	"@message void MSG_PRINT_GET_DOC_NAME( optr printCtrlOD = cx:dx)"
	^self geosMessage: #[2 87 2 53 2 0] with: printCtrlOD!

notifyPrintDb: printCtrlOD with: pcs
	"@message void MSG_PRINT_NOTIFY_PRINT_DB( optr printCtrlOD = cx:dx, PrintControlStatus pcs = bp )"
	^self geosMessage: #[2 88 3 245 2 1 0] with: printCtrlOD with: pcs!

notifyPrintJobCreated: printCtrlOD with: jobID
	"@message void MSG_PRINT_NOTIFY_PRINT_JOB_CREATED( optr printCtrlOD = cx:dx, word jobID = bp)"
	^self geosMessage: #[2 89 3 245 2 1 0] with: printCtrlOD with: jobID!

reportPageSize: psr
	"@message void MSG_PRINT_REPORT_PAGE_SIZE( PageSizeReport *psr = ss:bp)"
	^self geosMessage: #[2 90 0 128 3 0] with: psr!

msgSearch: searchInfo
	"@message void MSG_SEARCH(MemHandle searchInfo = dx)"
	^self geosMessage: #[2 133 2 6 1 0] with: searchInfo!

current: replaceInfo
	"@message void MSG_REPLACE_CURRENT(MemHandle replaceInfo = dx)"
	^self geosMessage: #[2 134 2 6 1 0] with: replaceInfo!

allOccurrences: replaceInfo with: replaceFromBeginning
	"@message void MSG_REPLACE_ALL_OCCURRENCES( MemHandle replaceInfo = dx, Boolean replaceFromBeginning = cx)"
	^self geosMessage: #[2 135 2 46 1 4 0] with: replaceInfo with: replaceFromBeginning!

allOccurrencesInSelection: replaceInfo
	"@message void MSG_REPLACE_ALL_OCCURRENCES_IN_SELECTION(MemHandle replaceInfo = dx)"
	^self geosMessage: #[2 136 2 6 1 0] with: replaceInfo!

activeSpell
	"@message void MSG_ABORT_ACTIVE_SPELL()"
	^self geosMessage: #[2 137 2 0 0]!

activeSearch
	"@message void MSG_ABORT_ACTIVE_SEARCH()"
	^self geosMessage: #[2 138 2 0 0]!

getObjectForSearchSpell: option with: curObject
	"@message optr MSG_META_GET_OBJECT_FOR_SEARCH_SPELL(GetSearchSpellObjectOption option = bp, optr curObject = cx:dx)= cx:dx"
	^self geosMessage: #[2 139 155 175 1 2 2] with: option with: curObject!

getContext: position with: location with: numCharsToGet with: replyObj
	"@message void MSG_META_GET_CONTEXT(@stack dword position, ContextLocation location, word numCharsToGet, optr replyObj)"
	^self geosMessage: #[2 140 0 12 2 1 1 2 0] with: position with: location with: numCharsToGet with: replyObj!

generateContextNotification: position with: location with: numCharsToGet with: replyObj
	"@message void MSG_META_GENERATE_CONTEXT_NOTIFICATION(@stack dword position, ContextLocation location, word numCharsToGet, optr replyObj)"
	^self geosMessage: #[2 141 0 12 2 1 1 2 0] with: position with: location with: numCharsToGet with: replyObj!

context: data
	"@message void MSG_META_CONTEXT( MemHandle data = bp)"
	^self geosMessage: #[2 142 2 7 1 0] with: data!

displayObjectForSearchSpell
	"@message void MSG_META_DISPLAY_OBJECT_FOR_SEARCH_SPELL()"
	^self geosMessage: #[2 143 2 0 0]!

check: replyObj with: numCharsToCheck with: options with: ICbuff
	"@message void MSG_SPELL_CHECK(@stack optr replyObj, dword numCharsToCheck, SpellCheckOptions options, MemHandle ICbuff)"
	^self geosMessage: #[2 144 0 12 2 2 1 1 0] with: replyObj with: numCharsToCheck with: options with: ICbuff!

editUserDictionaryCompleted
	"@message void MSG_META_EDIT_USER_DICTIONARY_COMPLETED()"
	^self geosMessage: #[2 145 2 0 0]!

replaceSelectedWords: RSWP_string with: RSWP_numChars
	"@message void MSG_THES_REPLACE_SELECTED_WORDS(@stack MemHandle RSWP_string, word RSWP_numChars)"
	^self geosMessage: #[2 146 0 4 1 1 0] with: RSWP_string with: RSWP_numChars!

selectWord: output with: message with: numChars with: type
	"@message void MSG_THES_SELECT_WORD(@stack optr output, Message message, word numChars, word type)"
	^self geosMessage: #[2 147 0 10 2 1 1 1 0] with: output with: message with: numChars with: type!

fileChange: notifyType with: data
	"@message void MSG_NOTIFY_FILE_CHANGE( FileChangeNotificationType notifyType = dx, MemHandle data = bp)"
	^self geosMessage: #[2 181 2 62 1 1 0] with: notifyType with: data!

driveChange: type with: driveNum
	"@message void MSG_NOTIFY_DRIVE_CHANGE( GCNDriveChangeNotificationType type=cx, word driveNum=dx)"
	^self geosMessage: #[2 182 2 53 1 1 0] with: type with: driveNum!

appStarted
	"@message void MSG_NOTIFY_APP_STARTED()"
	^self geosMessage: #[2 183 2 0 0]!

appExited: appExited
	"@message void MSG_NOTIFY_APP_EXITED(MemHandle appExited = dx)"
	^self geosMessage: #[2 184 2 6 1 0] with: appExited!

dateTimeChange
	"@message void MSG_NOTIFY_DATE_TIME_CHANGE()"
	^self geosMessage: #[2 185 2 0 0]!

userDictChange: sendingSpellBox with: userDictChanged
	"@message void MSG_NOTIFY_USER_DICT_CHANGE( MemHandle sendingSpellBox = dx, MemHandle userDictChanged = bp)"
	^self geosMessage: #[2 186 2 62 1 1 0] with: sendingSpellBox with: userDictChanged!

keyboardLayoutChange
	"@message void MSG_NOTIFY_KEYBOARD_LAYOUT_CHANGE()"
	^self geosMessage: #[2 187 2 0 0]!

expressMenuChange: type with: affectedExpressMenuControl
	"@message void MSG_NOTIFY_EXPRESS_MENU_CHANGE( GCNExpressMenuNotificationTypes type = bp, optr affectedExpressMenuControl = cx:dx)"
	^self geosMessage: #[2 188 3 175 1 2 0] with: type with: affectedExpressMenuControl!

installedRemoved
	"@message void MSG_PRINTER_INSTALLED_REMOVED()"
	^self geosMessage: #[2 189 2 0 0]!

confirmShutdown: confirmed with: type
	"@message void MSG_META_CONFIRM_SHUTDOWN( word confirmed=cx, GCNShutdownControlType type=bp)"
	^self geosMessage: #[2 190 2 61 1 1 0] with: confirmed with: type!

inkRedisplay
	"@message void MSG_NOTIFY_INK_REDISPLAY()"
	^self geosMessage: #[2 191 2 0 0]!

dialogInitialized
	"@message void MSG_PRINT_DIALOG_INITIALIZED()"
	^self geosMessage: #[2 192 2 0 0]!

jobCancelled
	"@message void MSG_PRINT_JOB_CANCELLED()"
	^self geosMessage: #[2 193 2 0 0]!

statusChange: change with: jobID with: data
	"@message void MSG_PRINT_STATUS_CHANGE( PrintStatusChangeType change = cx, word jobID = dx, word data = bp)"
	^self geosMessage: #[2 194 3 245 1 1 1 0] with: change with: jobID with: data!

textSetFontId: fid with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_FONT_ID(@stack FontID fid, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 229 0 10 1 2 2 0] with: fid with: rangeEnd with: rangeStart!

textSetFontWeight: fontWeight with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_FONT_WEIGHT(@stack byte fontWeight, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 230 0 10 1 2 2 0] with: fontWeight with: rangeEnd with: rangeStart!

textSetFontWidth: fontWidth with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_FONT_WIDTH(@stack byte fontWidth, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 231 0 10 1 2 2 0] with: fontWidth with: rangeEnd with: rangeStart!

textSetPointSize: pointSize with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_POINT_SIZE(@stack WWFixed pointSize, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 232 0 12 2 2 2 0] with: pointSize with: rangeEnd with: rangeStart!

textSetSmallerPointSize: minimumSize with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_SMALLER_POINT_SIZE( @stack word minimumSize, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 233 0 10 1 2 2 0] with: minimumSize with: rangeEnd with: rangeStart!

textSetLargerPointSize: maximumSize with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_LARGER_POINT_SIZE( @stack word maximumSize, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 234 0 10 1 2 2 0] with: maximumSize with: rangeEnd with: rangeStart!

textSetTextStyle: extBitsToClear with: extBitsToSet with: styleBitsToClear with: styleBitsToSet with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_TEXT_STYLE(@stack VisTextExtendedStyles extBitsToClear, VisTextExtendedStyles extBitsToSet, TextStyle styleBitsToClear, TextStyle styleBitsToSet, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 235 0 16 1 1 1 1 2 2 0] with: extBitsToClear with: extBitsToSet with: styleBitsToClear with: styleBitsToSet with: rangeEnd with: rangeStart!

textSetColor: color with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_COLOR(@stack ColorQuad color, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 236 0 12 2 2 2 0] with: color with: rangeEnd with: rangeStart!

textSetGrayScreen: grayScreen with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_GRAY_SCREEN(@stack SystemDrawMask grayScreen, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 237 0 10 1 2 2 0] with: grayScreen with: rangeEnd with: rangeStart!

textSetPattern: hatch with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_PATTERN(@stack GraphicPattern hatch, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 238 0 10 1 2 2 0] with: hatch with: rangeEnd with: rangeStart!

textSetCharBgColor: color with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_CHAR_BG_COLOR(@stack ColorQuad color, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 239 0 12 2 2 2 0] with: color with: rangeEnd with: rangeStart!

textSetCharBgGrayScreen: grayScreen with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_CHAR_BG_GRAY_SCREEN( @stack SystemDrawMask grayScreen, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 240 0 10 1 2 2 0] with: grayScreen with: rangeEnd with: rangeStart!

textSetCharBgPattern: hatch with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_CHAR_BG_PATTERN(@stack GraphicPattern hatch, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 241 0 10 1 2 2 0] with: hatch with: rangeEnd with: rangeStart!

textSetTrackKerning: trackKerning with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_TRACK_KERNING(@stack BBFixed trackKerning, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 242 0 10 1 2 2 0] with: trackKerning with: rangeEnd with: rangeStart!

textSetBorderColor: color with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_BORDER_COLOR(@stack ColorQuad color, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 243 0 12 2 2 2 0] with: color with: rangeEnd with: rangeStart!

textSetBorderGrayScreen: grayScreen with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_BORDER_GRAY_SCREEN( @stack SystemDrawMask grayScreen, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 244 0 10 1 2 2 0] with: grayScreen with: rangeEnd with: rangeStart!

textSetBorderPattern: hatch with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_BORDER_PATTERN(@stack GraphicPattern hatch, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 245 0 10 1 2 2 0] with: hatch with: rangeEnd with: rangeStart!

textSetParaAttributes: bitsToClear with: bitsToSet with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_PARA_ATTRIBUTES(@stack VisTextParaAttrAttributes bitsToClear, VisTextParaAttrAttributes bitsToSet, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[2 246 0 12 1 1 2 2 0] with: bitsToClear with: bitsToSet with: rangeEnd with: rangeStart!

textUserModified: obj
	"@message void MSG_META_TEXT_USER_MODIFIED( optr obj = cx:dx)"
	^self geosMessage: #[2 247 2 53 2 0] with: obj!

textCrFiltered: character with: params
	"@message void MSG_META_TEXT_CR_FILTERED( word character = cx, MetaTextFilteredParameters params=dx:bp)"
	^self geosMessage: #[2 248 3 245 1 64 5 0] with: character with: params!

textTabFiltered: character with: params
	"@message void MSG_META_TEXT_TAB_FILTERED( word character = cx, MetaTextFilteredParameters params=dx:bp)"
	^self geosMessage: #[2 249 3 245 1 64 5 0] with: character with: params!

textLostFocus: obj
	"@message void MSG_META_TEXT_LOST_FOCUS( optr obj = cx:dx)"
	^self geosMessage: #[2 250 2 53 2 0] with: obj!

textGainedFocus: obj
	"@message void MSG_META_TEXT_GAINED_FOCUS( optr obj = cx:dx)"
	^self geosMessage: #[2 251 2 53 2 0] with: obj!

textLostTarget: obj
	"@message void MSG_META_TEXT_LOST_TARGET( optr obj = cx:dx)"
	^self geosMessage: #[2 252 2 53 2 0] with: obj!

textGainedTarget: obj
	"@message void MSG_META_TEXT_GAINED_TARGET( optr obj = cx:dx)"
	^self geosMessage: #[2 253 2 53 2 0] with: obj!

textEmptyStatusChanged: object with: hasTextFlag
	"@message void MSG_META_TEXT_EMPTY_STATUS_CHANGED( optr object = cx:dx, Boolean hasTextFlag = bp)"
	^self geosMessage: #[2 254 3 245 2 4 0] with: object with: hasTextFlag!

textNotUserModified: obj
	"@message void MSG_META_TEXT_NOT_USER_MODIFIED( optr obj = cx:dx)"
	^self geosMessage: #[2 255 2 53 2 0] with: obj!

textSetTextMiscMode: miscModeFlags with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_TEXT_MISC_MODE(@stack byte miscModeFlags, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[3 0 0 10 1 2 2 0] with: miscModeFlags with: rangeEnd with: rangeStart!

textSetHyperlink: flags with: file with: context with: rangeEnd with: rangeStart
	"@message void MSG_META_TEXT_SET_HYPERLINK(@stack VisTextSetContextFlags flags, word file, word context, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[3 1 0 14 1 1 1 2 2 0] with: flags with: file with: context with: rangeEnd with: rangeStart!

textFollowHyperlink: rangeEnd with: rangeStart
	"@message void MSG_META_TEXT_FOLLOW_HYPERLINK(@stack dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[3 2 0 8 2 2 0] with: rangeEnd with: rangeStart!

styledObjectRequestEntryMoniker
	"@message void MSG_META_STYLED_OBJECT_REQUEST_ENTRY_MONIKER()"
	^self geosMessage: #[3 21 2 0 0]!

styledObjectUpdateModifyBox
	"@message void MSG_META_STYLED_OBJECT_UPDATE_MODIFY_BOX()"
	^self geosMessage: #[3 22 2 0 0]!

styledObjectModifyStyle
	"@message void MSG_META_STYLED_OBJECT_MODIFY_STYLE()"
	^self geosMessage: #[3 23 2 0 0]!

styledObjectDescribeAttrs
	"@message void MSG_META_STYLED_OBJECT_DESCRIBE_ATTRS()"
	^self geosMessage: #[3 24 2 0 0]!

styledObjectDescribeStyle
	"@message void MSG_META_STYLED_OBJECT_DESCRIBE_STYLE()"
	^self geosMessage: #[3 25 2 0 0]!

styledObjectApplyStyle
	"@message void MSG_META_STYLED_OBJECT_APPLY_STYLE()"
	^self geosMessage: #[3 26 2 0 0]!

styledObjectDeleteStyle
	"@message void MSG_META_STYLED_OBJECT_DELETE_STYLE()"
	^self geosMessage: #[3 27 2 0 0]!

styledObjectDefineStyle
	"@message void MSG_META_STYLED_OBJECT_DEFINE_STYLE()"
	^self geosMessage: #[3 28 2 0 0]!

styledObjectRedefineStyle
	"@message void MSG_META_STYLED_OBJECT_REDEFINE_STYLE()"
	^self geosMessage: #[3 29 2 0 0]!

styledObjectReturnToBaseStyle
	"@message void MSG_META_STYLED_OBJECT_RETURN_TO_BASE_STYLE()"
	^self geosMessage: #[3 30 2 0 0]!

styledObjectLoadStyleSheet
	"@message void MSG_META_STYLED_OBJECT_LOAD_STYLE_SHEET()"
	^self geosMessage: #[3 31 2 0 0]!

styledObjectSaveStyle
	"@message void MSG_META_STYLED_OBJECT_SAVE_STYLE()"
	^self geosMessage: #[3 32 2 0 0]!

styledObjectRecallStyle
	"@message void MSG_META_STYLED_OBJECT_RECALL_STYLE()"
	^self geosMessage: #[3 33 2 0 0]!

coloredObjectSetColor: colorQuad
	"@message void MSG_META_COLORED_OBJECT_SET_COLOR( ColorQuad colorQuad = dx.cx)"
	^self geosMessage: #[3 69 2 46 2 0] with: colorQuad!

coloredObjectSetDrawMask: drawMask
	"@message void MSG_META_COLORED_OBJECT_SET_DRAW_MASK( SystemDrawMask drawMask = cl)"
	^self geosMessage: #[3 70 2 1 1 0] with: drawMask!

coloredObjectSetPattern: pattern
	"@message void MSG_META_COLORED_OBJECT_SET_PATTERN( GraphicPattern pattern = cx)"
	^self geosMessage: #[3 71 2 5 1 0] with: pattern!

ctrlRequestMoniker: formatInfoStrucHan
	"@message void MSG_FLOAT_CTRL_REQUEST_MONIKER( MemHandle formatInfoStrucHan = cx)"
	^self geosMessage: #[3 117 2 5 1 0] with: formatInfoStrucHan!

ctrlUpdateUi: formatInfoStrucHan
	"@message void MSG_FLOAT_CTRL_UPDATE_UI( MemHandle formatInfoStrucHan = cx)"
	^self geosMessage: #[3 118 2 5 1 0] with: formatInfoStrucHan!

ctrlFormatSelected: formatInfoStrucHan
	"@message void MSG_FLOAT_CTRL_FORMAT_SELECTED( MemHandle formatInfoStrucHan = cx)"
	^self geosMessage: #[3 119 2 5 1 0] with: formatInfoStrucHan!

ctrlUserDefInvoke: formatInfoStrucHan
	"@message void MSG_FLOAT_CTRL_USER_DEF_INVOKE( MemHandle formatInfoStrucHan = cx)"
	^self geosMessage: #[3 120 2 5 1 0] with: formatInfoStrucHan!

ctrlUserDefOk: formatInfoStrucHan
	"@message void MSG_FLOAT_CTRL_USER_DEF_OK( MemHandle formatInfoStrucHan = cx)"
	^self geosMessage: #[3 121 2 5 1 0] with: formatInfoStrucHan!

ctrlFormatDelete: formatInfoStrucHan
	"@message void MSG_FLOAT_CTRL_FORMAT_DELETE( MemHandle formatInfoStrucHan = cx)"
	^self geosMessage: #[3 122 2 5 1 0] with: formatInfoStrucHan!

ctrlReplaceNumFormat: formatInfoStrucHan
	"@message void MSG_FLOAT_CTRL_REPLACE_NUM_FORMAT( MemHandle formatInfoStrucHan = cx)"
	^self geosMessage: #[3 123 2 5 1 0] with: formatInfoStrucHan!

ctrlFormatApply: formatInfoStrucHan
	"@message void MSG_FLOAT_CTRL_FORMAT_APPLY( MemHandle formatInfoStrucHan = cx)"
	^self geosMessage: #[3 124 2 5 1 0] with: formatInfoStrucHan!

replaceTextSelection
	"@message void MSG_SPREADSHEET_REPLACE_TEXT_SELECTION()"
	^self geosMessage: #[3 165 2 0 0]!

iacpProcessMessage: msgToSend with: topt with: completionMsg
	"@message void MSG_META_IACP_PROCESS_MESSAGE(EventHandle msgToSend = cx, TravelOption topt = dx, EventHandle completionMsg=bp)"
	^self geosMessage: #[3 213 3 245 1 1 1 0] with: msgToSend with: topt with: completionMsg!

iacpNewConnection: appLaunchBlock with: justLaunched with: connection
	"@message void MSG_META_IACP_NEW_CONNECTION(MemHandle appLaunchBlock=cx, Boolean justLaunched=dx, IACPConnection connection=bp)"
	^self geosMessage: #[3 214 3 245 1 4 1 0] with: appLaunchBlock with: justLaunched with: connection!

iacpLostConnection: connection with: serverNum
	"@message void MSG_META_IACP_LOST_CONNECTION(IACPConnection connection=bp, word serverNum = cx)"
	^self geosMessage: #[3 215 2 47 1 1 0] with: connection with: serverNum!

iacpShutdownConnection: connection
	"@message void MSG_META_IACP_SHUTDOWN_CONNECTION(IACPConnection connection=bp)"
	^self geosMessage: #[3 216 2 7 1 0] with: connection!

iacpDocOpenAck: params
	"@message void MSG_META_IACP_DOC_OPEN_ACK(IACPDocOpenAckParams *params=ss:bp)"
	^self geosMessage: #[3 217 0 128 3 0] with: params!

iacpDocCloseAck: params
	"@message void MSG_META_IACP_DOC_CLOSE_ACK(IACPDocCloseAckParams *params=ss:bp)"
	^self geosMessage: #[3 218 0 128 3 0] with: params!

iacpAllowFileAccess: connection
	"@message void MSG_META_IACP_ALLOW_FILE_ACCESS(IACPConnection connection=bp)"
	^self geosMessage: #[3 219 2 7 1 0] with: connection!

iacpNotifyFileAccessFinished: connection
	"@message void MSG_META_IACP_NOTIFY_FILE_ACCESS_FINISHED(IACPConnection connection=bp)"
	^self geosMessage: #[3 220 2 7 1 0] with: connection!

mailboxCreateMessage: sendControl with: transHandle
	"@message void MSG_META_MAILBOX_CREATE_MESSAGE(optr sendControl = cx:dx, word transHandle = bp)"
	^self geosMessage: #[4 5 3 245 2 1 0] with: sendControl with: transHandle!

mailboxMessageRegistered: args
	"@message void MSG_META_MAILBOX_MESSAGE_REGISTERED(MemHandle args = cx)"
	^self geosMessage: #[4 6 2 5 1 0] with: args!

mailboxNotifyMessageAvailable: msg
	"@message Boolean MSG_META_MAILBOX_NOTIFY_MESSAGE_AVAILABLE(MailboxMessage msg = cx:dx)= carry"
	^self geosMessage: #[4 7 2 53 2 4] with: msg!

!

!Process comment!
Library geos, file objects/processc.goh! !

!Process class methodsFor: 'library linkage'!

library
	^0!

entry
	^711!
!

!Process methodsFor: 'Geos instance variables'!

!

!Process methodsFor: 'Geos vardata'!

!

!Process methodsFor: 'Geos messages'!

notifyProcessExit: exitProcess with: exitCode
	"@message void MSG_PROCESS_NOTIFY_PROCESS_EXIT(GeodeHandle exitProcess = cx, word exitCode = dx)"
	^self geosMessage: #[32 0 2 53 1 1 0] with: exitProcess with: exitCode!

notifyThreadExit: exitProcess with: exitCode
	"@message void MSG_PROCESS_NOTIFY_THREAD_EXIT(ThreadHandle exitProcess = cx, word exitCode = dx)"
	^self geosMessage: #[32 1 2 53 1 1 0] with: exitProcess with: exitCode!

memFull: type
	"@message void MSG_PROCESS_MEM_FULL(word type = cx)"
	^self geosMessage: #[32 2 2 5 1 0] with: type!

createUiThread: newThread with: class with: stackSize
	"@message Boolean MSG_PROCESS_CREATE_UI_THREAD( ThreadHandle* newThread = multipleax, ClassStruct* class = cx:dx, word stackSize = bp)= carry"
	^self geosMessage: #[32 3 215 245 3 3 1 4] with: newThread with: class with: stackSize!

createEventThread: newThread with: class with: stackSize
	"@message Boolean MSG_PROCESS_CREATE_EVENT_THREAD( ThreadHandle* newThread = multipleax, ClassStruct* class = cx:dx, word stackSize = bp)= carry"
	^self geosMessage: #[32 4 215 245 3 3 1 4] with: newThread with: class with: stackSize!

instantiate
	"@message void MSG_PROCESS_INSTANTIATE()"
	^self geosMessage: #[32 5 2 0 0]!

exit
	"@message void MSG_PROCESS_EXIT()"
	^self geosMessage: #[32 6 2 0 0]!

startupUiThread
	"@message Boolean MSG_PROCESS_STARTUP_UI_THREAD()= carry"
	^self geosMessage: #[32 7 2 0 4]!

copyChunkIn
	"@message void MSG_PROCESS_COPY_CHUNK_IN()"
	^self geosMessage: #[32 8 2 0 0]!

copyChunkInFromOptr: destBlock with: source with: copyFlags
	"@message ChunkHandle MSG_PROCESS_COPY_CHUNK_IN_FROM_OPTR(@stack MemHandle destBlock, optr source, CopyChunkFlags copyFlags)= ax"
	^self geosMessage: #[32 8 96 8 1 2 1 1] with: destBlock with: source with: copyFlags!

copyChunkInFromFptr: destBlock with: source with: copyFlags
	"@message ChunkHandle MSG_PROCESS_COPY_CHUNK_IN_FROM_FPTR(@stack MemHandle destBlock, void *source, CopyChunkFlags copyFlags)= ax"
	^self geosMessage: #[32 8 96 8 1 3 1 1] with: destBlock with: source with: copyFlags!

copyChunkInFromHptr: destBlock with: srcBlockOffset with: srcBlock with: copyFlags
	"@message ChunkHandle MSG_PROCESS_COPY_CHUNK_IN_FROM_HPTR(@stack MemHandle destBlock, word srcBlockOffset, MemHandle srcBlock, CopyChunkFlags copyFlags)= ax"
	^self geosMessage: #[32 8 96 8 1 1 1 1 1] with: destBlock with: srcBlockOffset with: srcBlock with: copyFlags!

copyChunkOver
	"@message void MSG_PROCESS_COPY_CHUNK_OVER()"
	^self geosMessage: #[32 9 2 0 0]!

copyChunkOverOptr: dest with: source with: copyFlags
	"@message dword MSG_PROCESS_COPY_CHUNK_OVER_OPTR(@stack optr dest, optr source, CopyChunkFlags copyFlags)= cx:ax"
	^self geosMessage: #[32 9 144 10 2 2 1 2] with: dest with: source with: copyFlags!

copyChunkOverFptr: dest with: source with: copyFlags
	"@message dword MSG_PROCESS_COPY_CHUNK_OVER_FPTR(@stack optr dest, void *source, CopyChunkFlags copyFlags)= cx:ax"
	^self geosMessage: #[32 9 144 10 2 3 1 2] with: dest with: source with: copyFlags!

copyChunkOverHptr: dest with: srcBlockOffset with: srcBlock with: copyFlags
	"@message dword MSG_PROCESS_COPY_CHUNK_OVER_HPTR(@stack optr dest, word srcBlockOffset, MemHandle srcBlock, CopyChunkFlags copyFlags)= cx:ax"
	^self geosMessage: #[32 9 144 10 2 1 1 1 2] with: dest with: srcBlockOffset with: srcBlock with: copyFlags!

copyChunkOut
	"@message void MSG_PROCESS_COPY_CHUNK_OUT()"
	^self geosMessage: #[32 10 2 0 0]!

copyChunkOutToOptr: dest with: source with: copyFlags
	"@message dword MSG_PROCESS_COPY_CHUNK_OUT_TO_OPTR(@stack optr dest, optr source, CopyChunkFlags copyFlags)= cx:ax"
	^self geosMessage: #[32 10 144 10 2 2 1 2] with: dest with: source with: copyFlags!

copyChunkOutToFptr: dest with: source with: copyFlags
	"@message dword MSG_PROCESS_COPY_CHUNK_OUT_TO_FPTR(@stack void *dest, optr source, CopyChunkFlags copyFlags)= cx:ax"
	^self geosMessage: #[32 10 144 10 3 2 1 2] with: dest with: source with: copyFlags!

copyChunkOutToHptr: destBlockOffset with: destBlock with: source with: copyFlags
	"@message dword MSG_PROCESS_COPY_CHUNK_OUT_TO_HPTR(@stack word destBlockOffset, MemHandle destBlock, optr source, CopyChunkFlags copyFlags)= cx:ax"
	^self geosMessage: #[32 10 144 10 1 1 2 1 2] with: destBlockOffset with: destBlock with: source with: copyFlags!

flushProcessQueue
	"@message void MSG_PROCESS_FLUSH_PROCESS_QUEUE()"
	^self geosMessage: #[32 11 2 0 0]!

finalBlockFree: block
	"@message void MSG_PROCESS_FINAL_BLOCK_FREE(Handle block = cx)"
	^self geosMessage: #[32 12 2 5 1 0] with: block!

callRoutine: dataDI with: dataSI with: dataDX with: dataCX with: dataBX with: dataAX with: routine
	"@message void MSG_PROCESS_CALL_ROUTINE(@stack word dataDI, word dataSI, word dataDX, word dataCX, word dataBX, word dataAX, void (*routine)())"
	^self geosMessage: #[32 13 0 16 1 1 1 1 1 1 3 0] with: dataDI with: dataSI with: dataDX with: dataCX with: dataBX with: dataAX with: routine!

createEventThreadWithOwner: newThread with: class with: stackSize
	"@message void MSG_PROCESS_CREATE_EVENT_THREAD_WITH_OWNER( ThreadHandle* newThread = multipleax, ClassStruct* class = cx:dx, word stackSize = bp)= carry"
	^self geosMessage: #[32 14 215 245 3 3 1 0] with: newThread with: class with: stackSize!

objBlockDiscard: block
	"@message void MSG_PROCESS_OBJ_BLOCK_DISCARD(MemHandle block = cx)"
	^self geosMessage: #[32 15 2 5 1 0] with: block!

!

